/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.xlib.client.render;

import com.arisux.xlib.client.render.UV;
import com.arisux.xlib.client.render.XLibRenderer;
import net.minecraft.client.renderer.Tessellator;

public class Vertex {
    public static Vertex unitX = new Vertex(1, 0, 0);
    public static Vertex unitY = new Vertex(0, 1, 0);
    public static Vertex unitZ = new Vertex(0, 0, 1);
    public static Vertex unitNX = new Vertex(-1, 0, 0);
    public static Vertex unitNY = new Vertex(0, -1, 0);
    public static Vertex unitNZ = new Vertex(0, 0, -1);
    public static Vertex unitPYNZ = new Vertex(0.0, 0.707, -0.707);
    public static Vertex unitPXPY = new Vertex(0.707, 0.707, 0.0);
    public static Vertex unitPYPZ = new Vertex(0.0, 0.707, 0.707);
    public static Vertex unitNXPY = new Vertex(-0.707, 0.707, 0.0);
    public float x;
    public float y;
    public float z;

    public Vertex(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vertex(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public Vertex(int x, int y, int z) {
        this((float)x, (float)y, (float)z);
    }

    public Vertex smooth() {
        float sq = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x /= sq;
        this.y /= sq;
        this.z /= sq;
        return this;
    }

    public Vertex tessellate(Tessellator tessellator) {
        return this.tessellateWithUV(tessellator, null);
    }

    public Vertex tessellateWithUV(Tessellator tessellator, UV uv) {
        if (uv == null) {
            XLibRenderer.tessellator().func_178180_c().func_178984_b((double)this.x, (double)this.y, (double)this.z);
        } else {
            XLibRenderer.tessellator().func_178180_c().func_178985_a((double)this.x, (double)this.y, (double)this.z, (double)uv.getU(), (double)uv.getV());
        }
        return this;
    }

    public Vertex add(double x, double y, double z) {
        return new Vertex((double)this.x + x, (double)this.y + y, (double)this.z + z);
    }

    public Vertex add(Vertex v) {
        return this.add(v.x, v.y, v.z);
    }

    public Vertex mul(double c) {
        return new Vertex(c * (double)this.x, c * (double)this.y, c * (double)this.z);
    }

    public String toString() {
        return String.format("Vertex(%s, %s, %s)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

