/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.xlib.util.enums;

public enum ByteUnit {
    BIT(1L),
    BYTE(8L),
    KILOBYTE(BYTE.bits() * 1024L),
    KILOBIT(KILOBYTE.bits() / BYTE.bits()),
    MEGABYTE(KILOBYTE.bits() * 1024L),
    MEGABIT(MEGABYTE.bits() / BYTE.bits()),
    GIGABYTE(MEGABYTE.bits() * 1024L),
    GIGABIT(GIGABYTE.bits() / BYTE.bits()),
    TERABYTE(GIGABYTE.bits() * 1024L),
    TERABIT(TERABYTE.bits() / BYTE.bits()),
    PETABYTE(TERABYTE.bits() * 1024L),
    PETABIT(PETABYTE.bits() / BYTE.bits()),
    EXABYTE(PETABYTE.bits() * 1024L),
    EXABIT(EXABYTE.bits() / BYTE.bits()),
    ZETTABYTE(EXABYTE.bits() * 1024L),
    ZETTABIT(ZETTABYTE.bits() / BYTE.bits()),
    YOTTABYTE(ZETTABYTE.bits() * 1024L),
    YOTTABIT(YOTTABYTE.bits() / BYTE.bits());

    private long bits;

    private ByteUnit(long bits) {
        this.bits = bits;
    }

    public long bits() {
        return this.bits;
    }

    public long bytes() {
        return this.bits() / BYTE.bits();
    }

    public double convert(ByteUnit unitTo, double value) {
        return ByteUnit.convert(unitTo, this, value);
    }

    public static double convert(ByteUnit unitTo, ByteUnit unitFrom, double value) {
        return value * (double)unitFrom.bits() / (double)unitTo.bits();
    }

    public String toString() {
        return String.format(this.name(), this.bits());
    }
}

