/*
 * Decompiled with CFR 0.152.
 */
package com.arisux.xlib.client.render.ui;

import com.arisux.xlib.XLib;
import com.arisux.xlib.client.render.XLibRenderer;
import com.arisux.xlib.client.render.ui.UserInterface;
import com.arisux.xlib.client.render.ui.elements.ITooltipLineHandler;
import com.arisux.xlib.util.XLibMath;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class XLibUIRenderer {
    public static final int FONT_HEIGHT = 8;
    public static final String TOOLTIP_LINESPACE = "\u00a7h";
    public static final String TOOLTIP_HANDLER = "\u00a7x";
    private static ArrayList<ITooltipLineHandler> tipLineHandlers = new ArrayList();
    public static final UserInterface globalInterface = new UserInterface(){};

    public static FontRenderer fontRenderer() {
        return XLib.game().field_71466_p;
    }

    public static int getRenderWidth(String s) {
        return XLibUIRenderer.fontRenderer().func_78256_a(s);
    }

    public static void drawString(String s, int x, int y, int color, boolean shadow) {
        XLibUIRenderer.fontRenderer().func_175065_a(s, (float)x, (float)y, color, shadow);
    }

    public static void drawString(String s, int x, int y, int color) {
        XLibUIRenderer.drawString(s, x, y, color, true);
    }

    public static void drawString(String s, int x, int y) {
        XLibUIRenderer.drawString(s, x, y, -1);
    }

    public static void drawStringCentered(String s, int x, int y, int color, boolean shadow) {
        XLibUIRenderer.drawString(s, x - XLibUIRenderer.getRenderWidth(s) / 2, y, color, shadow);
    }

    public static void drawStringCentered(String s, int x, int y, int color) {
        XLibUIRenderer.drawStringCentered(s, x, y, color, true);
    }

    public static void drawStringCentered(String s, int x, int y) {
        XLibUIRenderer.drawStringCentered(s, x, y, -1);
    }

    public static void drawStringRight(String s, int x, int y, int color, boolean shadow) {
        XLibUIRenderer.drawString(s, x - XLibUIRenderer.getRenderWidth(s), y, color, shadow);
    }

    public static void drawStringRight(String s, int x, int y, int color) {
        XLibUIRenderer.drawStringRight(s, x, y, color, true);
    }

    public static void drawStringRight(String s, int x, int y) {
        XLibUIRenderer.drawStringRight(s, x, y, 0xFFFFFF);
    }

    public static ScaledResolution getScaledResolution() {
        return new ScaledResolution(XLib.game(), XLib.game().field_71443_c, XLib.game().field_71440_d);
    }

    public static Vec3 getScaledMousePosition() {
        ScaledResolution scaledResolution = XLibUIRenderer.getScaledResolution();
        int scaledMouseX = Mouse.getX() * scaledResolution.func_78326_a() / Display.getWidth();
        int scaledMouseY = scaledResolution.func_78328_b() - Mouse.getY() * scaledResolution.func_78328_b() / Display.getHeight();
        return new Vec3((double)scaledMouseX, (double)scaledMouseY, 0.0);
    }

    public static Dimension getDisplayResolution() {
        Minecraft mc = Minecraft.func_71410_x();
        return new Dimension(mc.field_71443_c, mc.field_71440_d);
    }

    public static Point getMouseLocation() {
        ScaledResolution size = XLibUIRenderer.getScaledResolution();
        Dimension res = XLibUIRenderer.getDisplayResolution();
        return new Point(Mouse.getX() * size.func_78326_a() / res.width, size.func_78328_b() - Mouse.getY() * size.func_78328_b() / res.height - 1);
    }

    public static int getTipLineId(ITooltipLineHandler handler) {
        tipLineHandlers.add(handler);
        return tipLineHandlers.size() - 1;
    }

    public static ITooltipLineHandler getTipLine(String line) {
        return !line.startsWith(TOOLTIP_HANDLER) ? null : tipLineHandlers.get(Integer.parseInt(line.substring(2)));
    }

    public static void drawMultilineToolTip(int x, int y, ArrayList<String> list) {
        ITooltipLineHandler line;
        if (list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        RenderHelper.func_74518_a();
        int w = 0;
        int h = -2;
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            line = XLibUIRenderer.getTipLine(s);
            Dimension d = line != null ? line.getSize() : new Dimension(XLibUIRenderer.getRenderWidth(s), list.get(i).endsWith(TOOLTIP_LINESPACE) && i + 1 < list.size() ? 12 : 10);
            w = Math.max(w, d.width);
            h += d.height;
        }
        if (x < 8) {
            x = 8;
        } else if (x > XLibUIRenderer.getScaledResolution().func_78326_a() - w - 8) {
            x -= 24 + w;
        }
        y = (int)XLibMath.clip(y, 8.0, XLibUIRenderer.getScaledResolution().func_78328_b() - 8 - h);
        globalInterface.incZLevel(300.0f);
        XLibUIRenderer.drawTooltipBox(x - 4, y - 4, w + 7, h + 7);
        for (String s : list) {
            line = XLibUIRenderer.getTipLine(s);
            if (line != null) {
                line.draw(x, y);
                y += line.getSize().height;
                continue;
            }
            XLibUIRenderer.drawString(s, x, y, -1);
            y += s.endsWith(TOOLTIP_LINESPACE) ? 12 : 10;
        }
        tipLineHandlers.clear();
        globalInterface.incZLevel(-300.0f);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public static void drawTooltipBox(int x, int y, int w, int h) {
        int bg = -267386864;
        XLibRenderer.drawQuadColored(x + 1, y, w - 1, 1, bg);
        XLibRenderer.drawQuadColored(x + 1, y + h, w - 1, 1, bg);
        XLibRenderer.drawQuadColored(x + 1, y + 1, w - 1, h - 1, bg);
        XLibRenderer.drawQuadColored(x, y + 1, 1, h - 1, bg);
        XLibRenderer.drawQuadColored(x + w, y + 1, 1, h - 1, bg);
        int grad1 = 0x505000FF;
        int grad2 = 1344798847;
        globalInterface.func_73733_a(x + 1, y + 2, 1, h - 3, grad1, grad2);
        globalInterface.func_73733_a(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        globalInterface.func_73733_a(x + 1, y + 1, w - 1, 1, grad1, grad1);
        globalInterface.func_73733_a(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }
}

