/*
 * Decompiled with CFR 0.152.
 */
package halocraft.api;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IPerspectiveState;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;

public class OBJModel
implements IRetexturableModel,
IModelCustomData {
    private MaterialLibrary matLib;
    private IModelState state;
    private final ResourceLocation location;

    public OBJModel(MaterialLibrary matLib, ResourceLocation location) {
        this.matLib = matLib;
        this.location = location;
    }

    public IModelState getModelState() {
        return this.state;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        Iterator materialIterator = this.matLib.materials.values().iterator();
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        while (materialIterator.hasNext()) {
            Material mat = (Material)materialIterator.next();
            ResourceLocation textureLoc = new ResourceLocation(mat.getTexture().getPath());
            if (textures.contains(textureLoc)) continue;
            textures.add(textureLoc);
        }
        return textures;
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TextureAtlasSprite missing = (TextureAtlasSprite)bakedTextureGetter.apply((Object)new ResourceLocation("missingno"));
        for (Map.Entry e : this.matLib.materials.entrySet()) {
            if (((Material)e.getValue()).getTexture().getTextureLocation().func_110623_a().startsWith("#")) {
                FMLLog.severe((String)"unresolved texture '%s' for obj model '%s'", (Object[])new Object[]{((Material)e.getValue()).getTexture().getTextureLocation().func_110623_a(), this.location});
                builder.put(e.getKey(), (Object)missing);
                continue;
            }
            builder.put(e.getKey(), bakedTextureGetter.apply((Object)((Material)e.getValue()).getTexture().getTextureLocation()));
        }
        builder.put((Object)"missingno", (Object)missing);
        return new OBJBakedModel(this, state, format, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
    }

    public TRSRTransformation getDefaultState() {
        return TRSRTransformation.identity();
    }

    public MaterialLibrary getMatLib() {
        return this.matLib;
    }

    public IModel process(ImmutableMap<String, String> customData) {
        return null;
    }

    private static String getLocation(String path) {
        if (path.endsWith(".png")) {
            path = path.substring(0, path.length() - ".png".length());
        }
        return path;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        MaterialLibrary lib = this.matLib;
        for (Map.Entry e : textures.entrySet()) {
            String name = (String)e.getKey();
            String loc = (String)e.getValue();
            if (name.equalsIgnoreCase("all")) {
                for (Map.Entry m : lib.materials.entrySet()) {
                    if (((String)m.getKey()).equals("OBJModel.White.Texture.Name")) continue;
                    ((Material)m.getValue()).getTexture().setPath(loc);
                }
                continue;
            }
            if (!lib.materials.containsKey(name)) continue;
            ((Material)lib.materials.get(name)).getTexture().setPath(loc);
        }
        return new OBJModel(lib, this.location);
    }

    private class OBJBakedModel
    implements IFlexibleBakedModel,
    ISmartBlockModel,
    ISmartItemModel,
    IPerspectiveAwareModel {
        private final OBJModel model;
        private final IModelState state;
        private final VertexFormat format;
        private final ByteBuffer buffer;
        private LinkedHashSet<BakedQuad> quads;
        private static final int BYTES_IN_INT = 4;
        private static final int VERTICES_IN_QUAD = 4;
        private Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
        private ImmutableMap<String, TextureAtlasSprite> textures;
        private final Map<IModelState, OBJBakedModel> cache = new HashMap<IModelState, OBJBakedModel>();

        public OBJBakedModel(OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures) {
            this.model = model;
            this.state = state;
            this.format = format;
            this.textures = textures;
            this.buffer = BufferUtils.createByteBuffer((int)(4 * format.func_177338_f()));
        }

        public List<BakedQuad> func_177551_a(EnumFacing side) {
            return Collections.emptyList();
        }

        public List<BakedQuad> func_177550_a() {
            if (this.quads == null) {
                this.quads = new LinkedHashSet();
                LinkedHashSet<Face> faces = new LinkedHashSet<Face>();
                for (Group e : this.model.getMatLib().getGroups().values()) {
                    LinkedHashSet fromSet = Sets.newLinkedHashSet(e.getFaces());
                    LinkedHashSet<Face> toSet = new LinkedHashSet<Face>();
                    if (e.getVisible()) {
                        e.applyTransform();
                        toSet.addAll(e.getFaces());
                        faces.addAll(e.getFaces());
                    }
                    Iterator fromIterator = fromSet.iterator();
                    Iterator toIterator = toSet.iterator();
                    while (fromIterator.hasNext() && toIterator.hasNext()) {
                        Face from = (Face)fromIterator.next();
                        Face to = (Face)toIterator.next();
                        this.model.getMatLib().replaceFaceInLibrary(from, to);
                    }
                }
                for (Face f : faces) {
                    this.buffer.clear();
                    String texture = ((Material)this.model.getMatLib().library.get(f)).getName();
                    if (this.state instanceof OBJState) {
                        if (((OBJState)this.state).parent != null && ((OBJState)this.state).parent instanceof TRSRTransformation) {
                            f = f.bake((TRSRTransformation)((OBJState)this.state).parent);
                        }
                    } else if (this.state instanceof TRSRTransformation) {
                        texture = ((Material)this.model.getMatLib().library.get(f)).getName();
                        f = f.bake((TRSRTransformation)this.state);
                    }
                    Object sprite = (TextureAtlasSprite)this.textures.get((Object)"missingno");
                    sprite = ((Material)this.model.getMatLib().materials.get(texture)).isWhite() ? ModelLoader.White.instance : (TextureAtlasSprite)this.textures.get((Object)texture);
                    float minU = 0.0f;
                    float maxU = 1.0f;
                    float minV = 0.0f;
                    float maxV = 1.0f;
                    if (f.texCoords != null && !f.areUVsNormalized()) {
                        for (TextureCoordinate t : f.texCoords) {
                            minU = t.getPosition().getX() < minU ? t.getPosition().getX() : minU;
                            maxU = t.getPosition().getX() > maxU ? t.getPosition().getX() : maxU;
                            minV = t.getPosition().getY() < minV ? t.getPosition().getY() : minV;
                            maxV = t.getPosition().getY() > maxV ? t.getPosition().getY() : maxV;
                        }
                        for (int i = 0; i < f.texCoords.length; ++i) {
                            TextureCoordinate t = f.texCoords[i];
                            float U = (t.getPosition().getX() - minU) / (maxU - minU);
                            float V = (t.getPosition().getY() - minV) / (maxV - minV);
                            Vector3f normPos = new Vector3f(U, V, t.getPosition().getZ());
                            ((Face)f).texCoords[i] = new TextureCoordinate(normPos);
                        }
                    }
                    TextureCoordinate def1 = new TextureCoordinate(new Vector3f(minU, minV, 1.0f));
                    TextureCoordinate def2 = new TextureCoordinate(new Vector3f(maxU, minV, 1.0f));
                    TextureCoordinate def3 = new TextureCoordinate(new Vector3f(maxU, maxV, 1.0f));
                    TextureCoordinate def4 = new TextureCoordinate(new Vector3f(minU, maxV, 1.0f));
                    this.putVertexData(f.verts[0], f.texCoords != null ? f.texCoords[0] : def1, f.norms != null ? f.norms[0] : f.getNormal(), (TextureAtlasSprite)sprite);
                    this.putVertexData(f.verts[1], f.texCoords != null ? f.texCoords[1] : def2, f.norms != null ? f.norms[1] : f.getNormal(), (TextureAtlasSprite)sprite);
                    this.putVertexData(f.verts[2], f.texCoords != null ? f.texCoords[2] : def3, f.norms != null ? f.norms[2] : f.getNormal(), (TextureAtlasSprite)sprite);
                    this.putVertexData(f.verts[3], f.texCoords != null ? f.texCoords[3] : def4, f.norms != null ? f.norms[3] : f.getNormal(), (TextureAtlasSprite)sprite);
                    this.buffer.flip();
                    int[] data = new int[4 * this.format.func_177338_f() / 4];
                    this.buffer.asIntBuffer().get(data);
                    this.quads.add((BakedQuad)new IColoredBakedQuad.ColoredBakedQuad(data, -1, EnumFacing.func_176737_a((float)((Normal)f.getNormal()).normal.x, (float)((Normal)f.getNormal()).normal.y, (float)((Normal)f.getNormal()).normal.z)));
                }
            }
            ArrayList<BakedQuad> quadList = new ArrayList<BakedQuad>();
            quadList.addAll(this.quads);
            return quadList;
        }

        private void put(ByteBuffer buffer, VertexFormatElement e, Float ... fs) {
            Attributes.put((ByteBuffer)buffer, (VertexFormatElement)e, (boolean)true, (Number)Float.valueOf(0.0f), (Number[])fs);
        }

        private final void putVertexData(Vertex v, TextureCoordinate t, Normal n, TextureAtlasSprite sprite) {
            int oldPos = this.buffer.position();
            Number[] ns = new Number[16];
            for (int i = 0; i < ns.length; ++i) {
                ns[i] = Float.valueOf(0.0f);
            }
            for (VertexFormatElement e : this.format.func_177343_g()) {
                switch (e.func_177375_c()) {
                    case POSITION: {
                        this.put(this.buffer, e, Float.valueOf(((Vertex)v).position.x), Float.valueOf(((Vertex)v).position.y), Float.valueOf(((Vertex)v).position.z), Float.valueOf(1.0f));
                        break;
                    }
                    case COLOR: {
                        if (v.color != null) {
                            this.put(this.buffer, e, Float.valueOf(((Vertex)v).color.x), Float.valueOf(((Vertex)v).color.y), Float.valueOf(((Vertex)v).color.z), Float.valueOf(((Vertex)v).color.w));
                            break;
                        }
                        this.put(this.buffer, e, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
                        break;
                    }
                    case UV: {
                        if (t != null) {
                            this.put(this.buffer, e, Float.valueOf(sprite.func_94214_a((double)(t.getPosition().x * 16.0f))), Float.valueOf(sprite.func_94207_b((double)(t.getPosition().y * 16.0f))), Float.valueOf(0.0f), Float.valueOf(1.0f));
                            break;
                        }
                        this.put(this.buffer, e, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f));
                        break;
                    }
                    case NORMAL: {
                        this.put(this.buffer, e, Float.valueOf(((Normal)n).normal.x), Float.valueOf(((Normal)n).normal.y), Float.valueOf(((Normal)n).normal.z), Float.valueOf(1.0f));
                        break;
                    }
                    case GENERIC: {
                        this.put(this.buffer, e, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
                        break;
                    }
                }
            }
            this.buffer.position(oldPos + this.format.func_177338_f());
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return (TextureAtlasSprite)this.textures.get((Object)0);
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public VertexFormat getFormat() {
            return this.format;
        }

        public IBakedModel handleItemState(ItemStack stack) {
            return this;
        }

        public OBJBakedModel handleBlockState(IBlockState state) {
            OBJState s;
            IExtendedBlockState exState;
            if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains((Object)OBJProperty.instance) && (s = (OBJState)exState.getValue((IUnlistedProperty)OBJProperty.instance)) != null) {
                return this.getCachedModel(s);
            }
            return this;
        }

        public OBJBakedModel getCachedModel(IModelState state) {
            if (!this.cache.containsKey(state)) {
                this.cache.put(state, new OBJBakedModel(this.model, state, this.format, this.textures));
            }
            return this.cache.get(state);
        }

        public OBJModel getModel() {
            return this.model;
        }

        public IModelState getState() {
            return this.state;
        }

        public OBJBakedModel getBakedModel() {
            return new OBJBakedModel(this.model, this.state, this.format, this.textures);
        }

        public Pair<IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (this.state instanceof IPerspectiveState) {
                return Pair.of((Object)this, (Object)TRSRTransformation.blockCornerToCenter((TRSRTransformation)((IPerspectiveState)this.state).forPerspective(cameraTransformType).apply((IModelPart)this.model)).getMatrix());
            }
            return Pair.of((Object)this, null);
        }

        public String toString() {
            return this.model.location.toString();
        }
    }

    public static enum OBJProperty implements IUnlistedProperty<OBJState>
    {
        instance;


        public String getName() {
            return "OBJPropery";
        }

        public boolean isValid(OBJState value) {
            return value instanceof OBJState;
        }

        public Class<OBJState> getType() {
            return OBJState.class;
        }

        public String valueToString(OBJState value) {
            return value.toString();
        }
    }

    public static class OBJState
    implements IModelState {
        private OBJModel model;
        private Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
        public IModelState parent;

        public OBJState(IModelState parent, List<String> visibleGroups, boolean visibility) {
            this.parent = this.getParent(parent);
            for (String s : visibleGroups) {
                this.visibilityMap.put(s, visibility);
            }
        }

        public OBJModel getModel() {
            return this.model;
        }

        public void setModel(OBJModel model) {
            this.model = model;
        }

        private IModelState getParent(IModelState parent) {
            if (parent == null) {
                return TRSRTransformation.identity();
            }
            if (parent instanceof OBJState) {
                return ((OBJState)parent).parent;
            }
            return parent;
        }

        public TRSRTransformation apply(IModelPart part) {
            TRSRTransformation ret = TRSRTransformation.identity();
            if (this.parent != null) {
                ret = this.parent.apply(part).compose(this.composePart(part));
            }
            return ret;
        }

        private TRSRTransformation composePart(IModelPart part) {
            TRSRTransformation ret = TRSRTransformation.identity();
            if (part instanceof Group) {
                Group element = (Group)part;
                ret = ret.compose(element.getTransform());
                Matrix4f matrix = ret.getMatrix();
                matrix.invert();
                ret = ret.compose(new TRSRTransformation(matrix));
            }
            return ret;
        }

        public Map<String, Boolean> getVisibilityMap() {
            return this.visibilityMap;
        }

        public List<String> getGroupsWithVisibility(boolean visibility) {
            ArrayList<String> ret = new ArrayList<String>();
            for (Map.Entry<String, Boolean> e : this.visibilityMap.entrySet()) {
                if (e.getValue() != visibility) continue;
                ret.add(e.getKey());
            }
            return ret;
        }

        public List<String> getGroupNamesFromMap() {
            ArrayList<String> ret = new ArrayList<String>();
            ret.addAll(this.visibilityMap.keySet());
            return ret;
        }

        public void changeGroupVisibilities(List<String> names, Operation operation) {
            if (names == null || names.isEmpty()) {
                return;
            }
            if (names.get(0).equals("OBJModel.Group.All.Key")) {
                for (String s : this.visibilityMap.keySet()) {
                    if (operation == Operation.SET_TRUE) {
                        this.visibilityMap.put(s, true);
                        continue;
                    }
                    if (operation == Operation.SET_FALSE) {
                        this.visibilityMap.put(s, false);
                        continue;
                    }
                    if (operation != Operation.TOGGLE) continue;
                    this.visibilityMap.put(s, this.visibilityMap.get(s) == false);
                }
            } else if (names.get(0).equals("OBJModel.Group.All.Except.Key")) {
                List<String> exceptList = names.subList(1, names.size());
                for (String e : this.visibilityMap.keySet()) {
                    if (exceptList.contains(e)) continue;
                    if (operation == Operation.SET_TRUE) {
                        this.visibilityMap.put(e, true);
                        continue;
                    }
                    if (operation == Operation.SET_FALSE) {
                        this.visibilityMap.put(e, false);
                        continue;
                    }
                    if (operation != Operation.TOGGLE) continue;
                    this.visibilityMap.put(e, this.visibilityMap.get(e) == false);
                }
            } else {
                for (String s : names) {
                    if (operation == Operation.SET_TRUE) {
                        this.visibilityMap.put(s, true);
                        continue;
                    }
                    if (operation == Operation.SET_FALSE) {
                        this.visibilityMap.put(s, false);
                        continue;
                    }
                    if (operation != Operation.TOGGLE) continue;
                    this.visibilityMap.put(s, this.visibilityMap.get(s) == false);
                }
            }
            this.applyVisibilities();
        }

        private void applyVisibilities() {
            if (this.model != null) {
                for (String s : this.visibilityMap.keySet()) {
                    if (!this.model.getMatLib().getGroups().containsKey(s)) continue;
                    this.model.getMatLib().getGroups().get(s).setVisible(this.visibilityMap.get(s));
                }
            }
        }

        public static enum Operation {
            SET_TRUE,
            SET_FALSE,
            TOGGLE;

        }
    }

    public static class Group
    implements IModelPart {
        public static final String DEFAULT_NAME = "OBJModel.Default.Element.Name";
        public static final String ALL = "OBJModel.Group.All.Key";
        public static final String ALL_EXCEPT = "OBJModel.Group.All.Except.Key";
        private String name = "OBJModel.Default.Element.Name";
        private TRSRTransformation transform = TRSRTransformation.identity();
        private LinkedHashSet<Face> faces = new LinkedHashSet();
        private boolean visible = true;

        public Group(String name, LinkedHashSet<Face> faces) {
            this(name, TRSRTransformation.identity(), faces);
        }

        public Group(String name, TRSRTransformation transform, LinkedHashSet<Face> faces) {
            this.name = name != null ? name : DEFAULT_NAME;
            this.transform = transform;
            this.faces = faces == null ? new LinkedHashSet() : faces;
        }

        public void applyTransform() {
            LinkedHashSet<Face> faceSet = new LinkedHashSet<Face>();
            for (Face f : this.faces) {
                faceSet.add(f.bake(this.transform));
            }
            this.faces = faceSet;
        }

        public String getName() {
            return this.name;
        }

        public void setTransform(TRSRTransformation transform) {
            this.transform = transform == null ? TRSRTransformation.identity() : transform;
        }

        public TRSRTransformation getTransform() {
            return this.transform;
        }

        public LinkedHashSet<Face> getFaces() {
            return this.faces;
        }

        public void setFaces(LinkedHashSet<Face> faces) {
            this.faces = faces;
        }

        public void addFace(Face face) {
            this.faces.add(face);
        }

        public void addFaces(List<Face> faces) {
            this.faces.addAll(faces);
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean getVisible() {
            return this.visible;
        }
    }

    public static class TextureCoordinate {
        private Vector3f position;

        public TextureCoordinate(Vector3f position) {
            this.position = position;
        }

        public void setPosition(Vector3f position) {
            this.position = position;
        }

        public Vector3f getPosition() {
            return this.position;
        }
    }

    public static class Normal {
        private Vector3f normal;

        public Normal(Vector3f normal) {
            this.normal = normal;
        }

        public void setNormal(Vector3f normal) {
            this.normal = normal;
        }

        public Vector3f getNormal() {
            return this.normal;
        }
    }

    public static class Vertex {
        private Vector4f position;
        private Vector4f color;

        public Vertex(Vector4f position, Vector4f color) {
            this.position = position;
            this.color = color;
        }

        public void setPos(Vector4f position) {
            this.position = position;
        }

        public Vector4f getPosition() {
            return this.position;
        }

        public void setColor(Vector4f color) {
            this.color = color;
        }

        public Vector4f getColor() {
            return this.color;
        }

        public Vertex bake(TRSRTransformation transform) {
            Matrix4f t = new Matrix4f();
            if (transform == TRSRTransformation.identity()) {
                t.setIdentity();
            } else {
                t.add(transform.getMatrix());
            }
            Vector4f pos = new Vector4f(this.position);
            Vector4f newPos = new Vector4f();
            pos.w = 1.0f;
            t.transform((Tuple4f)pos, (Tuple4f)newPos);
            Vector4f rPos = new Vector4f(newPos.x / newPos.w, newPos.y / newPos.w, newPos.z / newPos.w, newPos.w);
            return new Vertex(rPos, this.color);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("v:%n", new Object[0]));
            builder.append(String.format("    position: %s %s %s%n", Float.valueOf(this.position.x), Float.valueOf(this.position.y), Float.valueOf(this.position.z)));
            builder.append(String.format("    color: %s %s %s %s%n", Float.valueOf(this.color.x), Float.valueOf(this.color.y), Float.valueOf(this.color.z), Float.valueOf(this.color.w)));
            return builder.toString();
        }
    }

    public static class Face {
        private Vertex[] verts = new Vertex[4];
        private Normal[] norms = new Normal[4];
        private TextureCoordinate[] texCoords = new TextureCoordinate[4];

        public Face(Vertex[] verts) {
            this(verts, new Normal[0], new TextureCoordinate[0]);
        }

        public Face(Vertex[] verts, Normal[] norms) {
            this(verts, norms, null);
        }

        public Face(Vertex[] verts, TextureCoordinate[] texCoords) {
            this(verts, null, texCoords);
        }

        public Face(Vertex[] verts, Normal[] norms, TextureCoordinate[] texCoords) {
            this.verts = verts;
            this.verts = this.verts != null && this.verts.length > 0 ? this.verts : null;
            this.norms = norms;
            this.norms = this.norms != null && this.norms.length > 0 ? this.norms : null;
            this.texCoords = texCoords;
            this.texCoords = this.texCoords != null && this.texCoords.length > 0 ? this.texCoords : null;
            this.ensureQuads();
        }

        private void ensureQuads() {
            if (this.verts != null && this.verts.length == 3) {
                this.verts = new Vertex[]{this.verts[0], this.verts[1], this.verts[2], this.verts[2]};
            }
            if (this.norms != null && this.norms.length == 3) {
                this.norms = new Normal[]{this.norms[0], this.norms[1], this.norms[2], this.norms[2]};
            }
            if (this.texCoords != null && this.texCoords.length == 3) {
                this.texCoords = new TextureCoordinate[]{this.texCoords[0], this.texCoords[1], this.texCoords[2], this.texCoords[2]};
            }
        }

        public boolean setVertices(Vertex[] verts) {
            if (verts == null) {
                return false;
            }
            this.verts = verts;
            return true;
        }

        public Vertex[] getVertices() {
            return this.verts;
        }

        public boolean setNormals(Normal[] norms) {
            if (norms == null) {
                return false;
            }
            this.norms = norms;
            return true;
        }

        public Normal[] getNormals() {
            return this.norms;
        }

        public boolean setTextureCoordinates(TextureCoordinate[] texCoords) {
            if (texCoords == null) {
                return false;
            }
            this.texCoords = texCoords;
            return true;
        }

        public TextureCoordinate[] getTextureCoordinates() {
            return this.texCoords;
        }

        public boolean areUVsNormalized() {
            for (TextureCoordinate t : this.texCoords) {
                if (t.getPosition().getX() > 0.0f && t.getPosition().getX() < 1.0f && t.getPosition().getY() > 0.0f && t.getPosition().getY() < 1.0f) continue;
                return false;
            }
            return true;
        }

        public Face bake(TRSRTransformation transform) {
            Matrix4f t = new Matrix4f();
            if (transform == TRSRTransformation.identity()) {
                t.setIdentity();
            }
            for (int i = 0; i < this.verts.length; ++i) {
                t = transform.getMatrix();
                Vertex v = this.verts[i];
                TextureCoordinate tc = this.texCoords != null ? this.texCoords[i] : null;
                Normal n = this.norms != null ? this.norms[i] : null;
                Vector4f pos = new Vector4f(v.getPosition());
                Vector4f newPos = new Vector4f();
                pos.w = 1.0f;
                t.transform((Tuple4f)pos, (Tuple4f)newPos);
                Vector4f rPos = new Vector4f(newPos.x, newPos.y, newPos.z, newPos.w);
                this.verts[i] = new Vertex(rPos, v.getColor());
                if (n == null) continue;
                t.invert();
                t.transpose();
                Vector4f normal = new Vector4f((Tuple3f)n.getNormal());
                Vector4f newNormal = new Vector4f();
                normal.w = 1.0f;
                t.transform((Tuple4f)normal, (Tuple4f)newNormal);
                Vector3f rNormal = new Vector3f(newNormal.x / newNormal.w, newNormal.y / newNormal.w, newNormal.z / newNormal.w);
                rNormal.normalize();
                this.norms[i] = new Normal(rNormal);
            }
            return new Face(this.verts, this.norms, this.texCoords);
        }

        public Normal getNormal() {
            Vector3f n4;
            if (this.norms == null) {
                Vector3f v4;
                Vector3f v1 = new Vector3f(this.verts[0].getPosition().x, this.verts[0].getPosition().y, this.verts[0].getPosition().z);
                Vector3f v2 = new Vector3f(this.verts[1].getPosition().x, this.verts[1].getPosition().y, this.verts[1].getPosition().z);
                Vector3f v3 = new Vector3f(this.verts[2].getPosition().x, this.verts[2].getPosition().y, this.verts[2].getPosition().z);
                Vector3f vector3f = v4 = this.verts.length > 3 ? new Vector3f(this.verts[3].getPosition().x, this.verts[3].getPosition().y, this.verts[3].getPosition().z) : null;
                if (v4 == null) {
                    Vector3f v2c = new Vector3f(v2.x, v2.y, v2.z);
                    Vector3f v1c = new Vector3f(v1.x, v1.y, v1.z);
                    v1c.sub((Tuple3f)v2c);
                    Vector3f v3c = new Vector3f(v3.x, v3.y, v3.z);
                    v3c.sub((Tuple3f)v2c);
                    Vector3f c = new Vector3f();
                    c.cross(v1c, v3c);
                    c.normalize();
                    Normal normal = new Normal(c);
                    return normal;
                }
                Vector3f v2c = new Vector3f(v2.x, v2.y, v2.z);
                Vector3f v1c = new Vector3f(v1.x, v1.y, v1.z);
                v1c.sub((Tuple3f)v2c);
                Vector3f v3c = new Vector3f(v3.x, v3.y, v3.z);
                v3c.sub((Tuple3f)v2c);
                Vector3f c = new Vector3f();
                c.cross(v1c, v3c);
                c.normalize();
                v1c = new Vector3f(v1.x, v1.y, v1.z);
                v3c = new Vector3f(v3.x, v3.y, v3.z);
                Vector3f v4c = new Vector3f(v4.x, v4.y, v4.z);
                v1c.sub((Tuple3f)v4c);
                v3c.sub((Tuple3f)v4c);
                Vector3f d = new Vector3f();
                d.cross(v1c, v3c);
                d.normalize();
                Vector3f avg = new Vector3f();
                avg.x = (c.x + d.x) * 0.5f;
                avg.y = (c.y + d.y) * 0.5f;
                avg.z = (c.z + d.z) * 0.5f;
                avg.normalize();
                Normal normal = new Normal(avg);
                return normal;
            }
            Vector3f n1 = this.norms[0].getNormal();
            Vector3f n2 = this.norms[1].getNormal();
            Vector3f n3 = this.norms[2].getNormal();
            Vector3f vector3f = n4 = this.norms.length > 3 ? this.norms[3].getNormal() : null;
            if (n4 == null) {
                Vector3f n2c = new Vector3f(n2.x, n2.y, n2.z);
                Vector3f n1c = new Vector3f(n1.x, n1.y, n1.z);
                n1c.sub((Tuple3f)n2c);
                Vector3f n3c = new Vector3f(n3.x, n3.y, n3.z);
                n3c.sub((Tuple3f)n2c);
                Vector3f c = new Vector3f();
                c.cross(n1c, n3c);
                c.normalize();
                Normal normal = new Normal(c);
                return normal;
            }
            Vector3f n2c = new Vector3f(n2.x, n2.y, n2.z);
            Vector3f n1c = new Vector3f(n1.x, n1.y, n1.z);
            n1c.sub((Tuple3f)n2c);
            Vector3f n3c = new Vector3f(n3.x, n3.y, n3.z);
            n3c.sub((Tuple3f)n2c);
            Vector3f c = new Vector3f();
            c.cross(n1c, n3c);
            c.normalize();
            n1c = new Vector3f(n1.x, n1.y, n1.z);
            n3c = new Vector3f(n3.x, n3.y, n3.z);
            Vector3f n4c = new Vector3f(n4.x, n4.y, n4.z);
            n1c.sub((Tuple3f)n4c);
            n3c.sub((Tuple3f)n4c);
            Vector3f d = new Vector3f();
            d.cross(n1c, n3c);
            d.normalize();
            Vector3f avg = new Vector3f();
            avg.x = (c.x + d.x) * 0.5f;
            avg.y = (c.y + d.y) * 0.5f;
            avg.z = (c.z + d.z) * 0.5f;
            avg.normalize();
            Normal normal = new Normal(avg);
            return normal;
        }
    }

    public static class Texture {
        public static Texture White = new Texture("builtin/white", new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        private String path;
        private Vector2f position;
        private Vector2f scale;
        private float rotation;

        public Texture(String path) {
            this(path, new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        }

        public Texture(String path, Vector2f position, Vector2f scale, float rotation) {
            this.path = path;
            this.position = position;
            this.scale = scale;
            this.rotation = rotation;
        }

        public ResourceLocation getTextureLocation() {
            ResourceLocation loc = new ResourceLocation(this.path);
            return loc;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPosition(Vector2f position) {
            this.position = position;
        }

        public Vector2f getPosition() {
            return this.position;
        }

        public void setScale(Vector2f scale) {
            this.scale = scale;
        }

        public Vector2f getScale() {
            return this.scale;
        }

        public void setRotation(float rotation) {
            this.rotation = rotation;
        }

        public float getRotation() {
            return this.rotation;
        }
    }

    public static class Material {
        public static final String WHITE_NAME = "OBJModel.White.Texture.Name";
        public static final String DEFAULT_NAME = "OBJModel.Default.Texture.Name";
        private Vector4f color;
        private Texture texture = Texture.White;
        private String name = "OBJModel.Default.Texture.Name";

        public Material() {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        }

        public Material(Vector4f color) {
            this(color, Texture.White, WHITE_NAME);
        }

        public Material(Texture texture) {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), texture, DEFAULT_NAME);
        }

        public Material(Vector4f color, Texture texture, String name) {
            this.color = color;
            this.texture = texture;
            this.name = name != null ? name : DEFAULT_NAME;
        }

        public void setName(String name) {
            this.name = name != null ? name : DEFAULT_NAME;
        }

        public String getName() {
            return this.name;
        }

        public void setColor(Vector4f color) {
            this.color = color;
        }

        public Vector4f getColor() {
            return this.color;
        }

        public void setTexture(Texture texture) {
            this.texture = texture;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public boolean isWhite() {
            return this.texture.equals(Texture.White);
        }
    }

    public class MaterialLibrary {
        private Set<String> unknownMaterialCommands = new HashSet<String>();
        private Map<String, Material> materials = new HashMap<String, Material>();
        private Map<Face, Material> library = new HashMap<Face, Material>();
        private Map<String, Group> groups = new HashMap<String, Group>();
        private InputStreamReader mtlStream;
        private BufferedReader mtlReader;
        private float minU = 0.0f;
        private float maxU = 1.0f;
        private float minV = 0.0f;
        private float maxV = 1.0f;

        public MaterialLibrary() {
            this.groups.put("OBJModel.Default.Element.Name", new Group("OBJModel.Default.Element.Name", null));
        }

        public float getMinU() {
            return this.minU;
        }

        public float getMaxU() {
            return this.maxU;
        }

        public float getMinV() {
            return this.minV;
        }

        public float getMaxV() {
            return this.maxV;
        }

        public void setUVBounds(float minU, float maxU, float minV, float maxV) {
            this.minU = minU;
            this.maxU = maxU;
            this.minV = minV;
            this.maxV = maxV;
        }

        public Map<String, Group> getGroups() {
            return this.groups;
        }

        public void replaceFaceInLibrary(Face from, Face to) {
            Material mat = this.library.get(from);
            if (mat != null) {
                this.library.remove(from);
                this.library.put(to, mat);
            }
        }

        public void parseMaterials(IResourceManager manager, String path, ResourceLocation from) throws IOException {
            this.materials.clear();
            boolean hasSetTexture = false;
            boolean hasSetColor = false;
            String domain = from.func_110624_b();
            if (!path.contains("models/block/") && !path.contains("models/item/")) {
                if (from.func_110623_a().contains("models/block/")) {
                    path = "models/block/" + path;
                } else if (from.func_110623_a().contains("models/item/")) {
                    path = "models/item/" + path;
                }
            }
            this.mtlStream = new InputStreamReader(manager.func_110536_a(new ResourceLocation(domain, path)).func_110527_b(), Charsets.UTF_8);
            this.mtlReader = new BufferedReader(this.mtlStream);
            String currentLine = "";
            Material material = new Material();
            material.setName("OBJModel.White.Texture.Name");
            material.setTexture(Texture.White);
            this.materials.put("OBJModel.White.Texture.Name", material);
            while ((currentLine = this.mtlReader.readLine()) != null) {
                if (currentLine.isEmpty() || currentLine.startsWith("#")) continue;
                String[] fields = currentLine.split(" ", 2);
                String key = fields[0];
                String data = fields[1];
                if (key.equalsIgnoreCase("newmtl")) {
                    hasSetColor = false;
                    hasSetTexture = false;
                    material = new Material();
                    material.setName(data);
                    this.materials.put(data, material);
                    continue;
                }
                if (key.equalsIgnoreCase("Ka") || key.equalsIgnoreCase("Kd") || key.equalsIgnoreCase("Ks")) {
                    if (!hasSetColor) {
                        String[] rgbStrings = data.split(" ", 3);
                        Vector4f color = new Vector4f(Float.parseFloat(rgbStrings[0]), Float.parseFloat(rgbStrings[1]), Float.parseFloat(rgbStrings[2]), 1.0f);
                        hasSetColor = true;
                        material.setColor(color);
                        continue;
                    }
                    FMLLog.info((String)"OBJModel: A color has already been defined for material '%s' in '%s'. The color defined by key '%s' will not be applied!", (Object[])new Object[]{material.getName(), new ResourceLocation(domain, path).toString(), key});
                    continue;
                }
                if (key.equalsIgnoreCase("map_Ka") || key.equalsIgnoreCase("map_Kd") || key.equalsIgnoreCase("map_Ks")) {
                    if (!hasSetTexture) {
                        if (data.contains(" ")) {
                            String[] mapStrings = data.split(" ");
                            String texturePath = mapStrings[mapStrings.length - 1];
                            Texture texture = new Texture(texturePath);
                            hasSetTexture = true;
                            material.setTexture(texture);
                            continue;
                        }
                        Texture texture = new Texture(data);
                        hasSetTexture = true;
                        material.setTexture(texture);
                        continue;
                    }
                    FMLLog.info((String)"OBJModel: A texture has already been defined for material '%s' in '%s'. The texture defined by key '%s' will not be applied!", (Object[])new Object[]{material.getName(), new ResourceLocation(domain, path).toString(), key});
                    continue;
                }
                if (this.unknownMaterialCommands.contains(key)) continue;
                this.unknownMaterialCommands.add(key);
                FMLLog.info((String)"OBJLoader.MaterialLibrary: command '%s' (model: '%s') is not currently supported, skipping", (Object[])new Object[]{key, new ResourceLocation(domain, path)});
            }
        }
    }

    public static class Parser {
        private static Set<String> unknownObjectCommands = new HashSet<String>();
        public MaterialLibrary materialLibrary = new OBJModel(null, null).new MaterialLibrary();
        private IResourceManager manager;
        private InputStreamReader objStream;
        private BufferedReader objReader;
        private ResourceLocation objFrom;
        private List<String> elementList = new ArrayList<String>();
        private List<Vertex> vertices = new ArrayList<Vertex>();
        private List<Normal> normals = new ArrayList<Normal>();
        private List<TextureCoordinate> texCoords = new ArrayList<TextureCoordinate>();
        private float minU = 0.0f;
        private float maxU = 1.0f;
        private float minV = 0.0f;
        private float maxV = 1.0f;

        public Parser(IResource from, IResourceManager manager) throws IOException {
            this.manager = manager;
            this.objFrom = from.func_177241_a();
            this.objStream = new InputStreamReader(from.func_110527_b(), Charsets.UTF_8);
            this.objReader = new BufferedReader(this.objStream);
        }

        public List<String> getElements() {
            return this.elementList;
        }

        public OBJModel parse() throws IOException {
            String currentLine = "";
            Material material = new Material();
            int usemtlCounter = 0;
            while ((currentLine = this.objReader.readLine()) != null) {
                String[] splitSpace;
                float[] floatSplitData;
                String[] splitData;
                if (currentLine.isEmpty() || currentLine.startsWith("#")) continue;
                String[] fields = currentLine.split(" ", 2);
                String key = fields[0];
                String data = fields[1];
                if (key.equalsIgnoreCase("mtllib")) {
                    this.materialLibrary.parseMaterials(this.manager, data, this.objFrom);
                    continue;
                }
                if (key.equalsIgnoreCase("usemtl")) {
                    material = (Material)this.materialLibrary.materials.get(data);
                    ++usemtlCounter;
                    continue;
                }
                if (key.equalsIgnoreCase("v")) {
                    splitData = data.split(" ");
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    Vector4f pos = new Vector4f(floatSplitData[0], floatSplitData[1], floatSplitData[2], floatSplitData.length == 4 ? floatSplitData[3] : 1.0f);
                    Vector4f color = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                    if (material.isWhite()) {
                        color = material.getColor();
                    }
                    Vertex vertex = new Vertex(pos, color);
                    this.vertices.add(vertex);
                    continue;
                }
                if (key.equalsIgnoreCase("vn")) {
                    splitData = data.split(" ");
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    Normal normal = new Normal(new Vector3f(floatSplitData[0], floatSplitData[1], floatSplitData[2]));
                    this.normals.add(normal);
                    continue;
                }
                if (key.equalsIgnoreCase("vt")) {
                    splitData = data.split(" ");
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    TextureCoordinate texCoord = new TextureCoordinate(new Vector3f(floatSplitData[0], floatSplitData[1], floatSplitData.length == 3 ? floatSplitData[2] : 1.0f));
                    if (floatSplitData[0] < this.minU) {
                        this.minU = floatSplitData[0];
                    } else if (floatSplitData[0] > this.maxU) {
                        this.maxU = floatSplitData[0];
                    }
                    if (floatSplitData[1] < this.minV) {
                        this.minV = floatSplitData[1];
                    } else if (floatSplitData[1] > this.maxV) {
                        this.maxV = floatSplitData[1];
                    }
                    this.texCoords.add(texCoord);
                    continue;
                }
                if (key.equalsIgnoreCase("f")) {
                    splitSpace = data.split(" ");
                    String[][] splitSlash = new String[splitSpace.length][];
                    int vert = 0;
                    int texCoord = 0;
                    int norm = 0;
                    ArrayList<Vertex> v = new ArrayList<Vertex>(splitSpace.length);
                    ArrayList<TextureCoordinate> t = new ArrayList<TextureCoordinate>(splitSpace.length);
                    ArrayList<Normal> n = new ArrayList<Normal>(splitSpace.length);
                    for (int i = 0; i < splitSpace.length; ++i) {
                        if (splitSpace[i].contains("//")) {
                            splitSlash[i] = splitSpace[i].split("//");
                            vert = Integer.parseInt(splitSlash[i][0]);
                            vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                            norm = Integer.parseInt(splitSlash[i][1]);
                            norm = norm < 0 ? this.normals.size() - 1 : norm - 1;
                            v.add(this.vertices.get(vert));
                            n.add(this.normals.get(norm));
                            continue;
                        }
                        if (splitSpace[i].contains("/")) {
                            splitSlash[i] = splitSpace[i].split("/");
                            vert = Integer.parseInt(splitSlash[i][0]);
                            vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                            texCoord = Integer.parseInt(splitSlash[i][1]);
                            int n2 = texCoord = texCoord < 0 ? this.texCoords.size() - 1 : texCoord - 1;
                            if (splitSlash[i].length > 2) {
                                norm = Integer.parseInt(splitSlash[i][2]);
                                norm = norm < 0 ? this.normals.size() - 1 : norm - 1;
                            }
                            v.add(this.vertices.get(vert));
                            t.add(this.texCoords.get(texCoord));
                            if (splitSlash[i].length <= 2) continue;
                            n.add(this.normals.get(norm));
                            continue;
                        }
                        splitSlash[i] = splitSpace[i].split("");
                        vert = Integer.parseInt(splitSlash[i][0]);
                        vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                        v.add(this.vertices.get(vert));
                    }
                    Vertex[] va = new Vertex[v.size()];
                    v.toArray(va);
                    TextureCoordinate[] ta = new TextureCoordinate[t.size()];
                    t.toArray(ta);
                    Normal[] na = new Normal[n.size()];
                    n.toArray(na);
                    Face face = new Face(va, na, ta);
                    if (usemtlCounter < this.vertices.size()) {
                        for (Vertex ver : face.getVertices()) {
                            ver.setColor(material.getColor());
                        }
                        this.materialLibrary.library.put(face, material);
                    } else {
                        this.materialLibrary.library.put(face, this.materialLibrary.materials.get("OBJModel.White.Texture.Name"));
                    }
                    if (this.elementList.isEmpty()) {
                        if (this.materialLibrary.getGroups().containsKey("OBJModel.Default.Element.Name")) {
                            this.materialLibrary.getGroups().get("OBJModel.Default.Element.Name").addFace(face);
                            continue;
                        }
                        Group def = new Group("OBJModel.Default.Element.Name", null);
                        def.addFace(face);
                        this.materialLibrary.getGroups().put("OBJModel.Default.Element.Name", def);
                        continue;
                    }
                    for (String s : this.elementList) {
                        if (this.materialLibrary.getGroups().containsKey(s)) {
                            this.materialLibrary.getGroups().get(s).addFace(face);
                            continue;
                        }
                        Group e = new Group(s, null);
                        e.addFace(face);
                        this.materialLibrary.getGroups().put(s, e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("g") || key.equalsIgnoreCase("o")) {
                    this.elementList.clear();
                    if (key.equalsIgnoreCase("g")) {
                        for (String s : splitSpace = data.split(" ")) {
                            this.elementList.add(s);
                        }
                        continue;
                    }
                    this.elementList.add(data);
                    continue;
                }
                if (unknownObjectCommands.contains(key)) continue;
                unknownObjectCommands.add(key);
                FMLLog.info((String)"OBJLoader.Parser: command '%s' (model: '%s') is not currently supported, skipping", (Object[])new Object[]{key, this.objFrom});
            }
            OBJModel model = new OBJModel(this.materialLibrary, this.objFrom);
            model.getMatLib().setUVBounds(this.minU, this.maxU, this.minV, this.maxV);
            return model;
        }
    }
}

