/*
 * Decompiled with CFR 0.152.
 */
package halocraft.entities.render;

import com.arisux.xlib.api.wavefrontapi.Part;
import com.arisux.xlib.api.wavefrontapi.WavefrontAPI;
import com.arisux.xlib.api.wavefrontapi.WavefrontModel;
import com.arisux.xlib.client.render.XLibRenderer;
import halocraft.Main;
import halocraft.entities.EntityWarthog;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWarthogEntity
extends Render {
    public WavefrontModel model = WavefrontAPI.instance().loadModel(Main.class, "halocraft", "Warthog", "/assets/halocraft/models/entity/Warthog");

    public RenderWarthogEntity(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.5f;
    }

    public void doRender(EntityWarthog warthogIn, double posX, double posY, double posZ, float yaw, float partialTicks) {
        double curVelocity = Math.sqrt(warthogIn.field_70159_w * warthogIn.field_70159_w + warthogIn.field_70179_y * warthogIn.field_70179_y);
        float tireRotation = curVelocity > 0.1 ? (float)(warthogIn.field_70170_p.func_72820_D() % 360L * 8L) - partialTicks : 0.0f;
        float time = (float)warthogIn.getTimeSinceHit() - partialTicks;
        float damage = warthogIn.getDamageTaken() - partialTicks;
        damage = damage < 0.0f ? 0.0f : damage;
        XLibRenderer.pushMatrix();
        GlStateManager.func_179089_o();
        XLibRenderer.translate(posX + 0.5, posY + 0.83, posZ);
        if (time > 0.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)time) * time * damage / 10.0f * (float)warthogIn.getForwardDirection()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (warthogIn.field_70153_n != null && warthogIn.field_70153_n instanceof EntityPlayer) {
            EntityPlayer rider = (EntityPlayer)warthogIn.field_70153_n;
            GlStateManager.func_179114_b((float)(-warthogIn.field_70177_z - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        for (Part p : this.model.nameToPartHash.values()) {
            XLibRenderer.pushMatrix();
            if (p == this.model.getPart("the_node.000_tri_5178_geometry") || p == this.model.getPart("the_node.001_tri_5178_geometry")) {
                XLibRenderer.translate(0.0, -0.345, -1.27);
                GlStateManager.func_179114_b((float)tireRotation, (float)1.0f, (float)0.0f, (float)0.0f);
                XLibRenderer.translate(0.0, 0.345, 1.27);
                p.draw();
            } else if (p == this.model.getPart("the_node.002_tri_5178_geometry") || p == this.model.getPart("the_node.010_tri_5178_geometry")) {
                XLibRenderer.translate(0.0, -0.33, 1.6);
                GlStateManager.func_179114_b((float)tireRotation, (float)1.0f, (float)0.0f, (float)0.0f);
                XLibRenderer.translate(0.0, 0.33, -1.6);
                p.draw();
            } else {
                p.draw();
            }
            XLibRenderer.popMatrix();
        }
        XLibRenderer.popMatrix();
    }

    protected ResourceLocation getEntityTexture(EntityWarthog entityWarthog) {
        return null;
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTicks) {
        this.doRender((EntityWarthog)entity, x, y, z, yaw, partialTicks);
    }
}

