/*
 * Decompiled with CFR 0.152.
 */
package zenyl.magiz.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MagizExplosion
extends Explosion {
    private final boolean isFlaming;
    private final boolean isSmoking;
    private final Random explosionRNG = new Random();
    private final World worldObj;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final Entity exploder;
    private final float explosionSize;
    private final List affectedBlockPositions = Lists.newArrayList();
    private final Map field_77288_k = Maps.newHashMap();
    private static final String __OBFID = "CL_00000134";
    private final Vec3 position;

    @SideOnly(value=Side.CLIENT)
    public MagizExplosion(World worldIn, Entity p_i45752_2_, double p_i45752_3_, double p_i45752_5_, double p_i45752_7_, float p_i45752_9_, List p_i45752_10_) {
        this(worldIn, p_i45752_2_, p_i45752_3_, p_i45752_5_, p_i45752_7_, p_i45752_9_, false, true, p_i45752_10_);
    }

    @SideOnly(value=Side.CLIENT)
    public MagizExplosion(World worldIn, Entity p_i45753_2_, double p_i45753_3_, double p_i45753_5_, double p_i45753_7_, float p_i45753_9_, boolean p_i45753_10_, boolean p_i45753_11_, List p_i45753_12_) {
        this(worldIn, p_i45753_2_, p_i45753_3_, p_i45753_5_, p_i45753_7_, p_i45753_9_, p_i45753_10_, p_i45753_11_);
        this.affectedBlockPositions.addAll(p_i45753_12_);
    }

    public MagizExplosion(World worldIn, Entity p_i45754_2_, double p_i45754_3_, double p_i45754_5_, double p_i45754_7_, float p_i45754_9_, boolean p_i45754_10_, boolean p_i45754_11_) {
        super(worldIn, p_i45754_2_, p_i45754_3_, p_i45754_5_, p_i45754_7_, p_i45754_9_, p_i45754_10_, p_i45754_11_);
        this.worldObj = worldIn;
        this.exploder = p_i45754_2_;
        this.explosionSize = p_i45754_9_;
        this.explosionX = p_i45754_3_;
        this.explosionY = p_i45754_5_;
        this.explosionZ = p_i45754_7_;
        this.isFlaming = p_i45754_10_;
        this.isSmoking = p_i45754_11_;
        this.position = new Vec3(this.explosionX, this.explosionY, this.explosionZ);
    }

    public void func_77278_a() {
        int k;
        int j;
        HashSet hashset = Sets.newHashSet();
        boolean flag = true;
        for (int i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.explosionX;
                    double d6 = this.explosionY;
                    double d8 = this.explosionZ;
                    float f1 = 0.3f;
                    for (float f = this.explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.worldObj.func_180495_p(blockpos);
                        if (iblockstate.func_177230_c().func_149688_o() != Material.field_151579_a) {
                            float f2 = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.worldObj, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.worldObj, blockpos, (Entity)null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.worldObj, blockpos, iblockstate, f))) {
                            hashset.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(hashset);
        float f3 = this.explosionSize * 2.0f;
        j = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
        k = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
    }

    public void func_77279_a(boolean p_77279_1_) {
        this.worldObj.func_72908_a(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.isSmoking) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                Block block = this.worldObj.func_180495_p(blockpos).func_177230_c();
                if (p_77279_1_) {
                    double d0 = (float)blockpos.func_177958_n() + this.worldObj.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.worldObj.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.worldObj.field_73012_v.nextFloat();
                    double d3 = d0 - this.explosionX;
                    double d4 = d1 - this.explosionY;
                    double d5 = d2 - this.explosionZ;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                    this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d2 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.worldObj.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (block.func_149688_o() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.worldObj, blockpos, this.worldObj.func_180495_p(blockpos), 1.0f / this.explosionSize, 0);
                }
                block.onBlockExploded(this.worldObj, blockpos, (Explosion)this);
            }
        }
        if (this.isFlaming) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                if (this.worldObj.func_180495_p(blockpos).func_177230_c().func_149688_o() != Material.field_151579_a || !this.worldObj.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_149730_j() || this.explosionRNG.nextInt(3) != 0) continue;
                this.worldObj.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public Map func_77277_b() {
        return this.field_77288_k;
    }

    public EntityLivingBase func_94613_c() {
        return this.exploder == null ? null : (this.exploder instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.exploder).func_94083_c() : (this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null));
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3 getPosition() {
        return this.position;
    }
}

