/*
 * Decompiled with CFR 0.152.
 */
package zenyl.magiz;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import zenyl.magiz.SpellInfo;
import zenyl.magiz.init.MagizBlocks;
import zenyl.magiz.init.MagizEntities;
import zenyl.magiz.init.MagizItems;
import zenyl.magiz.init.MagizRecipes;
import zenyl.magiz.item.ItemMagizStaff;
import zenyl.magiz.proxy.CommonProxy;

@Mod(modid="magiz", name="Magiz", version="1.0", acceptedMinecraftVersions="[1.8]")
public class Magiz {
    public static final String MODID = "magiz";
    public static final String VERSION = "1.0.0";
    @SidedProxy(clientSide="zenyl.magiz.proxy.ClientProxy", serverSide="zenyl.magiz.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="magiz")
    private static Magiz instance;
    public static List<Integer> spellList;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        for (int i = 0; i < 10000; ++i) {
            if (this.getSpellTier(i) <= 0) continue;
            spellList.add(i);
        }
        ModMetadata data = event.getModMetadata();
        MagizBlocks.init();
        MagizBlocks.register();
        MagizItems.init();
        MagizItems.register();
        MagizRecipes.init();
        MagizEntities.registerEntities();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenders();
        proxy.registerKeybindings();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
    }

    public static Magiz getInstance() {
        return instance;
    }

    public String getSpellName(int id) {
        return this.getSpellInfo((int)id).name;
    }

    public int getSpellTier(int id) {
        return this.getSpellInfo((int)id).level;
    }

    public Item getSpellItem(int id) {
        return this.getSpellInfo((int)id).itemstack == null ? null : this.getSpellInfo((int)id).itemstack.func_77973_b();
    }

    public ItemStack getSpellItemStack(int id) {
        return this.getSpellInfo((int)id).itemstack;
    }

    public String getSpellDescription(int i) {
        return this.getSpellInfo((int)i).description;
    }

    public SpellInfo.SpellType getSpellType(int i) {
        return this.getSpellInfo((int)i).type;
    }

    public SpellInfo getSpellInfo(int i) {
        switch (i) {
            case 1: {
                return new SpellInfo("Repulsion", 1, Item.func_150898_a((Block)Blocks.field_180399_cE), SpellInfo.SpellType.SPELL, "Repels the hit mobs.");
            }
            case 2: {
                return new SpellInfo("Pain", 1, Items.field_151040_l, SpellInfo.SpellType.SPELL, "Inflicts 1 heart of damage on the hit mob.");
            }
            case 3: {
                return new SpellInfo("Location", 1, Items.field_151079_bi, SpellInfo.SpellType.SPELL, "Teleports you to where the spell hits, and deals 2.5 hearts of damage to the user, like an Ender Pearl.");
            }
            case 4: {
                return new SpellInfo("Teleportation", 2, Items.field_151079_bi, SpellInfo.SpellType.SPELL, "Teleports you to where the spell hits, without any damage being dealt to the user.");
            }
            case 5: {
                return new SpellInfo("Thunder", 1, Item.func_150898_a((Block)Blocks.field_150411_aY), SpellInfo.SpellType.SPELL, "Summons a bolt of lightning onto whatever the spell hits.");
            }
            case 6: {
                return new SpellInfo("Thor", 2, Item.func_150898_a((Block)Blocks.field_150411_aY), SpellInfo.SpellType.SPELL, "Summons bolts of lightning in a 3x3 area, centered around the spot where the spell hits.");
            }
            case 7: {
                return new SpellInfo("Ion Cannon", 3, Item.func_150898_a((Block)Blocks.field_150411_aY), SpellInfo.SpellType.SPELL, "Wherever the spell hits will be blown up, and smited with several bolts of lightning.");
            }
            case 8: {
                return new SpellInfo("Absorbtion", 1, new ItemStack(Item.func_150898_a((Block)Blocks.field_150360_v), 1, 0), SpellInfo.SpellType.SPELL, "Removes water in a small area, around wherever the spell hits.");
            }
            case 9: {
                return new SpellInfo("Weather", 1, Items.field_151133_ar, SpellInfo.SpellType.SPELL, "Switches the weather between dry and rainy.");
            }
            case 10: {
                return new SpellInfo("Forging", 1, Item.func_150898_a((Block)Blocks.field_150460_al), SpellInfo.SpellType.BOTH, "Certain, smeltable blocks will be turned into their melted-down counterpart.");
            }
            case 11: {
                return new SpellInfo("Pasture", 1, Item.func_150898_a((Block)Blocks.field_150349_c), SpellInfo.SpellType.BOTH, "Turns dirt blocks into grass blocks, around the block where the spell hits.");
            }
            case 12: {
                return new SpellInfo("Frost", 1, Item.func_150898_a((Block)Blocks.field_150432_aD), SpellInfo.SpellType.BOTH, "Freezes water nearby whatever block the spell hits.");
            }
            case 13: {
                return new SpellInfo("Siphon", 2, new ItemStack((Item)Items.field_151068_bn, 1, 8229), SpellInfo.SpellType.SPELL, "Deals 0.5 hearts of damage to the hit entity, while healing you by 0.5 hearts.\n\nMade with an Instant Healing II potion.");
            }
            case 14: {
                return new SpellInfo("Squidification", 1, new ItemStack(Items.field_151100_aR, 1, 0), SpellInfo.SpellType.SPELL, "Summon a wall of squids where the spell lands, to protect you from your enemies. Highly efficient against anyone scared of ink.");
            }
            case 15: {
                return new SpellInfo("Extinguishing", 1, Items.field_151131_as, SpellInfo.SpellType.SPELL, "Extinguishes blocks and mobs near the user.");
            }
            case 16: {
                return new SpellInfo("Binding", 2, Item.func_150898_a((Block)Blocks.field_150425_aM), SpellInfo.SpellType.SPELL, "Binds a hit mob for 10 seconds.");
            }
            case 17: {
                return new SpellInfo("Lactose", 1, Items.field_151117_aB, SpellInfo.SpellType.SPELL, "Removes all potion effects from the caster.");
            }
            case 18: {
                return new SpellInfo("Fire", 1, Items.field_151033_d, SpellInfo.SpellType.BOTH, "Lights any mob hit by the spell on fire.");
            }
            case 19: {
                return new SpellInfo("Bulldozing", 1, Items.field_151047_v, SpellInfo.SpellType.BOTH, "Removes softer blocks with a safe explosion, wherever the spell hits.");
            }
            case 20: {
                return new SpellInfo("Blast Mining", 3, Items.field_151046_w, SpellInfo.SpellType.BOTH, "Explodes blocks near the place where the spell hits, using a safe explosion.");
            }
            case 21: {
                return new SpellInfo("Creeper", 1, Item.func_150898_a((Block)Blocks.field_150335_W), SpellInfo.SpellType.SPELL, "Causes a minor explosion wherever the spell hits.");
            }
            case 22: {
                return new SpellInfo("Blast", 2, Item.func_150898_a((Block)Blocks.field_150335_W), SpellInfo.SpellType.SPELL, "Causes a larger explosion wherever the spell hits.");
            }
            case 23: {
                return new SpellInfo("Explosion", 3, Item.func_150898_a((Block)Blocks.field_150335_W), SpellInfo.SpellType.SPELL, "Causes a huge explosion wherever the spell hits.");
            }
            case 24: {
                return new SpellInfo("Gravity", 1, Item.func_150898_a((Block)Blocks.field_150351_n), SpellInfo.SpellType.SPELL, "Makes the block hit by the spell fall like gravel.");
            }
            case 25: {
                return new SpellInfo("Sinkhole", 2, Item.func_150898_a((Block)Blocks.field_150351_n), SpellInfo.SpellType.SPELL, "Makes blocks near the block hit by the spell fall like gravel.");
            }
            case 26: {
                return new SpellInfo("Lift", 1, Item.func_150898_a((Block)Blocks.field_150331_J), SpellInfo.SpellType.SPELL, "Makes the block hit by the spell fly into the air.");
            }
            case 27: {
                return new SpellInfo("Tornado", 2, Item.func_150898_a((Block)Blocks.field_150331_J), SpellInfo.SpellType.SPELL, "Makes blocks near the block hit by the spell fly into the air.");
            }
        }
        return new SpellInfo("Unknown spell [" + i + "]", 0, SpellInfo.SpellType.BOTH, "");
    }

    public String getItemName(ItemStack itemstack) {
        if (itemstack.func_77973_b() == MagizItems.magizStaff && ((ItemMagizStaff)itemstack.func_77973_b()).getSpells(itemstack).size() == 0) {
            return "Uncharged Staff";
        }
        if (itemstack.func_77973_b() == MagizItems.magizStaff && ((ItemMagizStaff)itemstack.func_77973_b()).getSpells(itemstack).size() > 0) {
            return "Charged Staff";
        }
        if (itemstack.func_77973_b() == MagizItems.magizSpell) {
            return "Uncharged Spell";
        }
        if (itemstack.func_77973_b() == MagizItems.magizOrb) {
            return "Magical Power Orb";
        }
        if (itemstack.func_77973_b() == MagizItems.magizPouch) {
            return "Magical Orb Pouch";
        }
        if (itemstack.func_77973_b() == MagizItems.magizCharger1) {
            return "Tier 1 Spell Charger";
        }
        if (itemstack.func_77973_b() == MagizItems.magizCharger2) {
            return "Tier 2 Spell Charger";
        }
        if (itemstack.func_77973_b() == MagizItems.magizCharger3) {
            return "Tier 3 Spell Charger";
        }
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)MagizBlocks.magizEnergyCondenser)) {
            return "Magical Energy Condenser";
        }
        return "No description available.";
    }

    public String getItemDescription(ItemStack itemstack) {
        if (itemstack.func_77973_b() == MagizItems.magizStaff && ((ItemMagizStaff)itemstack.func_77973_b()).getSpells(itemstack).size() == 0) {
            return "Uncharged staves can hold " + ((ItemMagizStaff)itemstack.func_77973_b()).getMaxCharge(itemstack) + " spells. When charged with at least one spell, it can cast that spell (if you have at least one " + this.getItemName(new ItemStack(MagizItems.magizOrb)) + " in your inventory, or in a " + this.getItemName(new ItemStack(MagizItems.magizPouch, 1, 1)) + " with orbs in it).";
        }
        if (itemstack.func_77973_b() == MagizItems.magizStaff && ((ItemMagizStaff)itemstack.func_77973_b()).getSpells(itemstack).size() > 0) {
            return "Charged staves are staves that have been charged with one or more spells, and can cast those spells.";
        }
        if (itemstack.func_77973_b() == MagizItems.magizSpell) {
            return "Uncharged Spell are required to craft spells, alongside a Spell Charger of the spell's tier, as well as a tertiary ingredient.\n\nFor information about specific spells, look the spell up in the Spells part of this book, accessed below.";
        }
        if (itemstack.func_77973_b() == MagizItems.magizOrb) {
            return "Magical Power Orbs are used to cast spells, and in certain crafting recipes. They are acquired from Magical Energy Condensers, in exchange for experience levels. In order to cast a spell, you're required to have at least one Magical Power Orb in your iventory, or in a Magical Orb Pouch.";
        }
        if (itemstack.func_77973_b() == MagizItems.magizPouch) {
            return "Magical Orb Pouches can be used to store Magical Power Orbs. Orbs stored in a pouch can still be used to cast spells, but take up just one inventory slot, instead of only stacking up to 64 orbs per inventory slot.";
        }
        if (itemstack.func_77973_b() == MagizItems.magizCharger1) {
            return "Tier 1 Spell Chargers are used to create Tier 1 spells. This means, that the spells that use Tier 1 Spell Chargers will require 1 charge from the staff they're added onto, so a normal staff can hold three Tier 1 spells.";
        }
        if (itemstack.func_77973_b() == MagizItems.magizCharger2) {
            return "Tier 2 Spell Chargers are used to create Tier 2 spells. This means, that the spells that use Tier 2 Spell Chargers will require 2 charges from the staff they're added onto, so a normal staff can hold one Tier 2 spell, as well as a Tier 1 spell.";
        }
        if (itemstack.func_77973_b() == MagizItems.magizCharger3) {
            return "Tier 3 Spell Chargers are used to create Tier 3 spells. This means, that the spells that use Tier 3 Spell Chargers will require 3 charges from the staff they're added onto, so a normal staff can hold one Tier 3 spell, and no other spells.";
        }
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)MagizBlocks.magizEnergyCondenser)) {
            return "Magical Energy Condensers are used to condense your experience levels into Magical Power Orbs, which are used to cast spells, as well as in different crafting recipes. To use it, right-click it, and it will convert your experience levels into a proportional amount of orbs.";
        }
        return "No description available.";
    }

    public Item getCharger(int i) {
        switch (i) {
            case 1: {
                return MagizItems.magizCharger1;
            }
            case 2: {
                return MagizItems.magizCharger2;
            }
            case 3: {
                return MagizItems.magizCharger3;
            }
        }
        return null;
    }

    static {
        spellList = new ArrayList<Integer>();
    }
}

