/*
 * Decompiled with CFR 0.152.
 */
package zenyl.magiz.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zenyl.magiz.Magiz;
import zenyl.magiz.Spell;
import zenyl.magiz.SpellInfo;
import zenyl.magiz.entity.EntityMagizSpell;
import zenyl.magiz.init.MagizItems;

public class ItemMagizStaff
extends Item {
    public ItemMagizStaff() {
        this.func_77627_a(true);
    }

    public int getMaxCharge(ItemStack itemstack) {
        if (itemstack.func_77977_a() == "magizStaff") {
            return 3;
        }
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean func_180614_a(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float x, float y, float z) {
        boolean flag = true;
        for (int i : this.getSpells(itemstack)) {
            if (Magiz.getInstance().getSpellType(i) == SpellInfo.SpellType.ON_BLOCK) continue;
            flag = false;
        }
        if (!flag) {
            return false;
        }
        if (this.getSpells(itemstack).size() == 0) {
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Staff not charged."));
            }
        } else if (this.canCastSpell(player)) {
            Spell.staffUsedOnBlock(itemstack, player, world, pos, side, x, y, z);
        } else if (!world.field_72995_K) {
            player.func_146105_b((IChatComponent)new ChatComponentText("No Magical Power Orbs."));
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (this.getSpells(itemstack).size() == 0) {
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Staff not charged."));
            }
            return itemstack;
        }
        boolean flag = true;
        for (int i : this.getSpells(itemstack)) {
            if (Magiz.getInstance().getSpellType(i) == SpellInfo.SpellType.ON_BLOCK) continue;
            flag = false;
        }
        if (flag) {
            return itemstack;
        }
        if (this.canCastSpell(player)) {
            world.func_72956_a((Entity)player, "mob.chicken.plop", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            world.func_72838_d((Entity)new EntityMagizSpell(world, (EntityLivingBase)player, 1.0f, this.getSpells(itemstack)));
            player.func_71038_i();
        } else {
            world.func_72956_a((Entity)player, "random.pop", 1.0f, 0.0f);
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText("No Magical Power Orbs."));
            }
        }
        return itemstack;
    }

    public boolean canCastSpell(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (player.field_71071_by.func_146028_b(MagizItems.magizPouch)) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != MagizItems.magizPouch || stack.func_77952_i() <= 0) continue;
                stack.func_77964_b(stack.func_77952_i() - 1);
                return true;
            }
        }
        if (player.field_71071_by.func_146028_b(MagizItems.magizOrb)) {
            return player.field_71071_by.func_146026_a(MagizItems.magizOrb);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        NBTTagCompound tags = stack.func_179543_a("spelllist", false);
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            tooltip.add("> " + (tags == null ? "null" : tags.toString()));
        }
        if (tags == null) {
            tooltip.add(tags == null ? "Uncharged" : tags.toString());
        } else {
            NBTTagList list = (NBTTagList)tags.func_74781_a("spells");
            if (list != null) {
                tooltip.add("Spells: ");
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    tooltip.add(" " + Magiz.getInstance().getSpellName(((NBTTagInt)list.func_179238_g(i)).func_150287_d()));
                }
                tooltip.add("Charge: " + this.getCharge(this.getSpells(stack)) + "/" + this.getMaxCharge(stack));
            } else {
                tooltip.add("Uncharged");
            }
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.getSpells(stack).size() != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 0) {
            return 0xFFFFFF;
        }
        return 0xFF0000;
    }

    public ItemStack addSpells(List<Integer> list, ItemStack itemstack) {
        for (int i : list) {
            this.addSpell(list.get(i), itemstack);
        }
        return itemstack;
    }

    public boolean addSpell(int id, ItemStack itemstack) {
        if (this.getCharge(this.getSpells(itemstack)) + Magiz.getInstance().getSpellInfo((int)id).level > this.getMaxCharge(itemstack)) {
            return false;
        }
        NBTTagCompound tagComp = itemstack.func_179543_a("spelllist", true);
        if (!tagComp.func_74764_b("spells")) {
            tagComp.func_74782_a("spells", (NBTBase)new NBTTagList());
        }
        NBTTagList list = (NBTTagList)tagComp.func_74781_a("spells");
        if (!this.hasSpell(id, itemstack)) {
            list.func_74742_a((NBTBase)new NBTTagInt(id));
        }
        return true;
    }

    public boolean hasSpell(int id, ItemStack itemstack) {
        NBTTagCompound tagComp = itemstack.func_179543_a("spelllist", true);
        if (tagComp == null) {
            return false;
        }
        if (!tagComp.func_74764_b("spells")) {
            return false;
        }
        NBTTagList list = (NBTTagList)tagComp.func_74781_a("spells");
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (!(list.func_179238_g(i) instanceof NBTTagInt) || ((NBTTagInt)list.func_179238_g(i)).func_150287_d() != new NBTTagInt(id).func_150287_d()) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getSpells(ItemStack itemstack) {
        ArrayList<Integer> spells = new ArrayList<Integer>();
        NBTTagCompound tagComp = itemstack.func_179543_a("spelllist", true);
        if (tagComp == null) {
            return spells;
        }
        if (!tagComp.func_74764_b("spells")) {
            return spells;
        }
        NBTTagList list = (NBTTagList)tagComp.func_74781_a("spells");
        if (list == null) {
            return spells;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (!(list.func_179238_g(i) instanceof NBTTagInt)) continue;
            spells.add(((NBTTagInt)list.func_179238_g(i)).func_150287_d());
        }
        return spells;
    }

    public int getCharge(List<Integer> list) {
        int i = 0;
        for (int j : list) {
            i += Magiz.getInstance().getSpellInfo((int)j).level;
        }
        return i;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.getSpells(stack).size() > 0 ? EnumRarity.RARE : EnumRarity.COMMON;
    }
}

