/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.aimbow;

import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.famzangl.minecraft.aimbow.Pos2;
import net.famzangl.minecraft.aimbow.ZoomController;
import net.famzangl.minecraft.aimbow.aiming.ColissionData;
import net.famzangl.minecraft.aimbow.aiming.ColissionSolver;
import net.famzangl.minecraft.aimbow.aiming.ReverseBowSolver;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ChunkRenderContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class AimbowGui
extends GuiIngame {
    FloatBuffer modelBuffer = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer projectionBuffer = BufferUtils.createFloatBuffer((int)16);
    IntBuffer viewPort = BufferUtils.createIntBuffer((int)4);
    private final FloatBuffer win_pos = BufferUtils.createFloatBuffer((int)3);
    private final double zLevel = 0.0;
    Minecraft field_73839_d = Minecraft.func_71410_x();
    private final ZoomController zc = new ZoomController();
    private float partialTicks;
    public boolean autoAim;
    private MatrixCatcher catcher;

    public AimbowGui(Minecraft mcIn) {
        super(mcIn);
    }

    public void func_175180_a(float partialTicks) {
        this.partialTicks = partialTicks;
        super.func_175180_a(partialTicks);
    }

    protected boolean func_175183_b() {
        EntityPlayerSP player = this.field_73839_d.field_71439_g;
        ItemStack heldItem = player.func_70694_bm();
        ColissionSolver colissionSolver = ColissionSolver.forItem(heldItem, this.field_73839_d);
        if (colissionSolver != null) {
            this.checkForMatrixStealing();
            ScaledResolution resolution = new ScaledResolution(this.field_73839_d, this.field_73839_d.field_71443_c, this.field_73839_d.field_71440_d);
            boolean colissionDrawn = false;
            ArrayList<ColissionData> colissionPoints = colissionSolver.computeCurrentColissionPoints();
            for (ColissionData p : colissionPoints) {
                Pos2 pos = this.getPositionOnScreen(this.field_73839_d, p.x, p.y + (double)player.func_70047_e(), p.z, resolution);
                boolean hit = p.hitEntity != null;
                this.drawCrosshairAt(this.field_73839_d, pos.x, pos.y, hit ? 0.0f : 1.0f, hit ? 1.0f : 0.0f, 0.0f);
                this.zc.zoomTowards(new Vec3(p.x, p.y, p.z));
                if (!colissionDrawn && !hit && this.autoAim && this.shouldAutoaim(heldItem)) {
                    this.aimAtCloseEntity(pos, resolution, colissionSolver);
                }
                colissionDrawn = true;
            }
            if (!colissionDrawn) {
                int x = resolution.func_78326_a() / 2;
                int y = resolution.func_78328_b() / 2;
                this.drawCrosshairAt(this.field_73839_d, x, y, 0.6f, 0.6f, 0.6f);
            }
            return false;
        }
        return super.func_175183_b();
    }

    private void checkForMatrixStealing() {
        try {
            for (Field field : RenderGlobal.class.getDeclaredFields()) {
                if (field.getType() != ChunkRenderContainer.class) continue;
                field.setAccessible(true);
                Object current = field.get(this.field_73839_d.field_71438_f);
                if (current instanceof MatrixCatcher) continue;
                this.catcher = new MatrixCatcher((ChunkRenderContainer)current);
                field.set(this.field_73839_d.field_71438_f, (Object)this.catcher);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean shouldAutoaim(ItemStack heldItem) {
        int count = this.field_73839_d.field_71439_g.func_71052_bv();
        return heldItem.func_77973_b() != Items.field_151031_f || count > 0;
    }

    private void drawCrosshairAt(Minecraft mc, int x, int y, float r, float g, float b) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.drawTexturedModalRect(x - 7, y - 7, 0, 0, 16, 16, r, g, b);
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6, float r, float g, float b) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        WorldRenderer tessellator = Tessellator.func_178181_a().func_178180_c();
        tessellator.func_178970_b();
        tessellator.func_178960_a(r, g, b, 0.5f);
        tessellator.func_178985_a((double)(par1 + 0), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_178985_a((double)(par1 + par5), (double)(par2 + par6), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_178985_a((double)(par1 + par5), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_178985_a((double)(par1 + 0), (double)(par2 + 0), this.zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        Tessellator.func_178181_a().func_78381_a();
    }

    public Pos2 getPositionOnScreen(Minecraft mc, double x, double y, double z, ScaledResolution resolution) {
        Vec3 player = mc.func_175606_aa().func_174824_e(this.partialTicks);
        this.viewPort.rewind();
        this.viewPort.put(0);
        this.viewPort.put(0);
        this.viewPort.put(resolution.func_78326_a());
        this.viewPort.put(resolution.func_78328_b());
        this.viewPort.rewind();
        this.win_pos.rewind();
        this.modelBuffer.rewind();
        this.projectionBuffer.rewind();
        GLU.gluProject((float)((float)(x - player.field_72450_a)), (float)((float)(y - player.field_72448_b)), (float)((float)(z - player.field_72449_c)), (FloatBuffer)this.modelBuffer, (FloatBuffer)this.projectionBuffer, (IntBuffer)this.viewPort, (FloatBuffer)this.win_pos);
        this.win_pos.rewind();
        int sx = (int)this.win_pos.get();
        int sy = resolution.func_78328_b() - (int)this.win_pos.get();
        if (this.win_pos.get() < 1.0f) {
            return new Pos2(sx, sy);
        }
        return new Pos2(-100, -100);
    }

    public void aimAtCloseEntity(Pos2 toScreenPos, ScaledResolution resolution, ColissionSolver colissionSolver) {
        AxisAlignedBB bbox = this.field_73839_d.field_71439_g.func_174813_aQ();
        List entities = this.field_73839_d.field_71441_e.func_72872_a(Entity.class, bbox.func_72314_b(200.0, 100.0, 200.0));
        ArrayList<CloseEntity> nearEntities = new ArrayList<CloseEntity>();
        for (Entity e : entities) {
            Pos2 onScreen;
            double d;
            if (!e.func_70067_L() || e == Minecraft.func_71410_x().field_71439_g || !((d = toScreenPos.distanceTo(onScreen = this.getPositionOnScreen(this.field_73839_d, e.field_70165_t, e.field_70163_u, e.field_70161_v, resolution))) < 100.0)) continue;
            nearEntities.add(new CloseEntity(e, d));
        }
        Collections.sort(nearEntities);
        ReverseBowSolver rbs = new ReverseBowSolver(colissionSolver.getGravity(), colissionSolver.getVelocity());
        for (CloseEntity e : nearEntities) {
            Vec3 look = rbs.getLookForTarget(e.entity);
            ArrayList<ColissionData> foundColissions = colissionSolver.computeColissionWithLook(look);
            if (foundColissions.size() <= 0 || foundColissions.get((int)0).hitEntity != e.entity) continue;
            this.lookAt(look);
            break;
        }
    }

    private void lookAt(Vec3 look) {
        double d0 = look.field_72450_a;
        double d2 = look.field_72448_b;
        double d1 = look.field_72449_c;
        double d3 = d0 * d0 + d2 * d2 + d1 * d1;
        if (d3 >= 2.500000277905201E-7) {
            float rotationYaw = this.field_73839_d.field_71439_g.field_70177_z;
            float rotationPitch = this.field_73839_d.field_71439_g.field_70125_A;
            float yaw = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(d2, Math.sqrt(d0 * d0 + d1 * d1)) * 180.0 / Math.PI));
            this.field_73839_d.field_71439_g.func_70082_c((yaw - rotationYaw) / 0.15f, -(pitch - rotationPitch) / 0.15f);
        }
    }

    public void stealProjectionMatrix() {
        this.modelBuffer.rewind();
        this.projectionBuffer.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)this.modelBuffer);
        GL11.glGetFloat((int)2983, (FloatBuffer)this.projectionBuffer);
    }

    public class MatrixCatcher
    extends ChunkRenderContainer {
        ChunkRenderContainer base;

        public void func_178002_a(RenderChunk p_178002_1_, EnumWorldBlockLayer p_178002_2_) {
            this.base.func_178002_a(p_178002_1_, p_178002_2_);
        }

        public boolean equals(Object obj) {
            return this.base.equals(obj);
        }

        public int hashCode() {
            return this.base.hashCode();
        }

        public void func_178004_a(double p_178004_1_, double p_178004_3_, double p_178004_5_) {
            this.base.func_178004_a(p_178004_1_, p_178004_3_, p_178004_5_);
        }

        public void func_178003_a(RenderChunk p_178003_1_) {
            this.base.func_178003_a(p_178003_1_);
        }

        public void func_178001_a(EnumWorldBlockLayer p_178001_1_) {
            if (AimbowGui.this.catcher == this) {
                AimbowGui.this.stealProjectionMatrix();
            }
            this.base.func_178001_a(p_178001_1_);
        }

        public String toString() {
            return this.base.toString();
        }

        public MatrixCatcher(ChunkRenderContainer base) {
            this.base = base;
        }
    }

    private static class CloseEntity
    implements Comparable<CloseEntity> {
        private final Entity entity;
        private final double distance;

        public CloseEntity(Entity entity, double distance) {
            this.entity = entity;
            this.distance = distance;
        }

        @Override
        public int compareTo(CloseEntity o) {
            return Double.compare(this.distance, o.distance);
        }

        public String toString() {
            return "CloseEntity [entity=" + this.entity + ", distance=" + this.distance + "]";
        }
    }
}

