/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.aimbow.aiming;

import java.util.Random;
import net.famzangl.minecraft.aimbow.aiming.TickingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public abstract class RayData
extends TickingEntity {
    protected boolean dead;
    protected float prevRotationYaw;
    protected float prevRotationPitch;

    public void setLocationAndAngles(double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        this.setPosition(posX, posY, posZ);
    }

    public void shootFromTowards(Entity shootingEntity, Vec3 lookVec) {
        float yaw = (float)(Math.atan2(lookVec.field_72449_c, lookVec.field_72450_a) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(lookVec.field_72448_b, Math.sqrt(lookVec.field_72450_a * lookVec.field_72450_a + lookVec.field_72449_c * lookVec.field_72449_c)) * 180.0 / Math.PI));
        this.setLocationAndAngles(shootingEntity.field_70165_t, shootingEntity.field_70163_u + (double)shootingEntity.func_70047_e(), shootingEntity.field_70161_v, yaw, pitch);
        this.shoot();
    }

    public void shootFrom(Entity entity) {
        this.setLocationAndAngles(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.shoot();
    }

    @Override
    public void moveTick() {
        super.moveTick();
        float f2 = MathHelper.func_76133_a((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f3 = 0.99f;
        float f1 = this.getGravity();
        this.motionX *= (double)f3;
        this.motionY *= (double)f3;
        this.motionZ *= (double)f3;
        this.motionY -= (double)f1;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    protected abstract float getGravity();

    public abstract void shoot();

    public void setThrowableHeading(double motionX, double motionY, double motionZ, double force, float randomInfluence) {
        float f2 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)f2;
        motionY /= (double)f2;
        motionZ /= (double)f2;
        Random rand = new Random();
        motionX += rand.nextGaussian() * (double)(rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randomInfluence;
        motionY += rand.nextGaussian() * (double)(rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randomInfluence;
        motionZ += rand.nextGaussian() * (double)(rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randomInfluence;
        this.motionX = motionX *= force;
        this.motionY = motionY *= force;
        this.motionZ = motionZ *= force;
        float f3 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(motionY, f3) * 180.0 / Math.PI);
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }
}

