/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.aimbow.aiming;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class ReverseBowSolver {
    private static final int MAX_STEPS = 120;
    private float gravity;
    private float velocity;

    public ReverseBowSolver(float gravity, float velocity) {
        this.gravity = gravity;
        this.velocity = velocity;
    }

    public Vec3 getLookForTarget(Entity target) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        AxisAlignedBB boundingBox = target.func_174813_aQ();
        double targetX = (boundingBox.field_72336_d + boundingBox.field_72340_a) / 2.0;
        double targetY = (boundingBox.field_72337_e + boundingBox.field_72338_b) / 2.0;
        double targetZ = (boundingBox.field_72334_f + boundingBox.field_72339_c) / 2.0;
        double dx = targetX - player.field_70165_t;
        double dz = targetZ - player.field_70161_v;
        float dHor = (float)Math.sqrt(dx * dx + dz * dz);
        float dVert = (float)(targetY - ((double)player.func_70047_e() + player.field_70163_u));
        float y = this.getYForTarget(dHor, dVert);
        float xz = (float)Math.sqrt(1.0f - y * y);
        double x = dx / (double)dHor * (double)xz;
        double z = dz / (double)dHor * (double)xz;
        return new Vec3(x, (double)y, z);
    }

    private float getYForTarget(float dHor, float dVert) {
        float maxVert = 0.9f;
        float minVert = -0.9f;
        for (int attempts = 0; attempts < 50; ++attempts) {
            float vert = (maxVert + minVert) / 2.0f;
            float hor = (float)Math.sqrt(1.0f - vert * vert);
            float newY = this.getYAtDistance(hor * this.velocity, vert * this.velocity, dHor);
            if (Float.isNaN(newY)) {
                return 0.0f;
            }
            if (newY > dVert) {
                maxVert = vert;
                continue;
            }
            minVert = vert;
        }
        float res = (maxVert + minVert) / 2.0f;
        return res;
    }

    private float getYAtDistance(float motionX, float motionY, float dHor) {
        float f3 = 0.99f;
        float f1 = this.gravity;
        float posX = 0.0f;
        float posY = 0.0f;
        for (int i = 0; i < 120; ++i) {
            if (posX + motionX >= dHor) {
                float step = (dHor - posX) / motionX;
                return posY + step * motionY;
            }
            posX += motionX;
            posY += motionY;
            motionX *= f3;
            motionY *= f3;
            motionY -= f1;
        }
        return posY;
    }
}

