/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityZombieTitan;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPigZombieTitan
extends EntityZombieTitan {
    private static final UUID field_110189_bq = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier field_110190_br = new AttributeModifier(field_110189_bq, "Attacking speed boost", 0.05, 0).func_111168_a(false);
    private int angerLevel;
    private int randomSoundDelay;
    private UUID field_175459_bn;

    public EntityPigZombieTitan(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByAggressor());
        this.field_70728_aV = 100000;
    }

    public void func_70604_c(EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.field_175459_bn = livingBase.func_110124_au();
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(150.0);
    }

    @Override
    protected EntityZombie createInstance() {
        return new EntityPigZombie(this.field_70170_p);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.isAngry()) {
            if (!this.func_70631_g_() && !iattributeinstance.func_180374_a(field_110190_br)) {
                iattributeinstance.func_111121_a(field_110190_br);
            }
            --this.angerLevel;
        } else if (iattributeinstance.func_180374_a(field_110190_br)) {
            iattributeinstance.func_111124_b(field_110190_br);
        }
        if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
            this.func_85030_a("mob.zombiepig.zpigangry", 10000.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.75f);
        }
        if (this.angerLevel > 0 && this.field_175459_bn != null && this.func_70643_av() == null) {
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.field_175459_bn);
            this.func_70604_c((EntityLivingBase)entityplayer);
            this.field_70717_bb = entityplayer;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this) && this.field_70170_p.func_72945_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.field_175459_bn != null) {
            tagCompound.func_74778_a("HurtBy", this.field_175459_bn.toString());
        } else {
            tagCompound.func_74778_a("HurtBy", "");
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.angerLevel = tagCompund.func_74765_d("Anger");
        String s = tagCompund.func_74779_i("HurtBy");
        if (s.length() > 0) {
            this.field_175459_bn = UUID.fromString(s);
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.field_175459_bn);
            this.func_70604_c((EntityLivingBase)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    private void becomeAngryAt(Entity p_70835_1_) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        this.randomSoundDelay = this.field_70146_Z.nextInt(40);
        if (p_70835_1_ instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)p_70835_1_);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    @Override
    protected String func_70639_aQ() {
        return "thetitans:titanPigZombieLiving";
    }

    @Override
    protected String func_70621_aR() {
        return "thetitans:titanPigZombieGrunt";
    }

    @Override
    protected String func_70673_aS() {
        return "thetitans:titanPigZombieDeath";
    }

    @Override
    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
    }

    @Override
    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int l;
        int k;
        this.func_145779_a(Items.field_151043_k, 16);
        this.func_145779_a(Items.field_151074_bl, 64);
        this.func_145779_a(Items.field_151010_B, 1);
        int j = this.field_70146_Z.nextInt(127 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151074_bl, 1);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(TitanItems.harcadium, 1);
        }
        k = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (l = 0; l < k; ++l) {
            this.func_70099_a(new ItemStack(Blocks.field_150357_h, 1, 0), 0.0f);
        }
        super.func_70628_a(p_70628_1_, p_70628_2_);
    }

    public boolean func_70085_c(EntityPlayer player) {
        return false;
    }

    @Override
    protected void func_82164_bB() {
        this.func_70099_a(new ItemStack(Blocks.field_150340_R, 16, 1), 0.0f);
    }

    @Override
    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        this.func_70062_b(0, new ItemStack(Items.field_151010_B));
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData p_180482_2_) {
        super.func_180482_a(p_180482_1_, p_180482_2_);
        this.setVillager(false);
        return p_180482_2_;
    }

    class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor() {
            super((EntityCreature)EntityPigZombieTitan.this, true, new Class[0]);
        }

        protected void func_179446_a(EntityCreature p_179446_1_, EntityLivingBase p_179446_2_) {
            super.func_179446_a(p_179446_1_, p_179446_2_);
            if (p_179446_1_ instanceof EntityPigZombie) {
                ((EntityPigZombie)p_179446_1_).func_70624_b(p_179446_2_);
            }
        }
    }
}

