/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityEnderColossus;
import net.minecraft.entity.titan.EntitySilverfishTitan;
import net.minecraft.entity.titan.EntitySkeletonTitan;
import net.minecraft.entity.titan.EntitySpiderTitan;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EntityZombieTitan;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAICreeperTitanSwell;
import net.minecraft.entity.titan.ai.EntityAITitanWander;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreeperTitan
extends EntityMob
implements IBossDisplayData,
ITitan {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 1800;
    private int explosionRadius = 2688;
    private int field_175494_bm = 0;

    public EntityCreeperTitan(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperTitanSwell(this));
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITitanWander((EntityCreature)this, 0.8, 200));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, Entity.class, 64.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, ITitan.SearchForAThingToKill));
        this.func_70105_a(8.0f, 26.0f);
        this.field_70138_W = 6.0f;
        this.field_70728_aV = 100000;
    }

    public float func_70603_bj() {
        return 16.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(250) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(70.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7000.0);
    }

    public int func_70658_aO() {
        return 15;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2)).func_177230_c();
                    Block blockextra = this.field_70170_p.func_180495_p(new BlockPos(k1, l1 - 1, i2)).func_177230_c();
                    if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(k1, l1, i2))) continue;
                    if (block.func_149638_a((Entity)this) < 500.0f && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(new BlockPos(k1, l1, i2)) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d1 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f2 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)((distance - 12.0f - f2) * damageMultiplier));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.func_174813_aQ().func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySpiderTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1000.0f);
                    double d0 = this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d;
                    double d1 = this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_180495_p(new BlockPos(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            tagCompound.func_74757_a("powered", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        tagCompound.func_74757_a("ignited", this.func_146078_ca());
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(tagCompund.func_74767_n("powered") ? 1 : 0)));
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = tagCompund.func_74771_c("ExplosionRadius");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.func_146079_cb();
        }
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public void func_82206_m() {
        this.setInvulTime(880);
        this.func_70606_j(this.func_110138_aP() / 2.0f);
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.func_146078_ca()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("creeper.primed", 10000.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 50.0f) {
                this.func_146079_cb();
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(2) == 0) {
            EntityPlayer entityplayer;
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)));
            Block block = iblockstate.func_177230_c();
            if (block.func_149688_o() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
            if ((entityplayer = this.field_70170_p.func_72890_a((Entity)this, 50.0)) != null) {
                for (int s = 0; s < 15; ++s) {
                    entityplayer.field_70125_A += (float)this.field_70146_Z.nextInt(2);
                    entityplayer.field_70125_A -= (float)this.field_70146_Z.nextInt(2);
                }
            }
        }
        if (this.field_70146_Z.nextInt(100) == 0 && this.func_70638_az() != null && this.field_70122_E) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 180.0f);
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f2 * 2.0 * 2.0 + this.field_70159_w * 2.0;
            this.field_70179_y = d1 / (double)f2 * 2.0 * 2.0 + this.field_70179_y * 2.0;
            this.field_70181_x = 2.0;
        }
        if (this.field_70146_Z.nextInt(10) == 0 && this.func_70638_az() != null && this.getPowered()) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 180.0f);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0f * this.func_70638_az().field_70130_N * 2.0f, true, false);
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u * (double)this.field_70131_O / 2.0, this.func_70638_az().field_70161_v, 1.0f * this.func_70638_az().field_70130_N * 2.0f, true, false);
            this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70047_e(), this.func_70638_az().field_70161_v, 1.0f * this.func_70638_az().field_70130_N * 2.0f, true, false);
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, (double)this.field_70131_O, this.field_70161_v, 2.0f, true, false);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v));
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
        } else if (this.field_70146_Z.nextInt(120) == 0 && this.func_70638_az() != null && !this.getPowered()) {
            if (this.field_70146_Z.nextInt(500) == 0) {
                this.field_70180_af.func_75692_b(17, (Object)1);
            } else {
                this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 180.0f);
                this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 1.0f * this.func_70638_az().field_70130_N, true, false);
                this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u * (double)this.field_70131_O / 2.0, this.func_70638_az().field_70161_v, 1.0f * this.func_70638_az().field_70130_N, true, false);
                this.field_70170_p.func_72885_a((Entity)this, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70047_e(), this.func_70638_az().field_70161_v, 1.0f * this.func_70638_az().field_70130_N, true, false);
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, (double)this.field_70131_O, this.field_70161_v, 2.0f, true, false);
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 49.0f);
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v));
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v));
            }
        }
        if (this.field_70146_Z.nextInt(80) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            EntityCreeper entitychicken = new EntityCreeper(this.field_70170_p);
            int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - 2.0));
            int k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70012_b((double)i, (double)j, (double)k, this.field_70177_z, 0.0f);
            entitychicken.func_70024_g(0.0, 0.9, 0.0);
            entitychicken.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitychicken)), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0);
            BlockPos blockpos = new BlockPos(entitychicken.field_70165_t, entitychicken.field_70163_u + 1.0, entitychicken.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            this.field_70170_p.func_175718_b(2001, blockpos, Block.func_176210_f((IBlockState)iblockstate));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_175656_a(blockpos, Blocks.field_150346_d.func_176223_P());
            }
            if (this.field_70146_Z.nextInt(100) == 0 || this.getPowered()) {
                entitychicken.func_70096_w().func_75692_b(17, (Object)1);
            }
        }
        super.func_70636_d();
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    protected String func_70639_aQ() {
        return "thetitans:titanCreeperLiving";
    }

    protected String func_70621_aR() {
        return "thetitans:titanCreeperGrunt";
    }

    protected String func_70673_aS() {
        return "thetitans:titanCreeperDeath";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntitySkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        } else if (cause.func_76346_g() instanceof EntityCreeper && cause.func_76346_g() != this && ((EntityCreeper)cause.func_76346_g()).func_70830_n() && ((EntityCreeper)cause.func_76346_g()).func_70650_aV()) {
            ((EntityCreeper)cause.func_76346_g()).func_175493_co();
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 12, 4), 0.0f);
        }
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int l;
        int k;
        int j;
        Item item = this.func_146068_u();
        this.func_145779_a(item, 16);
        if (item != null) {
            j = this.field_70146_Z.nextInt(63);
            if (p_70628_2_ > 0) {
                j += this.field_70146_Z.nextInt(p_70628_2_ + 1);
            }
            for (k = 0; k < j; ++k) {
                this.func_145779_a(item, 2);
            }
        }
        j = this.field_70146_Z.nextInt(15);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151166_bC, 1);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(Items.field_151045_i, 2);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(TitanItems.harcadium, 1);
        }
        k = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (l = 0; l < k; ++l) {
            this.func_70099_a(new ItemStack(Blocks.field_150357_h, 1, 0), 0.0f);
        }
        int t = Item.func_150891_b((Item)Items.field_151096_cd);
        int v = Item.func_150891_b((Item)Items.field_151084_co);
        int q = t + this.field_70146_Z.nextInt(v - t + 1);
        this.func_145779_a(Item.func_150899_d((int)q), 1);
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int p_70829_1_) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)p_70829_1_));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "fire.ignite", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_71038_i();
            if (!this.field_70170_p.field_72995_K) {
                this.func_146079_cb();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.getPowered() ? 2.0f : 1.0f;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            this.func_70106_y();
        }
    }

    public boolean func_146078_ca() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void func_146079_cb() {
        this.field_70180_af.func_75692_b(18, (Object)1);
    }

    public boolean isAIEnabled() {
        return this.field_175494_bm < 1 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }

    protected void func_70619_bc() {
        List list11;
        if (this.field_70181_x < (double)-0.9f && (list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) != null && !list11.isEmpty()) {
            for (int i = 0; i < list11.size(); ++i) {
                Entity entity = (Entity)list11.get(i);
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySpiderTitan) continue;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 50.0f);
            }
        }
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 24.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(10.0f);
            }
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70177_z = 0.0f;
            this.field_70759_as = 0.0f;
            this.field_70125_A = 0.0f;
            this.func_70624_b(null);
        } else {
            super.func_70619_bc();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityZombieTitan || source.func_76346_g() instanceof EntitySkeletonTitan || source.func_76346_g() instanceof EntitySpiderTitan || source.func_76346_g() instanceof EntitySilverfishTitan || source.func_76346_g() instanceof EntityCreeperTitan || source.func_76346_g() instanceof EntityWitherzilla || source.func_76346_g() instanceof EntityEnderColossus) {
            source.func_76346_g().func_85030_a("thetitans:titanpunch", 10.0f, 1.0f);
            return super.func_70097_a(source, amount * 20.0f);
        }
        return super.func_70097_a(source, amount);
    }
}

