/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.Calendar;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.titan.EntityCreeperTitan;
import net.minecraft.entity.titan.EntityEnderColossus;
import net.minecraft.entity.titan.EntitySilverfishTitan;
import net.minecraft.entity.titan.EntitySpiderTitan;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EntityZombieTitan;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAITitanWander;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.common.ForgeHooks;

public class EntitySkeletonTitan
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob,
ITitan {
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 1, 32.0f);
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false);

    public EntitySkeletonTitan(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITitanWander((EntityCreature)this, 0.8, 200));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, Entity.class, 64.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, ITitan.SearchForAThingToKill));
        if (!this.field_70170_p.field_72995_K && this.getSkeletonType() == 1) {
            this.func_70105_a(9.6f, 38.4f);
            this.field_70728_aV = 75000;
            this.field_70138_W = 12.0f;
        } else if (!this.field_70170_p.field_72995_K && this.getSkeletonType() != 1) {
            this.func_70105_a(8.0f, 32.0f);
            this.field_70728_aV = 50000;
            this.field_70138_W = 9.0f;
        }
        if (worldIn != null && !worldIn.field_72995_K) {
            this.setCombatTask();
        }
    }

    public float func_70603_bj() {
        return 16.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7000.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    protected String func_70639_aQ() {
        return "thetitans:titanSkeletonLiving";
    }

    protected String func_70621_aR() {
        return "thetitans:titanSkeletonGrunt";
    }

    protected String func_70673_aS() {
        return "thetitans:titanSkeletonDeath";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
        this.func_85030_a("mob.skeleton.step", 10.0f, 0.5f);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (super.func_70652_k(p_70652_1_)) {
            if (this.getSkeletonType() == 1 && p_70652_1_ instanceof EntityLivingBase) {
                ((EntityLivingBase)p_70652_1_).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 2000));
            }
            return true;
        }
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public int func_70658_aO() {
        return 15;
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2)).func_177230_c();
                    Block blockextra = this.field_70170_p.func_180495_p(new BlockPos(k1, l1 - 1, i2)).func_177230_c();
                    if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(k1, l1, i2))) continue;
                    if (block.func_149638_a((Entity)this) < 500.0f && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(new BlockPos(k1, l1, i2)) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d1 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f2 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)((distance - 12.0f - f2) * damageMultiplier));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.func_174813_aQ().func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySpiderTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1000.0f);
                    double d0 = this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d;
                    double d1 = this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_180495_p(new BlockPos(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public void func_70636_d() {
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(2) == 0) {
            EntityPlayer entityplayer;
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)));
            Block block = iblockstate.func_177230_c();
            if (block.func_149688_o() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
            if ((entityplayer = this.field_70170_p.func_72890_a((Entity)this, 50.0)) != null) {
                for (int s = 0; s < 15; ++s) {
                    entityplayer.field_70125_A += (float)this.field_70146_Z.nextInt(2);
                    entityplayer.field_70125_A -= (float)this.field_70146_Z.nextInt(2);
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.getSkeletonType() == 1) {
            this.func_70105_a(9.6f, 38.4f);
        } else if (this.field_70170_p.field_72995_K && this.getSkeletonType() != 1) {
            this.func_70105_a(8.0f, 32.0f);
        }
        if (this.field_70146_Z.nextInt(60) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            EntitySkeleton entitychicken = new EntitySkeleton(this.field_70170_p);
            int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - 2.0));
            int k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            entitychicken.func_70012_b((double)i, (double)j, (double)k, this.field_70177_z, 0.0f);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.9, 0.0);
            entitychicken.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitychicken)), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0);
            BlockPos blockpos = new BlockPos(entitychicken.field_70165_t, entitychicken.field_70163_u + 1.0, entitychicken.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            this.field_70170_p.func_175718_b(2001, blockpos, Block.func_176210_f((IBlockState)iblockstate));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_175656_a(blockpos, Blocks.field_150346_d.func_176223_P());
            }
            if (this.getSkeletonType() == 1) {
                entitychicken.func_82201_a(1);
                entitychicken.func_70062_b(0, new ItemStack(Items.field_151052_q));
            } else {
                entitychicken.func_82201_a(0);
                entitychicken.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
            }
        }
        super.func_70636_d();
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.field_70154_o instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.field_70154_o;
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76364_f() instanceof EntityArrow && cause.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)cause.func_76346_g();
            double d0 = entityplayer.field_70165_t - this.field_70165_t;
            double d1 = entityplayer.field_70161_v - this.field_70161_v;
            if (d0 * d0 + d1 * d1 >= 2500.0) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_76020_v);
            }
        } else if (cause.func_76346_g() instanceof EntityCreeper && ((EntityCreeper)cause.func_76346_g()).func_70830_n() && ((EntityCreeper)cause.func_76346_g()).func_70650_aV()) {
            ((EntityCreeper)cause.func_76346_g()).func_175493_co();
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 12, this.getSkeletonType() == 1 ? 1 : 0), 0.0f);
        }
    }

    protected Item func_146068_u() {
        return Items.field_151032_g;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int l;
        int k;
        int j;
        this.func_145779_a(Items.field_151103_aS, 16);
        if (this.getSkeletonType() == 1) {
            this.func_145779_a(Items.field_151044_h, 16);
            this.func_145779_a(Items.field_151052_q, 1);
            j = this.field_70146_Z.nextInt(63 + p_70628_2_) - 1;
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151044_h, 2);
            }
            if (p_70628_1_ && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
                this.func_145779_a(Items.field_151052_q, 1);
            }
            if (p_70628_1_ && (this.field_70146_Z.nextInt(10) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
            }
        } else {
            this.func_145779_a((Item)Items.field_151031_f, 1);
            this.func_145779_a(Items.field_151032_g, 16);
            j = this.field_70146_Z.nextInt(63 + p_70628_2_);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151032_g, 2);
            }
            if (p_70628_1_ && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
                this.func_145779_a((Item)Items.field_151031_f, 1);
            }
            if (p_70628_1_ && (this.field_70146_Z.nextInt(10) == 0 || this.field_70146_Z.nextInt(1 + p_70628_2_) > 0)) {
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
            }
        }
        j = this.field_70146_Z.nextInt(63 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151103_aS, 2);
        }
        j = this.field_70146_Z.nextInt(15);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151166_bC, 1);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(Items.field_151045_i, 2);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(TitanItems.harcadium, 1);
        }
        k = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (l = 0; l < k; ++l) {
            this.func_70099_a(new ItemStack(Blocks.field_150357_h, 1, 0), 0.0f);
        }
    }

    protected void func_82164_bB() {
        if (this.getSkeletonType() == 1) {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 256, 1), 0.0f);
        } else {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 256, 0), 0.0f);
        }
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        super.func_180481_a(p_180481_1_);
        this.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData p_180482_2_) {
        Calendar calendar;
        p_180482_2_ = super.func_180482_a(p_180482_1_, p_180482_2_);
        this.func_98053_h(true);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderHell && this.func_70681_au().nextInt(5) > 0 && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            this.setSkeletonType(1);
            this.func_70062_b(0, new ItemStack(Items.field_151052_q));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(140.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20000.0);
            this.func_70606_j(20000.0f);
            this.func_70105_a(9.6f, 38.4f);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
            this.func_180481_a(p_180482_1_);
            this.func_180483_b(p_180482_1_);
            this.func_70105_a(8.0f, 32.0f);
        }
        if (this.func_71124_b(4) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_70062_b(4, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_82174_bp[4] = 0.0f;
        }
        return p_180482_2_;
    }

    public void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151031_f) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        EntityArrow entityarrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, p_82196_2_);
        double d0 = p_82196_1_.field_70165_t - this.field_70165_t;
        double d1 = p_82196_1_.field_70163_u + (double)p_82196_1_.func_70047_e() - entityarrow.field_70163_u;
        double d2 = p_82196_1_.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        entityarrow.func_70186_c(d0, d1 + (double)f1, d2, 22.4f, 8.0f);
        int i = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        int f = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm());
        entityarrow.func_70239_b(10.0);
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (f > 0 || this.getSkeletonType() == 1) {
            entityarrow.func_70015_d(100);
        }
        this.func_85030_a("random.bow", 10.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    public int getSkeletonType() {
        return this.field_70180_af.func_75683_a(13);
    }

    public void setSkeletonType(int p_82201_1_) {
        this.field_70180_af.func_75692_b(13, (Object)((byte)p_82201_1_));
        if (p_82201_1_ == 1) {
            this.func_70105_a(9.6f, 38.4f);
        } else {
            this.func_70105_a(8.0f, 32.0f);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(100) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("SkeletonType", 99)) {
            byte b0 = tagCompund.func_74771_c("SkeletonType");
            this.setSkeletonType(b0);
        }
        this.setCombatTask();
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("SkeletonType", (byte)this.getSkeletonType());
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public void func_82206_m() {
        this.setInvulTime(880);
        this.func_70606_j(this.func_110138_aP() / 2.0f);
    }

    public void func_70062_b(int slotIn, ItemStack stack) {
        super.func_70062_b(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == 0) {
            this.setCombatTask();
        }
    }

    public float func_70047_e() {
        return this.getSkeletonType() == 1 ? 33.12f : 27.6f;
    }

    protected void func_70619_bc() {
        List list11;
        if (this.field_70181_x < (double)-0.9f && (list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) != null && !list11.isEmpty()) {
            for (int i = 0; i < list11.size(); ++i) {
                Entity entity = (Entity)list11.get(i);
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySpiderTitan) continue;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 50.0f);
            }
        }
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 24.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(10.0f);
            }
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70177_z = 0.0f;
            this.field_70759_as = 0.0f;
            this.field_70125_A = 0.0f;
            this.func_70624_b(null);
        } else {
            super.func_70619_bc();
        }
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityZombieTitan || source.func_76346_g() instanceof EntitySkeletonTitan || source.func_76346_g() instanceof EntitySpiderTitan || source.func_76346_g() instanceof EntitySilverfishTitan || source.func_76346_g() instanceof EntityCreeperTitan || source.func_76346_g() instanceof EntityWitherzilla || source.func_76346_g() instanceof EntityEnderColossus) {
            source.func_76346_g().func_85030_a("thetitans:titanpunch", 10.0f, 1.0f);
            return super.func_70097_a(source, amount * 20.0f);
        }
        return super.func_70097_a(source, amount);
    }
}

