/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityCreeperTitan;
import net.minecraft.entity.titan.EntityEnderColossus;
import net.minecraft.entity.titan.EntitySilverfishTitan;
import net.minecraft.entity.titan.EntitySkeletonTitan;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.EntityZombieTitan;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAITitanWander;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntitySpiderTitan
extends EntityMob
implements IBossDisplayData,
ITitan {
    public EntitySpiderTitan(World worldIn) {
        super(worldIn);
        this.field_70138_W = 5.0f;
        this.func_70105_a(27.25f, 13.0f);
        this.field_70728_aV = 20000;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.75, false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITitanWander((EntityCreature)this, 0.8, 200));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, Entity.class, 64.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, ITitan.SearchForAThingToKill));
    }

    public float func_70603_bj() {
        return 16.0f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public int func_70658_aO() {
        return 15;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public void func_82206_m() {
        this.setInvulTime(880);
        this.func_70606_j(this.func_110138_aP() / 2.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5000.0);
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(100) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    protected String func_70639_aQ() {
        return "thetitans:titanSpiderLiving";
    }

    protected String func_70621_aR() {
        return "thetitans:titanSpiderGrunt";
    }

    protected String func_70673_aS() {
        return "thetitans:titanSpiderDeath";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.5f);
    }

    public void func_70636_d() {
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(2) == 0) {
            EntityPlayer entityplayer;
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)));
            Block block = iblockstate.func_177230_c();
            if (block.func_149688_o() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
            if ((entityplayer = this.field_70170_p.func_72890_a((Entity)this, 50.0)) != null) {
                for (int s = 0; s < 15; ++s) {
                    entityplayer.field_70125_A += (float)this.field_70146_Z.nextInt(2);
                    entityplayer.field_70125_A -= (float)this.field_70146_Z.nextInt(2);
                }
            }
        }
        if (this.field_70146_Z.nextInt(40) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            EntitySpider entitychicken = this.createInstance();
            int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)25, (int)50) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5));
            int k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)25, (int)50) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70012_b((double)i, (double)j, (double)k, this.field_70177_z, 0.0f);
            entitychicken.func_70024_g(0.0, 0.75, 0.0);
            entitychicken.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitychicken)), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0);
            BlockPos blockpos = new BlockPos(entitychicken.field_70165_t, entitychicken.field_70163_u, entitychicken.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            this.field_70170_p.func_175718_b(2001, blockpos, Block.func_176210_f((IBlockState)iblockstate));
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_175656_a(blockpos, Blocks.field_150346_d.func_176223_P());
            }
        }
        super.func_70636_d();
    }

    protected EntitySpider createInstance() {
        return new EntitySpider(this.field_70170_p);
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int l;
        int k;
        int j;
        Item item = this.func_146068_u();
        this.func_145779_a(item, 16);
        if (item != null) {
            j = this.field_70146_Z.nextInt(255);
            if (p_70628_2_ > 0) {
                j += this.field_70146_Z.nextInt(p_70628_2_ + 1);
            }
            for (k = 0; k < j; ++k) {
                this.func_145779_a(item, 2);
            }
        }
        j = this.field_70146_Z.nextInt(15);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151166_bC, 1);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(Items.field_151045_i, 2);
        }
        k = 3 + this.field_70146_Z.nextInt(7);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(TitanItems.harcadium, 1);
        }
        k = 3 + this.field_70146_Z.nextInt(7);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect p_70687_1_) {
        return p_70687_1_.func_76456_a() == Potion.field_76436_u.field_76415_H ? false : super.func_70687_e(p_70687_1_);
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean p_70839_1_) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData p_180482_2_) {
        int i;
        IEntityLivingData p_180482_2_1 = super.func_180482_a(p_180482_1_, p_180482_2_);
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            EntitySkeletonTitan entityskeleton = new EntitySkeletonTitan(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_180482_a(p_180482_1_, null);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_70078_a((Entity)this);
        }
        if (p_180482_2_1 == null) {
            p_180482_2_1 = new GroupData();
            if (this.field_70170_p.field_73012_v.nextFloat() < 0.1f * p_180482_1_.func_180170_c()) {
                ((GroupData)p_180482_2_1).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (p_180482_2_1 instanceof GroupData && (i = ((GroupData)p_180482_2_1).field_111105_a) > 0 && Potion.field_76425_a[i] != null) {
            this.func_70690_d(new PotionEffect(i, Integer.MAX_VALUE));
        }
        return p_180482_2_1;
    }

    public float func_70047_e() {
        return 10.4f;
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2)).func_177230_c();
                    Block blockextra = this.field_70170_p.func_180495_p(new BlockPos(k1, l1 - 1, i2)).func_177230_c();
                    if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(k1, l1, i2))) continue;
                    if (block.func_149638_a((Entity)this) < 500.0f && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(new BlockPos(k1, l1, i2)) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d1 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f2 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)((distance - 12.0f - f2) * damageMultiplier));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.func_174813_aQ().func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySpiderTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1000.0f);
                    double d0 = this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d;
                    double d1 = this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_180495_p(new BlockPos(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    protected void func_70619_bc() {
        List list11;
        if (this.field_70181_x < (double)-0.9f && (list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) != null && !list11.isEmpty()) {
            for (int i = 0; i < list11.size(); ++i) {
                Entity entity = (Entity)list11.get(i);
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySpiderTitan) continue;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 50.0f);
            }
        }
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 24.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(10.0f);
            }
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70177_z = 0.0f;
            this.field_70759_as = 0.0f;
            this.field_70125_A = 0.0f;
            this.func_70624_b(null);
        } else {
            super.func_70619_bc();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityZombieTitan || source.func_76346_g() instanceof EntitySkeletonTitan || source.func_76346_g() instanceof EntitySpiderTitan || source.func_76346_g() instanceof EntitySilverfishTitan || source.func_76346_g() instanceof EntityCreeperTitan || source.func_76346_g() instanceof EntityWitherzilla || source.func_76346_g() instanceof EntityEnderColossus) {
            source.func_76346_g().func_85030_a("thetitans:titanpunch", 10.0f, 1.0f);
            return super.func_70097_a(source, amount * 20.0f);
        }
        return super.func_70097_a(source, amount);
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_111105_a;

        public void func_111104_a(Random p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.field_111105_a = Potion.field_76424_c.field_76415_H;
            } else if (i <= 2) {
                this.field_111105_a = Potion.field_76420_g.field_76415_H;
            } else if (i <= 3) {
                this.field_111105_a = Potion.field_76428_l.field_76415_H;
            } else if (i <= 4) {
                this.field_111105_a = Potion.field_76441_p.field_76415_H;
            }
        }
    }
}

