/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.titan;

import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.titan.EntityCreeperTitan;
import net.minecraft.entity.titan.EntityEnderColossus;
import net.minecraft.entity.titan.EntitySilverfishTitan;
import net.minecraft.entity.titan.EntitySkeletonTitan;
import net.minecraft.entity.titan.EntitySpiderTitan;
import net.minecraft.entity.titan.EntityWitherzilla;
import net.minecraft.entity.titan.ITitan;
import net.minecraft.entity.titan.ai.EntityAITitanWander;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.theTitans.TitanItems;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;

public class EntityZombieTitan
extends EntityMob
implements IBossDisplayData,
ITitan {
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    private final EntityAIBreakDoor breakDoor = new EntityAIBreakDoor((EntityLiving)this);
    private int conversionTime;
    private boolean field_146076_bu = false;
    private float zombieWidth = -3.0f;
    private float zombieHeight;

    public EntityZombieTitan(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITitanWander((EntityCreature)this, 0.8, 200));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, Entity.class, 64.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, ITitan.SearchForAThingToKill));
        this.func_70105_a(8.0f, 32.0f);
        this.field_70138_W = 9.0f;
        this.field_70728_aV = 50000;
    }

    public float func_70603_bj() {
        return 16.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(70.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7000.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)0);
        this.func_70096_w().func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public int func_70658_aO() {
        return 15;
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2)).func_177230_c();
                    Block blockextra = this.field_70170_p.func_180495_p(new BlockPos(k1, l1 - 1, i2)).func_177230_c();
                    if (block.isAir((IBlockAccess)this.field_70170_p, new BlockPos(k1, l1, i2))) continue;
                    if (block.func_149638_a((Entity)this) < 500.0f && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(new BlockPos(k1, l1, i2)) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d1 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        PotionEffect potioneffect = this.func_70660_b(Potion.field_76430_j);
        float f2 = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        int i = MathHelper.func_76123_f((float)((distance - 12.0f - f2) * damageMultiplier));
        if (i > 0) {
            int l;
            int k;
            int j;
            Block block;
            this.func_85030_a("thetitans:titanland", 10000.0f, 1.0f);
            this.destroyBlocksInAABB(this.func_174813_aQ().func_72314_b(16.0, 2.0, 16.0));
            List list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(48.0, 2.0, 48.0));
            if (list11 != null && !list11.isEmpty()) {
                for (int i1 = 0; i1 < list11.size(); ++i1) {
                    Entity entity = (Entity)list11.get(i1);
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySpiderTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1000.0f);
                    double d0 = this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d;
                    double d1 = this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f;
                    double d2 = entity.field_70165_t - d0;
                    double d3 = entity.field_70161_v - d1;
                    double d4 = d2 * d2 + d3 * d3;
                    entity.func_70024_g(d2 / d4 * 8.0, 1.0, d3 / d4 * 8.0);
                }
            }
            if ((block = this.field_70170_p.func_180495_p(new BlockPos(j = MathHelper.func_76128_c((double)this.field_70165_t), k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), l = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public boolean func_146072_bX() {
        return this.field_146076_bu;
    }

    public void func_146070_a(boolean p_146070_1_) {
        if (this.field_146076_bu != p_146070_1_) {
            this.field_146076_bu = p_146070_1_;
            if (p_146070_1_) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
            }
        }
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(250) == 0 && super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70631_g_() {
        return this.func_70096_w().func_75683_a(12) == 1;
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void setChild(boolean childZombie) {
        this.func_70096_w().func_75692_b(12, (Object)((byte)(childZombie ? 1 : 0)));
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);
            if (childZombie) {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }
        this.setChildSize(childZombie);
    }

    public boolean isVillager() {
        return this.func_70096_w().func_75683_a(13) == 1;
    }

    public void setVillager(boolean villager) {
        this.func_70096_w().func_75692_b(13, (Object)((byte)(villager ? 1 : 0)));
    }

    protected EntityZombie createInstance() {
        return new EntityZombie(this.field_70170_p);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(2) == 0) {
            EntityPlayer entityplayer;
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)));
            Block block = iblockstate.func_177230_c();
            if (block.func_149688_o() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
            if ((entityplayer = this.field_70170_p.func_72890_a((Entity)this, 50.0)) != null) {
                for (int s = 0; s < 15; ++s) {
                    entityplayer.field_70125_A += (float)this.field_70146_Z.nextInt(2);
                    entityplayer.field_70125_A -= (float)this.field_70146_Z.nextInt(2);
                }
            }
        }
        if (this.field_70170_p.func_72935_r()) {
            if (this.field_70173_aa % 100 == 0) {
                this.func_70691_i(1.0f);
            }
        } else if (this.field_70173_aa % 10 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.field_70146_Z.nextInt(60) == 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
            Block block;
            IBlockState iblockstate;
            BlockPos blockpos;
            EntityZombie entitychicken = this.createInstance();
            int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - 2.0));
            int k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)15, (int)30) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
            entitychicken.func_70012_b((double)i, (double)j, (double)k, this.field_70177_z, 0.0f);
            entitychicken.func_85030_a("thetitans:titansummonminion", 2.0f, 1.0f);
            entitychicken.func_70024_g(0.0, 0.9, 0.0);
            entitychicken.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitychicken)), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitychicken);
            entitychicken.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0);
            if (this.func_70631_g_()) {
                entitychicken.func_82227_f(true);
                entitychicken.func_70012_b((double)i, (double)j + 2.0, (double)k, this.field_70177_z, 0.0f);
                blockpos = new BlockPos(entitychicken.field_70165_t, entitychicken.field_70163_u - 1.0, entitychicken.field_70161_v);
                iblockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block2 = iblockstate.func_177230_c();
                this.field_70170_p.func_175718_b(2001, blockpos, Block.func_176210_f((IBlockState)iblockstate));
                if (block2 == Blocks.field_150349_c) {
                    this.field_70170_p.func_175656_a(blockpos, Blocks.field_150346_d.func_176223_P());
                }
            }
            if (this.isVillager()) {
                entitychicken.func_82229_g(true);
            }
            if ((block = (iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(entitychicken.field_70165_t, entitychicken.field_70163_u + 1.0, entitychicken.field_70161_v))).func_177230_c()) == Blocks.field_150349_c) {
                this.field_70170_p.func_175656_a(blockpos, Blocks.field_150346_d.func_176223_P());
                this.field_70170_p.func_175718_b(2001, blockpos, Block.func_176210_f((IBlockState)iblockstate));
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_70619_bc() {
        List list11;
        if (this.field_70181_x < (double)-0.9f && (list11 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) != null && !list11.isEmpty()) {
            for (int i = 0; i < list11.size(); ++i) {
                Entity entity = (Entity)list11.get(i);
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityEnderColossus || entity instanceof EntityZombieTitan || entity instanceof EntityCreeperTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySkeletonTitan || entity instanceof EntitySilverfishTitan || entity instanceof EntitySpiderTitan) continue;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 50.0f);
            }
        }
        if (this.getInvulTime() > 0) {
            int i = this.getInvulTime() - 1;
            if (i <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 24.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1013, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(i);
            if (this.field_70173_aa % 1 == 0) {
                this.func_70691_i(10.0f);
            }
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70177_z = 0.0f;
            this.field_70759_as = 0.0f;
            this.field_70125_A = 0.0f;
            this.func_70624_b(null);
        } else {
            super.func_70619_bc();
        }
    }

    protected String func_70639_aQ() {
        return "thetitans:titanZombieLiving";
    }

    protected String func_70621_aR() {
        return "thetitans:titanZombieGrunt";
    }

    protected String func_70673_aS() {
        return "thetitans:titanZombieDeath";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("thetitans:titanStep", 10.0f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151078_bh;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int l;
        int k;
        int j;
        Item item = this.func_146068_u();
        this.func_145779_a(item, 16);
        if (item != null) {
            j = this.field_70146_Z.nextInt(63);
            if (p_70628_2_ > 0) {
                j += this.field_70146_Z.nextInt(p_70628_2_ + 1);
            }
            for (k = 0; k < j; ++k) {
                this.func_145779_a(item, 2);
            }
        }
        j = this.field_70146_Z.nextInt(15);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151166_bC, 1);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(Items.field_151045_i, 2);
        }
        k = 3 + this.field_70146_Z.nextInt(15);
        for (l = 0; l < k; ++l) {
            this.func_145779_a(TitanItems.harcadium, 1);
        }
        k = this.field_70146_Z.nextInt(2 + p_70628_2_);
        for (l = 0; l < k; ++l) {
            this.func_70099_a(new ItemStack(Blocks.field_150357_h, 1, 0), 0.0f);
        }
    }

    protected void func_82164_bB() {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.func_145779_a(Items.field_151042_j, 64);
                break;
            }
            case 1: {
                this.func_145779_a(Items.field_151172_bF, 64);
                break;
            }
            case 2: {
                this.func_145779_a(Items.field_151174_bG, 64);
            }
        }
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        super.func_180481_a(p_180481_1_);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_70062_b(0, new ItemStack(Items.field_151040_l));
            } else {
                this.func_70062_b(0, new ItemStack(Items.field_151037_a));
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.func_70631_g_()) {
            tagCompound.func_74757_a("IsBaby", true);
        }
        if (this.isVillager()) {
            tagCompound.func_74757_a("IsVillager", true);
        }
        tagCompound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
        if (tagCompund.func_74767_n("IsVillager")) {
            this.setVillager(true);
        }
        this.setInvulTime(tagCompund.func_74762_e("Invul"));
    }

    public int getInvulTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setInvulTime(int p_82215_1_) {
        this.field_70180_af.func_75692_b(20, (Object)p_82215_1_);
    }

    public void func_82206_m() {
        this.setInvulTime(880);
        this.func_70606_j(this.func_110138_aP() / 2.0f);
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        if ((this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && entityLivingIn instanceof EntityVillager) {
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            EntityZombie entityzombie = new EntityZombie(this.field_70170_p);
            entityzombie.func_82149_j((Entity)entityLivingIn);
            this.field_70170_p.func_72900_e((Entity)entityLivingIn);
            entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), (IEntityLivingData)null);
            entityzombie.func_82229_g(false);
            if (entityLivingIn.func_70631_g_()) {
                entityzombie.func_82227_f(true);
            }
            this.field_70170_p.func_72838_d((Entity)entityzombie);
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        }
    }

    public float func_70047_e() {
        float f = 27.6f;
        if (this.func_70631_g_()) {
            f = (float)((double)f / 2.0);
        }
        return f;
    }

    protected boolean func_175448_a(ItemStack p_175448_1_) {
        return p_175448_1_.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_70115_ae() ? false : super.func_175448_a(p_175448_1_);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData p_180482_2_) {
        Calendar calendar;
        IEntityLivingData p_180482_2_1 = super.func_180482_a(p_180482_1_, p_180482_2_);
        float f = p_180482_1_.func_180170_c();
        this.func_98053_h(true);
        if (p_180482_2_1 == null) {
            p_180482_2_1 = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance, this.field_70170_p.field_73012_v.nextFloat() < 0.05f, null);
        }
        if (p_180482_2_1 instanceof GroupData) {
            GroupData groupdata = (GroupData)p_180482_2_1;
            if (groupdata.field_142046_b) {
                this.setVillager(true);
            }
            if (groupdata.field_142048_a) {
                this.setChild(true);
            }
        }
        this.func_146070_a(this.field_70146_Z.nextFloat() < f * 0.1f);
        this.func_180481_a(p_180482_1_);
        this.func_180483_b(p_180482_1_);
        if (this.func_71124_b(4) == null && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_70062_b(4, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_82174_bp[4] = 0.0f;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.func_146070_a(true);
        }
        return p_180482_2_1;
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.zombieWidth > 0.0f && this.zombieHeight > 0.0f;
        this.zombieWidth = width;
        this.zombieHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.zombieWidth * size, this.zombieHeight * size);
    }

    public double func_70033_W() {
        return super.func_70033_W() - 0.5;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntityCreeper && ((EntityCreeper)cause.func_76346_g()).func_70830_n() && ((EntityCreeper)cause.func_76346_g()).func_70650_aV()) {
            ((EntityCreeper)cause.func_76346_g()).func_175493_co();
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 12, 2), 0.0f);
        }
    }

    protected float func_70599_aP() {
        return 100.0f;
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityZombieTitan || source.func_76346_g() instanceof EntitySkeletonTitan || source.func_76346_g() instanceof EntitySpiderTitan || source.func_76346_g() instanceof EntitySilverfishTitan || source.func_76346_g() instanceof EntityCreeperTitan || source.func_76346_g() instanceof EntityWitherzilla || source.func_76346_g() instanceof EntityEnderColossus) {
            source.func_76346_g().func_85030_a("thetitans:titanpunch", 10.0f, 1.0f);
            return super.func_70097_a(source, amount * 20.0f);
        }
        return super.func_70097_a(source, amount);
    }

    class GroupData
    implements IEntityLivingData {
        public boolean field_142048_a = false;
        public boolean field_142046_b = false;
        private static final String __OBFID = "CL_00001704";

        private GroupData(boolean p_i2348_2_, boolean p_i2348_3_) {
            this.field_142048_a = p_i2348_2_;
            this.field_142046_b = p_i2348_3_;
        }

        GroupData(boolean p_i2349_2_, boolean p_i2349_3_, Object p_i2349_4_) {
            this(p_i2349_2_, p_i2349_3_);
        }
    }
}

