/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.theTitans.world;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderVoid
implements IChunkProvider {
    private Random voidRNG;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    public NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    private World voidWorld;
    private double[] densities;
    private BiomeGenBase[] biomesForGeneration;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    private int chunkX = 0;
    private int chunkZ = 0;

    public ChunkProviderVoid(World worldIn, long p_i2007_2_) {
        this.voidWorld = worldIn;
        this.voidRNG = new Random(p_i2007_2_);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.voidRNG, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.voidRNG, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.voidRNG, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.voidRNG, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.voidRNG, 16);
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.voidRNG, (NoiseGenerator[])noiseGens);
        this.noiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.noiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.noiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen4 = (NoiseGeneratorOctaves)noiseGens[3];
        this.noiseGen5 = (NoiseGeneratorOctaves)noiseGens[4];
    }

    public void func_180520_a(int p_180520_1_, int p_180520_2_, ChunkPrimer p_180520_3_) {
        int b0 = 2;
        int k = b0 + 1;
        int b1 = 33;
        int l = b0 + 1;
        this.densities = this.initializeNoiseField(this.densities, p_180520_1_ * b0, 0, p_180520_2_ * b0, k, b1, l);
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d0 = 0.25;
                    double d1 = this.densities[((i1 + 0) * l + j1 + 0) * b1 + k1 + 0];
                    double d2 = this.densities[((i1 + 0) * l + j1 + 1) * b1 + k1 + 0];
                    double d3 = this.densities[((i1 + 1) * l + j1 + 0) * b1 + k1 + 0];
                    double d4 = this.densities[((i1 + 1) * l + j1 + 1) * b1 + k1 + 0];
                    double d5 = (this.densities[((i1 + 0) * l + j1 + 0) * b1 + k1 + 1] - d1) * d0;
                    double d6 = (this.densities[((i1 + 0) * l + j1 + 1) * b1 + k1 + 1] - d2) * d0;
                    double d7 = (this.densities[((i1 + 1) * l + j1 + 0) * b1 + k1 + 1] - d3) * d0;
                    double d8 = (this.densities[((i1 + 1) * l + j1 + 1) * b1 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                IBlockState iblockstate = null;
                                if (d15 > 0.0) {
                                    iblockstate = Blocks.field_150357_h.func_176223_P();
                                }
                                int k2 = i2 + i1 * 8;
                                int l2 = l1 + k1 * 4;
                                int i3 = j2 + j1 * 8;
                                p_180520_3_.func_177855_a(k2, l2, i3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_180519_a(ChunkPrimer p_180519_1_) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, this.chunkX, this.chunkZ, p_180519_1_, this.voidWorld);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int b0 = 1;
                int k = -1;
                IBlockState iblockstate = Blocks.field_150357_h.func_176223_P();
                IBlockState iblockstate1 = Blocks.field_150357_h.func_176223_P();
                for (int l = 127; l >= 0; --l) {
                    IBlockState iblockstate2 = p_180519_1_.func_177856_a(i, l, j);
                    if (iblockstate2.func_177230_c().func_149688_o() == Material.field_151579_a) {
                        k = -1;
                        continue;
                    }
                    if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
                    if (k == -1) {
                        if (b0 <= 0) {
                            iblockstate = Blocks.field_150350_a.func_176223_P();
                            iblockstate1 = Blocks.field_150357_h.func_176223_P();
                        }
                        k = b0;
                        if (l >= 0) {
                            p_180519_1_.func_177855_a(i, l, j, iblockstate);
                            continue;
                        }
                        p_180519_1_.func_177855_a(i, l, j, iblockstate1);
                        continue;
                    }
                    if (k <= 0) continue;
                    --k;
                    p_180519_1_.func_177855_a(i, l, j, iblockstate1);
                }
            }
        }
    }

    public Chunk func_73154_d(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
        this.voidRNG.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.voidWorld.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.func_180520_a(x, z, chunkprimer);
        this.func_180519_a(chunkprimer);
        Chunk chunk = new Chunk(this.voidWorld, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int k = 0; k < abyte.length; ++k) {
            abyte[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    private double[] initializeNoiseField(double[] p_73187_1_, int p_73187_2_, int p_73187_3_, int p_73187_4_, int p_73187_5_, int p_73187_6_, int p_73187_7_) {
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, p_73187_1_, p_73187_2_, p_73187_3_, p_73187_4_, p_73187_5_, p_73187_6_, p_73187_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (p_73187_1_ == null) {
            p_73187_1_ = new double[p_73187_5_ * p_73187_6_ * p_73187_7_];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.noiseData4 = this.noiseGen4.func_76305_a(this.noiseData4, p_73187_2_, p_73187_4_, p_73187_5_, p_73187_7_, 1.121, 1.121, 0.5);
        this.noiseData5 = this.noiseGen5.func_76305_a(this.noiseData5, p_73187_2_, p_73187_4_, p_73187_5_, p_73187_7_, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, p_73187_2_, p_73187_3_, p_73187_4_, p_73187_5_, p_73187_6_, p_73187_7_, (d0 *= 2.0) / 80.0, d1 / 160.0, d0 / 80.0);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, p_73187_2_, p_73187_3_, p_73187_4_, p_73187_5_, p_73187_6_, p_73187_7_, d0, d1, d0);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, p_73187_2_, p_73187_3_, p_73187_4_, p_73187_5_, p_73187_6_, p_73187_7_, d0, d1, d0);
        int k1 = 0;
        for (int l1 = 0; l1 < p_73187_5_; ++l1) {
            for (int i2 = 0; i2 < p_73187_7_; ++i2) {
                float f = (float)(l1 + p_73187_2_) / 1.0f;
                float f1 = (float)(i2 + p_73187_4_) / 1.0f;
                float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
                if (f2 > 80.0f) {
                    f2 = 80.0f;
                }
                if (f2 < -100.0f) {
                    f2 = -100.0f;
                }
                for (int j2 = 0; j2 < p_73187_6_; ++j2) {
                    double d6;
                    double d2 = 0.0;
                    double d3 = this.noiseData2[k1] / 512.0;
                    double d4 = this.noiseData3[k1] / 512.0;
                    double d5 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d2 = d5 < 0.0 ? d3 : (d5 > 1.0 ? d4 : d3 + (d4 - d3) * d5);
                    d2 -= 8.0;
                    d2 += (double)f2;
                    int b0 = 2;
                    if (j2 > p_73187_6_ / 2 - b0) {
                        d6 = (float)(j2 - (p_73187_6_ / 2 - b0)) / 64.0f;
                        d6 = MathHelper.func_151237_a((double)d6, (double)0.0, (double)1.0);
                        d2 = d2 * (1.0 - d6) + -3000.0 * d6;
                    }
                    if (j2 < (b0 = 8)) {
                        d6 = (float)(b0 - j2) / ((float)b0 - 1.0f);
                        d2 = d2 * (1.0 - d6) + -30.0 * d6;
                    }
                    p_73187_1_[k1] = d2;
                    ++k1;
                }
            }
        }
        return p_73187_1_;
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        BlockFalling.field_149832_M = true;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(p_73153_1_, this.voidWorld, this.voidWorld.field_73012_v, p_73153_2_, p_73153_3_, false));
        BlockPos blockpos = new BlockPos(p_73153_2_ * 16, 0, p_73153_3_ * 16);
        this.voidWorld.func_180494_b(blockpos.func_177982_a(16, 0, 16)).func_180624_a(this.voidWorld, this.voidWorld.field_73012_v, blockpos);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(p_73153_1_, this.voidWorld, this.voidWorld.field_73012_v, p_73153_2_, p_73153_3_, false));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_177460_a(IChunkProvider p_177460_1_, Chunk p_177460_2_, int p_177460_3_, int p_177460_4_) {
        return false;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_177458_a(EnumCreatureType p_177458_1_, BlockPos p_177458_2_) {
        return this.voidWorld.func_180494_b(p_177458_2_).func_76747_a(p_177458_1_);
    }

    public BlockPos func_180513_a(World worldIn, String p_180513_2_, BlockPos p_180513_3_) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_180514_a(Chunk p_180514_1_, int p_180514_2_, int p_180514_3_) {
    }

    public Chunk func_177459_a(BlockPos blockPosIn) {
        return this.func_73154_d(blockPosIn.func_177958_n() >> 4, blockPosIn.func_177952_p() >> 4);
    }
}

