/*
 * Decompiled with CFR 0.152.
 */
package stephen_789.biplanesMod.entities;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import stephen_789.biplanesMod.biplanesMod;
import stephen_789.biplanesMod.infotypes.tAngle;
import stephen_789.biplanesMod.infotypes.tCoord;
import stephen_789.biplanesMod.infotypes.tForce;
import stephen_789.biplanesMod.infotypes.tVector;
import stephen_789.biplanesMod.items.BiplaneAugmentItem;
import stephen_789.biplanesMod.items.mechanicWrench;
import stephen_789.biplanesMod.libraries.materialHandler;
import stephen_789.biplanesMod.libraries.mathTools;
import stephen_789.biplanesMod.planecomponents.containedparts.tPlaneAileron;
import stephen_789.biplanesMod.planecomponents.containedparts.tPlaneEngine;
import stephen_789.biplanesMod.planecomponents.containedparts.tPlaneSeat;
import stephen_789.biplanesMod.planecomponents.containedparts.tPlaneStructSpecial;
import stephen_789.biplanesMod.planecomponents.tPlaneStructBlock;
import stephen_789.biplanesMod.planecomponents.tPlaneStructPart;
import stephen_789.biplanesMod.planecomponents.tPlaneStructSlab;
import stephen_789.biplanesMod.planecomponents.tPlaneStructStabilizer;
import stephen_789.biplanesMod.planecomponents.tPlaneStructWing;

public class entityBiplane
extends Entity {
    public double airDensity = 1.225 / (287.05 * mathTools.cToKelvin(15.0));
    public double lift;
    public tForce massAndCG;
    public int identIndex;
    public int maxWidth = 11;
    public int maxHeight = 5;
    public int maxDepth = 7;
    public tPlaneStructPart[][][] blockDat = new tPlaneStructPart[this.maxWidth][this.maxHeight][this.maxDepth];
    public tPlaneStructSpecial[][][] inBlockDat = new tPlaneStructSpecial[this.maxWidth][this.maxHeight][this.maxDepth];
    public float yaw;
    public float pitch;
    public float roll;
    public float prevYaw = 0.0f;
    public float prevPitch = 0.0f;
    public float prevRoll = 0.0f;
    public float animStep = 0.0f;
    public double dX = 0.0;
    public double dY = 0.0;
    public double dZ = 0.0;
    public float dYaw = 0.0f;
    public float dPitch = 0.0f;
    public float dRoll = 0.0f;
    public float renderDYaw = 0.0f;
    public float renderDPitch = 0.0f;
    public float renderDRoll = 0.0f;
    public double rotorSpeed = 0.0;
    public double throttlePercent = 0.0;
    public double prevThrottlePercent = 0.0;
    public int engineMake = 0;
    public boolean autoStableTurn = false;
    public boolean autoStableLift = false;
    public boolean engineStarted = false;
    public boolean prevEngineStarted = false;
    public int aileronCount = 0;
    public int elevatorCount = 0;
    public int rudderCount = 0;
    public int wingArea = 0;
    public int wingSpan = 0;
    public int craftLength = 0;
    public int engineCount = 0;
    public Entity prevRiddenByEntity;
    public EntityPlayer owner;
    public String ownerID;
    public tCoord tPos = new tCoord(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    public tCoord seatPos = new tCoord(0.0, 0.0, 0.0);
    public float prevRenderYaw = 0.0f;
    public float renderYaw = 0.0f;
    public float prevRenderPitch = 0.0f;
    public float renderPitch = 0.0f;
    public float prevRenderRoll = 0.0f;
    public float renderRoll = 0.0f;
    public boolean firstTime = true;
    public int FPR = 1;
    public int lastFPR = 1;
    public float lastAnimStep = 0.0f;
    public EntityItem[] itemQueue = new EntityItem[10];
    public boolean key_up = false;
    public boolean key_down = false;
    public boolean key_left = false;
    public boolean key_right = false;
    public boolean key_lctrl = false;
    public boolean key_lshift = false;
    public boolean key_space = false;
    public boolean mouse_left = false;
    public boolean mouse_right = false;
    public boolean prevkey_up = false;
    public boolean prevkey_down = false;
    public boolean prevkey_left = false;
    public boolean prevkey_right = false;
    public boolean prevkey_lctrl = false;
    public boolean prevkey_lshift = false;
    public boolean prevkey_space = false;
    public boolean prevmouse_left = false;
    public boolean prevmouse_right = false;
    private int readCount = 0;
    public boolean prevOnGround = false;

    public entityBiplane(World world, float yaw, float pitch, float roll) {
        super(world);
        biplanesMod.biplaneList.ensureCapacity(biplanesMod.biplaneList.size() + 1);
        biplanesMod.biplaneList.add(this);
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.func_70105_a(3.0f, 3.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public entityBiplane(World world) {
        super(world);
        biplanesMod.biplaneList.ensureCapacity(biplanesMod.biplaneList.size() + 1);
        biplanesMod.biplaneList.add(this);
        this.func_70105_a(3.0f, 3.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public void calcPlaneValues() {
        this.aileronCount = this.calcAileronArea(true);
        this.elevatorCount = this.calcAileronArea(false);
        this.rudderCount = this.calcRudderArea(false);
        this.wingArea = this.calcWingArea();
        this.wingSpan = this.calcMaxWingspan();
        this.craftLength = this.calcCraftLength();
        this.engineCount = this.engineCount();
        this.seatPos = this.cockpitPos();
        if (this.blockCount() == 0 && this.inBlockCount() == 0 && this.readCount != 0) {
            System.out.printf("[BiplanesMod] Deleting empty biplane entity\n", new Object[0]);
            this.func_70076_C();
        }
        this.updateTextureRun();
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.tPos.x = this.field_70165_t;
        this.tPos.y = this.field_70163_u;
        this.tPos.z = this.field_70161_v;
        this.getKeyPresses();
        this.animStep += 1.0f;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        this.prevThrottlePercent = this.throttlePercent;
        this.updateComponents();
        biplanesMod.BiplaneMover.moveBiplane(this);
        this.prevOnGround = this.field_70122_E;
        if (this.field_70153_n != null && Mouse.isButtonDown((int)1) && this.key_lctrl) {
            this.field_70153_n.field_70154_o = null;
            this.field_70153_n = null;
        }
        if (this.field_70153_n == null && this.prevRiddenByEntity != null) {
            this.prevRiddenByEntity.func_70107_b(this.field_70165_t + mathTools.findRelativePointX(new tCoord(0.0, 1.5, 1.5), new tAngle(this.prevYaw, this.prevPitch, this.prevYaw)), this.field_70163_u + mathTools.findRelativePointY(new tCoord(0.0, 1.5, 1.5), new tAngle(this.prevYaw, this.prevPitch, this.prevYaw)), this.field_70161_v + mathTools.findRelativePointZ(new tCoord(0.0, 1.5, 1.5), new tAngle(this.prevYaw, this.prevPitch, this.prevYaw)));
            this.prevRiddenByEntity = null;
        }
        if (!this.prevEngineStarted && this.engineStarted) {
            this.field_70170_p.func_72956_a((Entity)this, "biplanesMod".toLowerCase() + ":sounds.soundrotorstart", 1.0f, 1.0f);
        }
        this.prevThrottlePercent = this.throttlePercent;
        this.prevEngineStarted = this.engineStarted;
        WorldServer par1World = MinecraftServer.func_71276_C().field_71305_c[this.field_71093_bK];
        if (this.owner != this.field_70153_n && Mouse.isButtonDown((int)0) && !this.prevmouse_left && (Minecraft.func_71410_x().field_71462_r == null || Minecraft.field_142025_a)) {
            tCoord lookingAt = this.playerIsLookingAt(new tCoord(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v), new tVector(5.0, new tAngle(this.owner.field_70759_as, this.owner.field_70125_A, 0.0f)), false);
            this.prevmouse_left = true;
            if (lookingAt != null) {
                this.dropItem((World)par1World, lookingAt, !this.owner.field_71075_bZ.field_75098_d);
            }
        }
        if (this.field_70153_n != this.owner) {
            this.field_70153_n = null;
        }
        if (this.owner == null && this.ownerID != null) {
            List allPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            for (EntityPlayerMP player : allPlayers) {
                if (!player.func_110124_au().equals(this.ownerID)) continue;
                this.owner = player;
            }
        } else if (this.owner != null && this.ownerID == null) {
            this.ownerID = this.owner.func_110124_au().toString();
        }
    }

    private void updateComponents() {
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.inBlockDat[zx][zy][zz] == null) continue;
                    this.inBlockDat[zx][zy][zz].regularUpdate(this, zx, zy, zz);
                }
            }
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.seatPos == null) {
            this.field_70153_n.func_70078_a(null);
        } else if (!(this.inBlockDat[(int)(this.seatPos.x + (double)(this.maxWidth / 2))][(int)(this.seatPos.y - 1.5)][(int)(this.seatPos.z - 2.5 + (double)(this.maxDepth / 2))] instanceof tPlaneSeat)) {
            this.field_70153_n.func_70078_a(null);
        }
        if (this.field_70153_n != null && this.seatPos != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t + mathTools.findRelativePointX(this.seatPos, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70163_u + mathTools.findRelativePointY(this.seatPos, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70161_v + mathTools.findRelativePointZ(this.seatPos, new tAngle(this.yaw, this.pitch, this.roll)));
            this.field_70153_n.field_70125_A = Math.round(this.field_70153_n.field_70125_A + this.pitch - this.prevPitch);
        }
    }

    public boolean canPlayerInteract(EntityPlayer player) {
        tCoord lookingAt = this.playerIsLookingAt(new tCoord(player.field_70165_t, player.field_70163_u, player.field_70161_v), new tVector(5.0, new tAngle(player.field_70759_as, player.field_70125_A, 0.0f)), false);
        return lookingAt != null && player.field_71093_bK == this.field_71093_bK;
    }

    public tCoord ifPlayerInteract(EntityPlayer player) {
        tCoord lookingAt = this.playerIsLookingAt(new tCoord(player.field_70165_t, player.field_70163_u, player.field_70161_v), new tVector(5.0, new tAngle(player.field_70759_as, player.field_70125_A, 0.0f)), false);
        if (lookingAt != null) {
            double x = this.field_70165_t + mathTools.findRelativePointX(new tCoord(lookingAt.x - (double)(this.maxWidth / 2), lookingAt.y - 0.5, lookingAt.z + 2.5 - (double)(this.maxDepth / 2)), new tAngle(this.prevYaw, this.prevPitch, this.prevRoll));
            double y = this.field_70163_u + mathTools.findRelativePointY(new tCoord(lookingAt.x - (double)(this.maxWidth / 2), lookingAt.y - 0.5, lookingAt.z + 2.5 - (double)(this.maxDepth / 2)), new tAngle(this.prevYaw, this.prevPitch, this.prevRoll));
            double z = this.field_70161_v + mathTools.findRelativePointZ(new tCoord(lookingAt.x - (double)(this.maxWidth / 2), lookingAt.y - 0.5, lookingAt.z + 2.5 - (double)(this.maxDepth / 2)), new tAngle(this.prevYaw, this.prevPitch, this.prevRoll));
            System.out.printf("[BiplanesMod] found biplane block at  %-3.1f,  %-3.1f,  %-3.1f\n", x, y, z);
            return new tCoord(x, y, z);
        }
        return null;
    }

    public boolean playerInteract(EntityPlayer player) {
        tCoord lookingAt = this.playerIsLookingAt(new tCoord(player.field_70165_t, player.field_70163_u, player.field_70161_v), new tVector(5.0, new tAngle(player.field_70759_as, player.field_70125_A, 0.0f)), false);
        tCoord placingAt = this.playerIsLookingAt(new tCoord(player.field_70165_t, player.field_70163_u, player.field_70161_v), new tVector(5.0, new tAngle(player.field_70759_as, player.field_70125_A, 0.0f)), true);
        if (lookingAt != null) {
            if (placingAt != null) {
                if (placingAt.x != lookingAt.x && (placingAt.y != lookingAt.y || placingAt.z != lookingAt.z)) {
                    placingAt.x = lookingAt.x;
                }
                if (placingAt.z != lookingAt.z && placingAt.y != lookingAt.y) {
                    placingAt.z = lookingAt.z;
                }
            }
            if (this.blockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z] != null && Mouse.isButtonDown((int)1) && !this.prevmouse_right) {
                this.prevmouse_right = true;
                if (this.inBlockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z] instanceof tPlaneSeat && !this.key_lshift && !this.key_lctrl) {
                    player.field_70154_o = this;
                    this.field_70153_n = player;
                    this.prevRiddenByEntity = player;
                    if (this.ownerID == null) {
                        this.owner = player;
                        this.ownerID = player.getPersistentID().toString();
                    }
                    this.seatPos = new tCoord(lookingAt.x - (double)(this.maxWidth / 2), lookingAt.y + 1.5, lookingAt.z + 2.5 - (double)(this.maxDepth / 2));
                    return true;
                }
                if (this.field_70153_n == player && this.key_lctrl) {
                    this.field_70153_n.field_70154_o = null;
                    this.field_70153_n = null;
                    return true;
                }
                if (this.inBlockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z] instanceof tPlaneEngine && ((tPlaneEngine)this.inBlockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z]).rotor != null) {
                    if (!((tPlaneEngine)this.inBlockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z]).isStarted && !this.key_lshift) {
                        if (!this.field_70170_p.func_72896_J() && Math.round(this.field_70146_Z.nextFloat() * 2.0f) == 0 || Math.round(this.field_70146_Z.nextFloat() * 4.0f) == 0) {
                            ((tPlaneEngine)this.inBlockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z]).isStarted = true;
                            this.engineStarted = true;
                            return true;
                        }
                    } else if (((tPlaneEngine)this.inBlockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z]).isStarted) {
                        System.out.printf("[BiplanesMod] GAAAh!!!\n", new Object[0]);
                        return true;
                    }
                }
                if (player != this.field_70153_n && (Minecraft.func_71410_x().field_71462_r == null || Minecraft.field_142025_a) && player.func_70694_bm() != null) {
                    if (player.func_70694_bm().func_77973_b() instanceof BiplaneAugmentItem && ((BiplaneAugmentItem)player.func_70694_bm().func_77973_b()).usedOnBiplane(player.func_70694_bm(), this, player, lookingAt, placingAt)) {
                        return true;
                    }
                    if (player.func_70694_bm().func_77973_b() instanceof mechanicWrench && ((mechanicWrench)player.func_70694_bm().func_77973_b()).usedOnBiplane(player.func_70694_bm(), this, player, lookingAt, placingAt)) {
                        return true;
                    }
                    if (player.func_70694_bm().func_77973_b() != null || this.inBlockDat[(int)lookingAt.x][(int)lookingAt.y][(int)lookingAt.z] instanceof tPlaneAileron) {
                        // empty if block
                    }
                }
            }
        }
        return false;
    }

    public void func_70037_a(NBTTagCompound NBT) {
        ++this.readCount;
        this.ownerID = NBT.func_74779_i("owner");
        this.pitch = NBT.func_74760_g("pitch");
        this.yaw = NBT.func_74760_g("yaw");
        this.roll = NBT.func_74760_g("roll");
        this.rotorSpeed = NBT.func_74769_h("rotorSpeed");
        this.seatPos.x = NBT.func_74769_h("seatPosX");
        this.seatPos.y = NBT.func_74769_h("seatPosY");
        this.seatPos.z = NBT.func_74769_h("seatPosZ");
        for (int zx = 0; zx < this.maxWidth; ++zx) {
            for (int zy = 0; zy < this.maxHeight; ++zy) {
                for (int zz = 0; zz < this.maxDepth; ++zz) {
                    String blockHere = NBT.func_74779_i(zx + "/" + zy + "/" + zz + "/BLOCKDAT");
                    if (materialHandler.getPart(blockHere = blockHere.trim()) != null) {
                        if (!blockHere.contains("NULL")) {
                            System.out.printf(blockHere + "\n", new Object[0]);
                        }
                        this.blockDat[zx][zy][zz] = materialHandler.getPart(blockHere).newInstance();
                        this.blockDat[zx][zy][zz].readFromNBT(NBT, zx, zy, zz);
                        this.blockDat[zx][zy][zz].updateTexture();
                    }
                    String inBlockHere = NBT.func_74779_i(zx + "/" + zy + "/" + zz + "/INBLOCKDAT");
                    if (materialHandler.getPart(inBlockHere = inBlockHere.trim()) == null) continue;
                    if (!inBlockHere.contains("NULL")) {
                        System.out.printf(inBlockHere + "\n", new Object[0]);
                    }
                    this.inBlockDat[zx][zy][zz] = materialHandler.getInPart(inBlockHere).newInstance();
                    this.inBlockDat[zx][zy][zz].readFromNBT(NBT, zx, zy, zz);
                    this.inBlockDat[zx][zy][zz].updateTexture();
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound NBT) {
        if (this.ownerID != null) {
            NBT.func_74778_a("owner", this.ownerID);
        }
        NBT.func_74776_a("pitch", this.pitch);
        NBT.func_74776_a("yaw", this.yaw);
        NBT.func_74776_a("roll", this.roll);
        NBT.func_74780_a("rotorSpeed", this.rotorSpeed);
        if (this.seatPos != null) {
            NBT.func_74780_a("seatPosX", this.seatPos.x);
            NBT.func_74780_a("seatPosY", this.seatPos.y);
            NBT.func_74780_a("seatPosZ", this.seatPos.z);
        }
        for (int zx = 0; zx < this.maxWidth; ++zx) {
            for (int zy = 0; zy < this.maxHeight; ++zy) {
                for (int zz = 0; zz < this.maxDepth; ++zz) {
                    if (this.blockDat[zx][zy][zz] != null) {
                        this.blockDat[zx][zy][zz].writeToNBT(NBT, zx, zy, zz);
                    } else {
                        NBT.func_74778_a(zx + "/" + zy + "/" + zz + "/BLOCKDAT", "NULL");
                    }
                    if (this.inBlockDat[zx][zy][zz] != null) {
                        this.inBlockDat[zx][zy][zz].writeToNBT(NBT, zx, zy, zz);
                        continue;
                    }
                    NBT.func_74778_a(zx + "/" + zy + "/" + zz + "/INBLOCKDAT", "NULL");
                }
            }
        }
    }

    public boolean func_142008_O() {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public int calcMaxWingspan() {
        int test = 0;
        int markFirst = -1;
        int markLast = -1;
        int currentMax = 0;
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                test = 0;
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (!(this.blockDat[zx][zy][zz] instanceof tPlaneStructWing)) continue;
                    if (markFirst == -1) {
                        markFirst = zx - 1;
                    }
                    markLast = zx;
                }
                test = markLast - markFirst;
                if (test <= currentMax) continue;
                currentMax = test;
            }
        }
        test = 0;
        return currentMax;
    }

    public int calcWingArea() {
        int area = 0;
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (!(this.blockDat[zx][zy][zz] instanceof tPlaneStructWing)) continue;
                    ++area;
                }
            }
        }
        return area;
    }

    public int calcAileronArea(boolean fb) {
        int area = 0;
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = (fb ? 0 : 1) * this.maxDepth / 2; zz < this.maxDepth / 2 + (fb ? 0 : 1) * this.maxDepth / 2; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (!(this.blockDat[zx][zy][zz] instanceof tPlaneStructWing) || !(this.inBlockDat[zx][zy][zz] instanceof tPlaneAileron)) continue;
                    ++area;
                }
            }
        }
        return area;
    }

    public int calcRudderArea(boolean fb) {
        int area = 0;
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = (fb ? 0 : 1) * this.maxDepth / 2; zz < this.maxDepth / 2 + (fb ? 0 : 1) * this.maxDepth / 2; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (!(this.blockDat[zx][zy][zz] instanceof tPlaneStructStabilizer) || !(this.inBlockDat[zx][zy][zz] instanceof tPlaneAileron)) continue;
                    ++area;
                }
            }
        }
        return area;
    }

    public int calcCraftLength() {
        int markFirst = this.maxDepth;
        int markLast = -1;
        for (int zx = 0; zx < this.maxWidth; ++zx) {
            for (int zy = 0; zy < this.maxHeight; ++zy) {
                for (int zz = 0; zz < this.maxDepth; ++zz) {
                    if (this.blockDat[zx][zy][zz] == null) continue;
                    if (zz - 1 < markFirst) {
                        markFirst = zz - 1;
                    }
                    if (zz <= markLast) continue;
                    markLast = zz;
                }
            }
        }
        return markLast - markFirst;
    }

    public int engineCount() {
        int count = 0;
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.blockDat[zx][zy][zz] == null || !(this.inBlockDat[zx][zy][zz] instanceof tPlaneEngine)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public void engineShutoff() {
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.blockDat[zx][zy][zz] == null || !(this.inBlockDat[zx][zy][zz] instanceof tPlaneEngine)) continue;
                    ((tPlaneEngine)this.inBlockDat[zx][zy][zz]).isStarted = false;
                }
            }
        }
    }

    public tCoord cockpitPos() {
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.blockDat[zx][zy][zz] == null || !(this.inBlockDat[zx][zy][zz] instanceof tPlaneSeat)) continue;
                    return new tCoord(zx - this.maxWidth / 2, (double)zy + 1.5, (double)zz + 2.5 - (double)(this.maxDepth / 2));
                }
            }
        }
        return null;
    }

    public int blockCount() {
        int c = 0;
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.blockDat[zx][zy][zz] == null) continue;
                    ++c;
                }
            }
        }
        return c;
    }

    public int inBlockCount() {
        int c = 0;
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.inBlockDat[zx][zy][zz] == null) continue;
                    ++c;
                }
            }
        }
        return c;
    }

    public tForce calcMassAndCG() {
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.inBlockDat[zx][zy][zz] == null) continue;
                    return null;
                }
            }
        }
        return null;
    }

    public tCoord playerIsLookingAt(tCoord point, tVector vector, boolean addBlock) {
        double playerMax = vector.magnitude;
        double moveCount = 0.0;
        float thisYaw = vector.direction.yaw - this.yaw + 90.0f;
        float thisPitch = -vector.direction.pitch - this.pitch;
        double x = mathTools.findRelativePointX(new tCoord(point.x - this.tPos.x, point.y - this.tPos.y, point.z - this.tPos.z), new tAngle(-this.prevYaw, -this.prevPitch, -this.prevRoll)) + (double)(this.maxWidth / 2);
        double y = mathTools.findRelativePointY(new tCoord(point.x - this.tPos.x, point.y - this.tPos.y, point.z - this.tPos.z), new tAngle(-this.prevYaw, -this.prevPitch, -this.prevRoll)) + -0.5;
        double z = mathTools.findRelativePointZ(new tCoord(point.x - this.tPos.x, point.y - this.tPos.y, point.z - this.tPos.z), new tAngle(-this.prevYaw, -this.prevPitch, -this.prevRoll)) + (double)(-3 + this.maxDepth / 2);
        double startX = Math.round(x);
        double startY = Math.round(y);
        double startZ = Math.ceil(z);
        while (Math.round(x) < 0L || Math.round(y) < 0L || Math.ceil(z) < 0.0 || Math.round(x) > (long)(this.maxWidth - 1) || Math.round(y) > (long)(this.maxHeight - 1) || Math.ceil(z) > (double)(this.maxDepth - 1)) {
            x += 0.5 * mathTools.tCos(thisYaw) * mathTools.tCos(thisPitch);
            y += 0.5 * mathTools.tSin(thisPitch);
            z += 0.5 * mathTools.tSin(thisYaw) * mathTools.tCos(thisPitch);
            if (!((moveCount += 0.5) > playerMax)) continue;
            return null;
        }
        while (this.blockDat[(int)Math.round(x)][(int)Math.round(y)][(int)Math.ceil(z)] == null) {
            x += 0.5 * mathTools.tCos(thisYaw) * mathTools.tCos(thisPitch);
            y += 0.5 * mathTools.tSin(thisPitch);
            z += 0.5 * mathTools.tSin(thisYaw) * mathTools.tCos(thisPitch);
            if ((moveCount += 0.5) > playerMax) {
                return null;
            }
            if (Math.round(x) >= 0L && Math.round(y) >= 0L && !(Math.ceil(z) < 0.0) && Math.round(x) <= (long)(this.maxWidth - 1) && Math.round(y) <= (long)(this.maxHeight - 1) && !(Math.ceil(z) > (double)(this.maxDepth - 1))) continue;
            return null;
        }
        tCoord reCalc = new tCoord(x, y, z);
        x = Math.round(x);
        y = Math.round(y);
        z = Math.ceil(z);
        if (x == startX && y == startX && z == startX) {
            return null;
        }
        if (addBlock) {
            while ((double)Math.round(reCalc.x) == x && (double)Math.round(reCalc.y) == y && Math.ceil(reCalc.z) == z) {
                reCalc.x -= 0.5 * mathTools.tCos(thisYaw) * mathTools.tCos(thisPitch);
                reCalc.y -= 0.5 * mathTools.tSin(thisPitch);
                reCalc.z -= 0.5 * mathTools.tSin(thisYaw) * mathTools.tCos(thisPitch);
            }
            reCalc.x = Math.round(reCalc.x);
            reCalc.y = Math.round(reCalc.y);
            reCalc.z = Math.ceil(reCalc.z);
            if (reCalc.x < 0.0 || reCalc.y < 0.0 || reCalc.z < 0.0 || reCalc.x > (double)(this.maxWidth - 1) || reCalc.y > (double)(this.maxHeight - 1) || reCalc.z > (double)(this.maxDepth - 1)) {
                return null;
            }
            if (this.blockDat[(int)reCalc.x][(int)reCalc.y][(int)reCalc.z] != null) {
                return null;
            }
            if (x == startX && y == startY && z == startZ) {
                return null;
            }
            return reCalc;
        }
        if (moveCount > playerMax) {
            return null;
        }
        if (x < 0.0 || y < 0.0 || z < 0.0 || x > (double)(this.maxWidth - 1) || y > (double)(this.maxHeight - 1) || z > (double)(this.maxDepth - 1)) {
            return null;
        }
        return new tCoord(Math.round(x), Math.round(y), Math.ceil(z));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dropItem(World world, tCoord pos, boolean drop) {
        EntityItem item = null;
        tCoord posHere = new tCoord(pos.x - (double)(this.maxWidth / 2), pos.y + 1.5, pos.z + 2.5 - (double)(this.maxDepth / 2));
        if (this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].platingMaterial != "") {
            if (drop && materialHandler.getMaterial(this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].platingMaterial).getItem(this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].renderType) != null) {
                item = new EntityItem(world, this.field_70165_t + mathTools.findRelativePointX(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70163_u + mathTools.findRelativePointY(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70161_v + mathTools.findRelativePointZ(posHere, new tAngle(this.yaw, this.pitch, this.roll)), new ItemStack(materialHandler.getMaterial(this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].platingMaterial).getItem(this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].renderType), 1));
            }
            this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].platingMaterial = "";
            this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].updateTexture();
        } else if (this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z] != null) {
            if (this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z].dropItem != null) {
                if (this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z] instanceof tPlaneEngine && ((tPlaneEngine)this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z]).rotor != null) {
                    if (materialHandler.getMaterial(((tPlaneEngine)this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z]).rotor.material).getItem(((tPlaneEngine)this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z]).rotor.renderType) != null) {
                        EntityItem item2 = new EntityItem(world, this.field_70165_t + mathTools.findRelativePointX(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70163_u + mathTools.findRelativePointY(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70161_v + mathTools.findRelativePointZ(posHere, new tAngle(this.yaw, this.pitch, this.roll)), new ItemStack(materialHandler.getMaterial(((tPlaneEngine)this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z]).rotor.material).getItem(((tPlaneEngine)this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z]).rotor.renderType), 1));
                        if (item2 != null && drop) {
                            world.func_72838_d((Entity)item2);
                        }
                    } else {
                        System.out.printf("[BiplanesMod] No material found for \"" + ((tPlaneEngine)this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z]).rotor.renderType + "\" of material \"" + ((tPlaneEngine)this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z]).rotor.material + "\"\n", new Object[0]);
                    }
                }
                item = new EntityItem(world, this.field_70165_t + mathTools.findRelativePointX(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70163_u + mathTools.findRelativePointY(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70161_v + mathTools.findRelativePointZ(posHere, new tAngle(this.yaw, this.pitch, this.roll)), new ItemStack(this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z].dropItem, 1));
                this.inBlockDat[(int)pos.x][(int)pos.y][(int)pos.z] = null;
                item.field_145804_b = 10;
                item.field_98038_p = true;
            } else {
                if (this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] == null) return false;
                if (this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] instanceof tPlaneStructBlock || this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] instanceof tPlaneStructSlab) {
                    return false;
                }
                if (this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].dropItem == null) return false;
                item = new EntityItem(world, this.field_70165_t + mathTools.findRelativePointX(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70163_u + mathTools.findRelativePointY(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70161_v + mathTools.findRelativePointZ(posHere, new tAngle(this.yaw, this.pitch, this.roll)), new ItemStack(this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].dropItem, 1));
                this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] = null;
                item.field_145804_b = 10;
                item.field_98038_p = true;
            }
        } else {
            if (this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] == null) return false;
            if (this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] instanceof tPlaneStructBlock || this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] instanceof tPlaneStructSlab) {
                return false;
            }
            if (this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].dropItem == null) return false;
            item = new EntityItem(world, this.field_70165_t + mathTools.findRelativePointX(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70163_u + mathTools.findRelativePointY(posHere, new tAngle(this.yaw, this.pitch, this.roll)), this.field_70161_v + mathTools.findRelativePointZ(posHere, new tAngle(this.yaw, this.pitch, this.roll)), new ItemStack(this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z].dropItem, 1));
            this.blockDat[(int)pos.x][(int)pos.y][(int)pos.z] = null;
            item.field_145804_b = 10;
            item.field_98038_p = true;
        }
        if (item != null && drop) {
            world.func_72838_d(item);
        }
        this.updateTextureRun();
        this.calcPlaneValues();
        return true;
    }

    public void updateTextureRun() {
        for (int zy = 0; zy < this.maxHeight; ++zy) {
            for (int zz = 0; zz < this.maxDepth; ++zz) {
                for (int zx = 0; zx < this.maxWidth; ++zx) {
                    if (this.blockDat[zx][zy][zz] != null) {
                        this.blockDat[zx][zy][zz].checkContents(zx, zy, zz, this);
                    }
                    if (this.inBlockDat[zx][zy][zz] == null) continue;
                    this.inBlockDat[zx][zy][zz].updateTexture();
                }
            }
        }
    }

    public void getKeyPresses() {
        this.prevkey_up = this.key_up;
        this.prevkey_down = this.key_down;
        this.prevkey_left = this.key_left;
        this.prevkey_right = this.key_right;
        this.prevkey_lctrl = this.key_lctrl;
        this.prevkey_lshift = this.key_lshift;
        this.prevkey_space = this.key_space;
        this.prevmouse_left = this.mouse_left;
        this.prevmouse_right = this.mouse_right;
        this.key_up = Keyboard.isKeyDown((int)17);
        this.key_down = Keyboard.isKeyDown((int)31);
        this.key_left = Keyboard.isKeyDown((int)30);
        this.key_right = Keyboard.isKeyDown((int)32);
        this.key_lctrl = Keyboard.isKeyDown((int)29);
        this.key_lshift = Keyboard.isKeyDown((int)42);
        this.key_space = Keyboard.isKeyDown((int)57);
        this.mouse_left = Mouse.isButtonDown((int)0);
        this.mouse_right = Mouse.isButtonDown((int)1);
    }
}

