/*
 * Decompiled with CFR 0.152.
 */
package com.blueyu2.strata;

import com.blueyu2.strata.StrataConfig;
import com.blueyu2.strata.StrataTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class StrataBlock
extends Block {
    public String blockId;
    Block baseBlock;
    public int meta;
    public String oreTexture;
    public String stoneTexture;
    int maxDepth = 2;
    public Type type;
    public IIcon[] icons = new IIcon[this.maxDepth];

    public StrataBlock(String blockId, int meta, String stoneTexture) {
        this(blockId, meta, stoneTexture, stoneTexture);
        this.type = Type.STONE;
    }

    public StrataBlock(String blockId, int meta, String oreTexture, String stoneTexture) {
        super(Material.field_151576_e);
        this.baseBlock = Block.func_149684_b((String)blockId);
        this.blockId = blockId;
        this.meta = meta;
        this.oreTexture = oreTexture;
        this.stoneTexture = stoneTexture;
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.type = Type.ORE;
        this.maxDepth = StrataConfig.maxDepth;
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        this.baseBlock.func_149664_b(world, x, y, z, meta);
    }

    protected boolean func_149700_E() {
        return true;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return this.type == Type.STONE ? super.canHarvestBlock(player, meta) : this.baseBlock.canHarvestBlock(player, this.meta);
    }

    public int getHarvestLevel(int meta) {
        return this.type == Type.STONE ? (meta == 0 ? 2 : 3) : this.baseBlock.getHarvestLevel(this.meta);
    }

    public String getHarvestTool(int meta) {
        return this.baseBlock.getHarvestTool(this.meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        try {
            world.func_147449_b(x, y, z, this.baseBlock);
            this.baseBlock.func_149734_b(world, x, y, z, random);
        }
        catch (Exception e) {
            world.func_147465_d(x, y, z, (Block)this, meta, 0);
            throw new RuntimeException(e);
        }
        world.func_147465_d(x, y, z, (Block)this, meta, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.maxDepth; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta < this.maxDepth ? this.icons[meta] : Blocks.field_150346_d.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (register instanceof TextureMap) {
            TextureMap map = (TextureMap)register;
            for (int i = 0; i < this.maxDepth; ++i) {
                String name = null;
                switch (this.type) {
                    case STONE: {
                        name = StrataTexture.getDerivedStoneName(this.stoneTexture, i);
                        break;
                    }
                    case ORE: {
                        name = StrataTexture.getDerivedOreName(this.oreTexture, i, this.stoneTexture);
                    }
                }
                TextureAtlasSprite texture = map.getTextureExtry(name);
                if (texture == null) {
                    texture = new StrataTexture(this.oreTexture, this.stoneTexture, i, this.type);
                    map.setTextureEntry(name, texture);
                }
                this.icons[i] = map.getTextureExtry(name);
            }
        }
    }

    public int func_149692_a(int meta) {
        return this.baseBlock.func_149692_a(this.meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return this.baseBlock.getDrops(world, x, y, z, this.meta, fortune);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        world.func_72921_c(x, y, z, this.meta, 0);
        try {
            hardness = this.baseBlock.func_149712_f(world, x, y, z);
        }
        catch (Exception e) {
            world.func_72921_c(x, y, z, metadata, 0);
            throw new RuntimeException(e);
        }
        world.func_72921_c(x, y, z, metadata, 0);
        return hardness;
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        return this.baseBlock.getExpDrop(world, this.meta, fortune);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        if (this.type == Type.ORE) {
            return super.func_149737_a(player, world, x, y, z);
        }
        int metadata = world.func_72805_g(x, y, z);
        float hardness = this.func_149712_f(world, x, y, z);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!this.canHarvestBlock(player, metadata)) {
            return player.getBreakSpeed((Block)this, true, metadata, x, y, z) / hardness / 400.0f;
        }
        return player.getBreakSpeed((Block)this, false, metadata, x, y, z) / hardness / 30.0f;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[StrataBlock.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(world, player, x, y, z, meta) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = new ItemStack(Item.func_150898_a((Block)this.baseBlock), 1, this.meta);
            items.add(itemstack);
            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)this.baseBlock, (int)x, (int)y, (int)z, (int)this.meta, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                this.func_149642_a(world, x, y, z, is);
            }
        } else {
            this.harvesters.set(player);
            int i1 = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            this.func_149697_b(world, x, y, z, meta, i1);
            this.harvesters.set(null);
        }
    }

    public static enum Type {
        STONE,
        ORE;

    }
}

