/*
 * Decompiled with CFR 0.152.
 */
package com.blueyu2.strata;

import com.blueyu2.strata.BlockMeta;
import com.blueyu2.strata.StrataBlock;
import com.blueyu2.strata.StrataBlockItem;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;

public class StrataRegistry {
    public static Map<BlockMeta, Block> blocks = new HashMap<BlockMeta, Block>();
    public static ArrayList<BlockMeta> blockMetas = new ArrayList();

    public static BlockMeta getBlockMeta(Block block, int meta, boolean create) {
        BlockMeta tempBlockMeta = new BlockMeta(block, meta);
        for (BlockMeta blockMeta : blockMetas) {
            if (!blockMeta.equals(tempBlockMeta)) continue;
            return blockMeta;
        }
        if (create) {
            blockMetas.add(tempBlockMeta);
        }
        return tempBlockMeta;
    }

    public static void initVanillaBlocks() {
        StrataRegistry.registerStone("minecraft:stone", 0, "stone");
        StrataRegistry.registerStone("minecraft:monster_egg", 0, "stone");
        StrataRegistry.registerStone("minecraft:dirt", 0, "dirt");
        StrataRegistry.registerStone("minecraft:gravel", 0, "gravel");
        StrataRegistry.registerOre("minecraft:iron_ore", 0, "iron_ore", "stone");
        StrataRegistry.registerOre("minecraft:gold_ore", 0, "gold_ore", "stone");
        StrataRegistry.registerOre("minecraft:lapis_ore", 0, "lapis_ore", "stone");
        StrataRegistry.registerOre("minecraft:diamond_ore", 0, "diamond_ore", "stone");
        StrataRegistry.registerOre("minecraft:emerald_ore", 0, "emerald_ore", "stone");
        StrataRegistry.registerOre("minecraft:redstone_ore", 0, "redstone_ore", "stone");
        StrataRegistry.registerOre("minecraft:coal_ore", 0, "coal_ore", "stone");
    }

    public static void registerStone(String blockId, int meta, String stoneTexture) {
        StrataRegistry.registerBlock(blockId, meta, null, stoneTexture, StrataBlock.Type.STONE);
    }

    public static void registerOre(String blockId, int meta, String oreTexture, String stoneTexture) {
        StrataRegistry.registerBlock(blockId, meta, oreTexture, stoneTexture, StrataBlock.Type.ORE);
    }

    public static void registerBlock(String blockId, int meta, String oreTexture, String stoneTexture, StrataBlock.Type type) {
        if ("".equals(blockId) || "minecraft:air".equals(blockId)) {
            return;
        }
        int index = blockId.indexOf(58);
        if (index > 1) {
            String modName = blockId.substring(0, index);
            String blockName = blockId.substring(index + 1, blockId.length());
            Block baseBlock = Block.func_149684_b((String)blockId);
            if (baseBlock != null) {
                switch (type) {
                    case ORE: {
                        StrataBlock block = new StrataBlock(blockId, meta, oreTexture, stoneTexture);
                        blocks.put(StrataRegistry.getBlockMeta(baseBlock, meta, true), block);
                        GameRegistry.registerBlock((Block)block, StrataBlockItem.class, (String)("block|" + modName + "/" + blockName + "-" + meta));
                        break;
                    }
                    case STONE: {
                        StrataBlock block = new StrataBlock(blockId, meta, stoneTexture);
                        blocks.put(StrataRegistry.getBlockMeta(baseBlock, meta, true), block);
                        GameRegistry.registerBlock((Block)block, StrataBlockItem.class, (String)("block|" + modName + "/" + blockName + "-" + meta));
                    }
                }
            }
        } else {
            throw new RuntimeException("Block " + blockId + " is not formatted correctly. Must be in the form mod:block");
        }
    }
}

