/*
 * Decompiled with CFR 0.152.
 */
package com.blueyu2.strata;

import com.blueyu2.strata.Strata;
import com.blueyu2.strata.StrataBlock;
import com.blueyu2.strata.StrataRegistry;
import com.blueyu2.strata.StrataTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;

@SideOnly(value=Side.CLIENT)
public class CommandClientOutputTextures
extends CommandBase {
    public String func_71517_b() {
        return "strata_outputtextures";
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return true;
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "strata.command.help";
    }

    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        for (Block block : StrataRegistry.blocks.values()) {
            if (!(block instanceof StrataBlock)) continue;
            StrataBlock sBlock = (StrataBlock)block;
            for (int i = 0; i < sBlock.maxDepth; ++i) {
                if (!(sBlock.icons[i] instanceof StrataTexture)) continue;
                StrataTexture texture = (StrataTexture)sBlock.icons[i];
                BufferedImage image = texture.outputImage;
                if (image == null) continue;
                String file = null;
                switch (sBlock.type) {
                    case STONE: {
                        file = StrataTexture.getDerivedStoneName(texture.stoneName, texture.depth);
                        break;
                    }
                    case ORE: {
                        file = StrataTexture.getDerivedOreName(texture.oreName, texture.depth, texture.stoneName);
                    }
                }
                int index = file.indexOf(58);
                file = file.substring(index + 1);
                File dir = new File(Minecraft.func_71410_x().field_71412_D, "stratatextures");
                File moddir = new File(new File(new File(new File(dir, "assets"), "strata"), "textures"), "blocks");
                File f = new File(moddir, file + ".png");
                try {
                    if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                        return;
                    }
                    if (!f.exists() && !f.createNewFile()) continue;
                    ImageIO.write((RenderedImage)image, "png", f);
                    Strata.logger.info("Successful output of " + texture.func_94215_i());
                    continue;
                }
                catch (IOException e) {
                    Strata.logger.info("Unable to output " + texture.func_94215_i());
                    e.printStackTrace();
                }
            }
        }
    }
}

