/*
 * Decompiled with CFR 0.152.
 */
package com.blueyu2.strata;

import com.blueyu2.strata.Strata;
import com.blueyu2.strata.StrataBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class StrataTexture
extends TextureAtlasSprite {
    public StrataBlock.Type type;
    public int depth;
    String oreName;
    String stoneName;
    BufferedImage override = null;
    boolean overrideStone = false;
    public double depthMult = 0.7;
    public BufferedImage outputImage = null;

    public StrataTexture(String oreName, String baseName, int depth, StrataBlock.Type type) {
        super(type == StrataBlock.Type.STONE ? StrataTexture.getDerivedStoneName(oreName, depth) : StrataTexture.getDerivedOreName(oreName, depth, baseName));
        this.oreName = oreName;
        this.stoneName = baseName;
        this.type = type;
        this.depth = depth;
    }

    public static String getDerivedStoneName(String oreName, int depth) {
        String oreModName = "minecraft";
        int oreIndex = oreName.indexOf(58);
        if (oreIndex >= 0) {
            if (oreIndex > 1) {
                oreModName = oreName.substring(0, oreIndex);
            }
            oreName = oreName.substring(oreIndex + 1, oreName.length());
        }
        oreName = oreName.toLowerCase();
        return "strata:" + oreModName + "/" + oreName + "." + depth;
    }

    public static String getDerivedOreName(String oreName, int depth, String baseName) {
        String baseModName = "minecraft";
        int baseIndex = baseName.indexOf(58);
        if (baseIndex >= 0) {
            if (baseIndex > 1) {
                baseModName = baseName.substring(0, baseIndex);
            }
            baseName = baseName.substring(baseIndex + 1, baseName.length());
        }
        baseName = baseName.toLowerCase();
        return StrataTexture.getDerivedStoneName(oreName, depth) + "+" + baseModName + "|" + baseName;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        ResourceLocation location1 = new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", "textures/blocks", location.func_110623_a(), ".png"));
        try {
            manager.func_110536_a(location1);
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        boolean result = true;
        String file = null;
        switch (this.type) {
            case STONE: {
                file = StrataTexture.getDerivedStoneName(this.stoneName, this.depth);
                break;
            }
            case ORE: {
                file = StrataTexture.getDerivedOreName(this.oreName, this.depth, this.stoneName);
            }
        }
        int index = file.indexOf(58);
        file = file.substring(index + 1);
        switch (this.type) {
            case STONE: {
                result = this.loadStone(manager, location);
                Strata.logger.info("Strata: Succesfully generated stone texture for '" + this.oreName + "'. Place " + file + ".png in the assets folder to override.");
                break;
            }
            case ORE: {
                result = this.loadOre(manager, location);
                Strata.logger.info("Strata: Succesfully generated ore texture for '" + this.oreName + "' with background '" + this.stoneName + "'. Place " + file + ".png in the assets folder to override.");
            }
        }
        return result;
    }

    public boolean loadStone(IResourceManager manager, ResourceLocation location) {
        AnimationMetadataSection animation;
        int mip = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        BufferedImage[] stoneImage = new BufferedImage[1 + mip];
        try {
            IResource iResource = manager.func_110536_a(StrataTexture.getBlockResource(this.stoneName));
            stoneImage[0] = ImageIO.read(iResource.func_110527_b());
            animation = (AnimationMetadataSection)iResource.func_110526_a("animation");
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        stoneImage[0] = this.generateStone(stoneImage[0]);
        this.outputImage = stoneImage[0];
        this.func_147964_a(stoneImage, animation, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J > 1.0f);
        return false;
    }

    public BufferedImage generateStone(BufferedImage oldImage) {
        BufferedImage output = new BufferedImage(oldImage.getWidth(), oldImage.getHeight(), 2);
        double darkness = this.depthMult - (double)this.depth / 5.0;
        for (int x = 0; x < oldImage.getWidth(); ++x) {
            for (int y = 0; y < oldImage.getHeight(); ++y) {
                int color = oldImage.getRGB(x, y);
                int newColor = StrataTexture.makeCol(Math.max((int)((double)StrataTexture.getRed(color) * darkness), 0), Math.max((int)((double)StrataTexture.getGreen(color) * darkness), 0), Math.max((int)((double)StrataTexture.getBlue(color) * darkness), 0), StrataTexture.getAlpha(color));
                output.setRGB(x, y, newColor);
            }
        }
        return output;
    }

    public boolean loadOre(IResourceManager manager, ResourceLocation location) {
        AnimationMetadataSection oreAnimation;
        BufferedImage stoneImage;
        int mip = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        BufferedImage[] oreImage = new BufferedImage[1 + mip];
        int oreAnimationMultiplier = 1;
        try {
            IResource iOverrideResource = manager.func_110536_a(StrataTexture.getBlockResource(StrataTexture.getDerivedStoneName(this.stoneName, this.depth)));
            this.override = ImageIO.read(iOverrideResource.func_110527_b());
            this.overrideStone = true;
        }
        catch (IOException iOverrideResource) {
            // empty catch block
        }
        try {
            IResource iOreResource = manager.func_110536_a(StrataTexture.getBlockResource(this.oreName));
            IResource iStoneResource = manager.func_110536_a(StrataTexture.getBlockResource(this.stoneName));
            oreImage[0] = ImageIO.read(iOreResource.func_110527_b());
            stoneImage = ImageIO.read(iStoneResource.func_110527_b());
            stoneImage = stoneImage.getSubimage(0, 0, stoneImage.getWidth(), stoneImage.getWidth());
            oreAnimation = (AnimationMetadataSection)iOreResource.func_110526_a("animation");
            if (oreAnimation != null) {
                oreAnimationMultiplier = oreAnimation.func_110473_c();
            }
            if (stoneImage.getWidth() < oreImage[0].getWidth()) {
                int oreWidth = oreImage[0].getWidth();
                int oreHeight = oreImage[0].getHeight();
                if (oreAnimation != null) {
                    oreHeight = oreWidth;
                }
                stoneImage = StrataTexture.resize(stoneImage, oreWidth, oreHeight);
            } else if (stoneImage.getWidth() > oreImage[0].getWidth()) {
                int stoneWidth = stoneImage.getWidth();
                int stoneHeight = stoneImage.getHeight();
                oreImage[0] = StrataTexture.resize(oreImage[0], stoneWidth, stoneHeight * oreAnimationMultiplier);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        oreImage[0] = this.generateOre(oreImage[0], oreAnimationMultiplier, stoneImage);
        this.outputImage = oreImage[0];
        this.func_147964_a(oreImage, oreAnimation, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J > 1.0f);
        return false;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public BufferedImage generateAnimatedTexture(BufferedImage image, int multiplier) {
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight() * multiplier, 2);
        Graphics2D g2d = temp.createGraphics();
        for (int i = 0; i < multiplier; ++i) {
            g2d.drawImage((Image)image, 0, image.getHeight() * i, null);
        }
        g2d.dispose();
        return temp;
    }

    public BufferedImage generateOre(BufferedImage oreImage, int oreAnimation, BufferedImage stoneImage) {
        BufferedImage coalFix = this.generateStone(oreImage);
        BufferedImage newImage = !this.overrideStone ? this.generateStone(this.generateAnimatedTexture(stoneImage, oreAnimation)) : this.generateAnimatedTexture(this.override, oreAnimation);
        for (int x = 0; x < oreImage.getWidth(); ++x) {
            for (int y = 0; y < oreImage.getHeight(); ++y) {
                int b;
                int g;
                int r;
                int sx = x % stoneImage.getWidth();
                int sy = y % stoneImage.getHeight();
                if (StrataTexture.getAlpha(oreImage.getRGB(x, y)) == 0 || oreImage.getRGB(x, y) == stoneImage.getRGB(sx, sy)) continue;
                if (this.override == null && (this.oreName.equals("coal_ore") || this.oreName.equals("emerald_ore"))) {
                    r = Math.abs(StrataTexture.getRed(oreImage.getRGB(x, y)) - StrataTexture.getRed(newImage.getRGB(x, y)));
                    g = Math.abs(StrataTexture.getGreen(oreImage.getRGB(x, y)) - StrataTexture.getGreen(newImage.getRGB(x, y)));
                    b = Math.abs(StrataTexture.getBlue(oreImage.getRGB(x, y)) - StrataTexture.getBlue(newImage.getRGB(x, y)));
                    if (r < 49 && g < 49 && b < 49) {
                        newImage.setRGB(x, y, coalFix.getRGB(x, y));
                        continue;
                    }
                }
                r = Math.abs(StrataTexture.getRed(oreImage.getRGB(x, y)) - StrataTexture.getRed(stoneImage.getRGB(sx, sy)));
                g = Math.abs(StrataTexture.getGreen(oreImage.getRGB(x, y)) - StrataTexture.getGreen(stoneImage.getRGB(sx, sy)));
                b = Math.abs(StrataTexture.getBlue(oreImage.getRGB(x, y)) - StrataTexture.getBlue(stoneImage.getRGB(sx, sy)));
                if (r < 28 && g < 28 && b < 28) continue;
                newImage.setRGB(x, y, oreImage.getRGB(x, y));
            }
        }
        return newImage;
    }

    public static ResourceLocation getBlockResource(String blockName) {
        String modName = "minecraft";
        int index = blockName.indexOf(58);
        if (index >= 0) {
            if (index > 1) {
                modName = blockName.substring(0, index);
            }
            blockName = blockName.substring(index + 1, blockName.length());
        }
        modName = modName.toLowerCase();
        blockName = "textures/blocks/" + blockName + ".png";
        return new ResourceLocation(modName, blockName);
    }

    public static int getAlpha(int col) {
        return (col & 0xFF000000) >> 24;
    }

    public static int getRed(int col) {
        return (col & 0xFF0000) >> 16;
    }

    public static int getGreen(int col) {
        return (col & 0xFF00) >> 8;
    }

    public static int getBlue(int col) {
        return col & 0xFF;
    }

    public static int makeCol(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

