/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.betterfps;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Properties;

public class BetterFpsHelper {
    public static final String MC_VERSION = "1.7.10";
    public static final String VERSION = "1.0.1";
    public static final LinkedHashMap<String, String> helpers = new LinkedHashMap();
    public static final LinkedHashMap<String, String> displayHelpers = new LinkedHashMap();
    public static File LOC;
    public static File MCDIR;
    public static Properties CONFIG;
    private static File CONFIG_FILE;
    public static String ALGORITHM_NAME;
    public static String ALGORITHM_CLASS;

    public static void init() {
        try {
            for (Field f : qh.class.getDeclaredFields()) {
                String name = f.getName();
                if (!name.equals("SIN_TABLE") && !name.equals("a")) continue;
                f.setAccessible(true);
                f.set(null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadConfig() {
        CONFIG_FILE = MCDIR == null ? new File("betterfps.txt") : new File(MCDIR, "betterfps.txt");
        CONFIG = new Properties();
        try {
            if (CONFIG_FILE.exists()) {
                CONFIG.load(new FileInputStream(CONFIG_FILE));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ALGORITHM_NAME = CONFIG.getProperty("algorithm", "rivens-half");
        ALGORITHM_CLASS = helpers.get(ALGORITHM_NAME);
        CONFIG.setProperty("algorithm", ALGORITHM_NAME);
        BetterFpsHelper.saveConfig();
    }

    public static void saveConfig() {
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.createNewFile();
            }
            CONFIG.store(new FileOutputStream(CONFIG_FILE), "BetterFps Config");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        helpers.put("vanilla", "VanillaMath");
        helpers.put("rivens", "RivensMath");
        helpers.put("taylors", "TaylorMath");
        helpers.put("libgdx", "LibGDXMath");
        helpers.put("rivens-full", "RivensFullMath");
        helpers.put("rivens-half", "RivensHalfMath");
        helpers.put("java", "JavaMath");
        helpers.put("random", "RandomMath");
        displayHelpers.put("vanilla", "Vanilla Algorithm");
        displayHelpers.put("rivens", "Riven's Algorithm");
        displayHelpers.put("taylors", "Taylor's Algorithm");
        displayHelpers.put("libgdx", "LibGDX's Algorithm");
        displayHelpers.put("rivens-full", "Riven's \"Full\" Algorithm");
        displayHelpers.put("rivens-half", "Riven's \"Half\" Algorithm");
        displayHelpers.put("java", "Java Math");
        displayHelpers.put("random", "Random Math");
        MCDIR = null;
        CONFIG = null;
        CONFIG_FILE = null;
    }
}

