/*
 * Decompiled with CFR 0.152.
 */
package sekwah.mods.narutomod.entitys;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Tuple;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import sekwah.mods.narutomod.blocks.NarutoBlocks;
import sekwah.mods.narutomod.entitys.EntityBandit;
import sekwah.mods.narutomod.entitys.EntityRogueNinja;
import sekwah.mods.narutomod.entitys.ai.EntityAIFollowAnbu;
import sekwah.mods.narutomod.entitys.ai.EntityAILookAtNinjaTradePlayer;
import sekwah.mods.narutomod.entitys.ai.EntityAINinjaPlay;
import sekwah.mods.narutomod.entitys.ai.EntityAINinjaTradePlayer;
import sekwah.mods.narutomod.entitys.ai.EntityAINinjaVillagerMate;
import sekwah.mods.narutomod.items.NarutoItems;

public class EntityNinjaVillager
extends EntityAgeable
implements INpc,
IMerchant {
    public static final Map villagerStockList = new HashMap();
    private static final Map blacksmithSellingList = new HashMap();
    Village villageObj;
    private int randomTickDivider;
    private boolean isMating;
    private boolean isPlaying;
    private EntityPlayer buyingPlayer;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private String lastBuyingPlayer;
    private boolean field_82190_bM;
    private float field_82191_bN;

    public EntityNinjaVillager(World par1World) {
        this(par1World, 0);
    }

    public EntityNinjaVillager(World par1World, int par2) {
        super(par1World);
        this.setProfession(par1World.field_73012_v.nextInt(3));
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, (double)0.6f, (double)0.6f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityRogueNinja.class, 8.0f, (double)0.6f, (double)0.6f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityBandit.class, 8.0f, (double)0.6f, (double)0.6f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAINinjaTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtNinjaTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, (double)0.6f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAINinjaVillagerMate(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowAnbu(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAINinjaPlay(this, 0.32f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityVillager.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)0.6f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    private static void addMerchantItem(MerchantRecipeList par0MerchantRecipeList, Item item, Random par2Random, float par3) {
        if (par2Random.nextFloat() < par3) {
            par0MerchantRecipeList.add((Object)new MerchantRecipe(EntityNinjaVillager.getRandomSizedStack(item, par2Random), NarutoItems.SilverRyo));
        }
    }

    private static ItemStack getRandomSizedStack(Item item, Random par1Random) {
        return new ItemStack(item, EntityNinjaVillager.getRandomCountForItem(item, par1Random), 0);
    }

    private static int getRandomCountForItem(Item item, Random par1Random) {
        Tuple var2 = (Tuple)villagerStockList.get(item);
        return var2 == null ? 1 : ((Integer)var2.func_76341_a() >= (Integer)var2.func_76340_b() ? (Integer)var2.func_76341_a() : (Integer)var2.func_76341_a() + par1Random.nextInt((Integer)var2.func_76340_b() - (Integer)var2.func_76341_a()));
    }

    private static void addBlacksmithItem(MerchantRecipeList par0MerchantRecipeList, Item item, Random par2Random, float par3) {
        if (par2Random.nextFloat() < par3) {
            ItemStack itemstack1;
            ItemStack itemstack;
            int j = EntityNinjaVillager.getRandomCountForBlacksmithItem(item, par2Random);
            if (j < 0) {
                itemstack = new ItemStack(NarutoItems.SilverRyo, 1, 0);
                itemstack1 = new ItemStack(item, -j, 0);
            } else {
                itemstack = new ItemStack(NarutoItems.SilverRyo, j, 0);
                itemstack1 = new ItemStack(item, 1, 0);
            }
            par0MerchantRecipeList.add((Object)new MerchantRecipe(itemstack, itemstack1));
        }
    }

    private static int getRandomCountForBlacksmithItem(Item item, Random par1Random) {
        Tuple var2 = (Tuple)blacksmithSellingList.get(item);
        return var2 == null ? 1 : ((Integer)var2.func_76341_a() >= (Integer)var2.func_76340_b() ? (Integer)var2.func_76341_a() : (Integer)var2.func_76341_a() + par1Random.nextInt((Integer)var2.func_76340_b() - (Integer)var2.func_76341_a()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70629_bd() {
        if (--this.randomTickDivider <= 0) {
            this.field_70170_p.field_72982_D.func_75551_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.villageObj = this.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 32);
            if (this.villageObj == null) {
                this.func_110177_bN();
            } else {
                ChunkCoordinates var1 = this.villageObj.func_75577_a();
                this.func_110171_b(var1.field_71574_a, var1.field_71572_b, var1.field_71573_c, (int)((float)this.villageObj.func_75568_b() * 0.6f));
                if (this.field_82190_bM) {
                    this.field_82190_bM = false;
                    this.villageObj.func_82683_b(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    if (this.buyingList.size() > 1) {
                        for (MerchantRecipe merchantrecipe : this.buyingList) {
                            if (!merchantrecipe.func_82784_g()) continue;
                            merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                        }
                    }
                    this.addDefaultEquipmentAndRecipies(1);
                    this.needsInitilization = false;
                    if (this.villageObj != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.villageObj.func_82688_a(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 0));
            }
        }
        super.func_70629_bd();
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        boolean flag;
        ItemStack itemstack = par1EntityPlayer.field_71071_by.func_70448_g();
        boolean bl = flag = itemstack != null && itemstack.func_77973_b() == Items.field_151063_bx;
        if (!(flag || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || par1EntityPlayer.func_70093_af())) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(par1EntityPlayer);
                if (this.func_94057_bL() == "") {
                    par1EntityPlayer.func_71030_a((IMerchant)this, "Ninja Villager");
                } else {
                    par1EntityPlayer.func_71030_a((IMerchant)this, this.func_94057_bL());
                }
            }
            return true;
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Profession", this.getProfession());
        par1NBTTagCompound.func_74768_a("Riches", this.wealth);
        if (this.buyingList != null) {
            par1NBTTagCompound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setProfession(par1NBTTagCompound.func_74762_e("Profession"));
        this.wealth = par1NBTTagCompound.func_74762_e("Riches");
        if (par1NBTTagCompound.func_74764_b("Offers")) {
            NBTTagCompound var2 = par1NBTTagCompound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(var2);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        return "mob.villager.default";
    }

    protected String func_70621_aR() {
        return "narutomod:ninjavillager.hurt";
    }

    protected String func_70673_aS() {
        return "narutomod:ninjavillager.death";
    }

    public int getProfession() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setProfession(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)par1);
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean par1) {
        this.isMating = par1;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean par1) {
        this.isPlaying = par1;
    }

    public void func_70604_c(EntityLivingBase par1EntityLivingBase) {
        super.func_70604_c(par1EntityLivingBase);
        if (this.villageObj != null && par1EntityLivingBase != null) {
            this.villageObj.func_75575_a(par1EntityLivingBase);
            if (par1EntityLivingBase instanceof EntityPlayer) {
                int var2 = -1;
                if (this.func_70631_g_()) {
                    var2 = -3;
                }
                this.villageObj.func_82688_a(((EntityPlayer)par1EntityLivingBase).func_70005_c_(), var2);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        if (this.villageObj != null) {
            EntityPlayer var3;
            Entity var2 = par1DamageSource.func_76346_g();
            if (var2 != null) {
                if (var2 instanceof EntityPlayer) {
                    this.villageObj.func_82688_a(((EntityPlayer)var2).func_70005_c_(), -2);
                } else if (var2 instanceof IMob) {
                    this.villageObj.func_82692_h();
                }
            } else if (var2 == null && (var3 = this.field_70170_p.func_72890_a((Entity)this, 16.0)) != null) {
                this.villageObj.func_82692_h();
            }
        }
        super.func_70645_a(par1DamageSource);
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70932_a_(EntityPlayer par1EntityPlayer) {
        this.buyingPlayer = par1EntityPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void func_70933_a(MerchantRecipe par1MerchantRecipe) {
        par1MerchantRecipe.func_77399_f();
        if (par1MerchantRecipe.func_77393_a((MerchantRecipe)this.buyingList.get(this.buyingList.size() - 1))) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_70005_c_() : null;
        }
        if (par1MerchantRecipe.func_77394_a().func_77973_b() == NarutoItems.SilverRyo) {
            this.wealth += par1MerchantRecipe.func_77394_a().field_77994_a;
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.addDefaultEquipmentAndRecipies(1);
        }
        return this.buyingList;
    }

    private float adjustProbability(float par1) {
        float var2 = par1 + this.field_82191_bN;
        return var2 > 0.9f ? 0.9f - (var2 - 0.9f) : var2;
    }

    private void addDefaultEquipmentAndRecipies(int par1) {
        this.field_82191_bN = this.buyingList != null ? MathHelper.func_76129_c((float)this.buyingList.size()) * 0.2f : 0.0f;
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        switch (this.getProfession()) {
            case 0: {
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, NarutoItems.Noodles, this.field_70146_Z, this.adjustProbability(0.9f));
                EntityNinjaVillager.addMerchantItem(merchantrecipelist, Items.field_151121_aF, this.field_70146_Z, this.adjustProbability(0.8f));
                EntityNinjaVillager.addMerchantItem(merchantrecipelist, Items.field_151122_aG, this.field_70146_Z, this.adjustProbability(0.8f));
                EntityNinjaVillager.addMerchantItem(merchantrecipelist, Item.func_150898_a((Block)NarutoBlocks.Sakura_Sapling), this.field_70146_Z, this.adjustProbability(0.3f));
                break;
            }
            case 1: {
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, NarutoItems.Katana, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, NarutoItems.Shuriken, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, NarutoItems.bokken, this.field_70146_Z, this.adjustProbability(0.5f));
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, NarutoItems.Kunai, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, NarutoItems.ExplosiveKunai, this.field_70146_Z, this.adjustProbability(0.01f));
                break;
            }
            case 2: {
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, Item.func_150898_a((Block)NarutoBlocks.Sakura_Sapling), this.field_70146_Z, this.adjustProbability(0.3f));
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, Items.field_151062_by, this.field_70146_Z, this.adjustProbability(0.2f));
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, Items.field_151137_ax, this.field_70146_Z, this.adjustProbability(0.4f));
                EntityNinjaVillager.addBlacksmithItem(merchantrecipelist, Item.func_150898_a((Block)Blocks.field_150426_aN), this.field_70146_Z, this.adjustProbability(0.3f));
            }
        }
        Collections.shuffle(merchantrecipelist);
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int var9 = 0; var9 < par1 && var9 < merchantrecipelist.size(); ++var9) {
            this.buyingList.func_77205_a((MerchantRecipe)merchantrecipelist.get(var9));
        }
    }

    public void func_70930_a(MerchantRecipeList par1MerchantRecipeList) {
    }

    public void func_70103_a(byte par1) {
        if (par1 == 12) {
            this.generateRandomParticles("heart");
        } else if (par1 == 13) {
            this.generateRandomParticles("angryVillager");
        } else if (par1 == 14) {
            this.generateRandomParticles("happyVillager");
        } else {
            super.func_70103_a(par1);
        }
    }

    private void generateRandomParticles(String par1Str) {
        for (int var2 = 0; var2 < 5; ++var2) {
            double var3 = this.field_70146_Z.nextGaussian() * 0.02;
            double var5 = this.field_70146_Z.nextGaussian() * 0.02;
            double var7 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(par1Str, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, var3, var5, var7);
        }
    }

    public void initCreature() {
        this.setProfession(this.field_70170_p.field_73012_v.nextInt(3));
    }

    public void func_82187_q() {
        this.field_82190_bM = true;
    }

    public EntityNinjaVillager func_90012_b(EntityAgeable par1EntityAgeable) {
        EntityNinjaVillager var2 = new EntityNinjaVillager(this.field_70170_p);
        var2.initCreature();
        return var2;
    }

    public boolean func_110164_bC() {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable par1EntityAgeable) {
        return this.func_90012_b(par1EntityAgeable);
    }

    public void func_110297_a_(ItemStack par1ItemStack) {
    }

    static {
        blacksmithSellingList.put(Items.field_151097_aZ, new Tuple((Object)3, (Object)4));
        blacksmithSellingList.put(NarutoItems.Katana, new Tuple((Object)7, (Object)11));
        blacksmithSellingList.put(NarutoItems.Shuriken, new Tuple((Object)4, (Object)7));
        blacksmithSellingList.put(NarutoItems.Kunai, new Tuple((Object)4, (Object)7));
        blacksmithSellingList.put(NarutoItems.ExplosiveKunai, new Tuple((Object)14, (Object)16));
        villagerStockList.put(NarutoBlocks.Sakura_Sapling, new Tuple((Object)4, (Object)13));
        villagerStockList.put(NarutoItems.Noodles, new Tuple((Object)16, (Object)24));
        villagerStockList.put(Items.field_151121_aF, new Tuple((Object)16, (Object)24));
        villagerStockList.put(Items.field_151062_by, new Tuple((Object)13, (Object)16));
        villagerStockList.put(Items.field_151137_ax, new Tuple((Object)5, (Object)15));
        villagerStockList.put(Blocks.field_150426_aN, new Tuple((Object)3, (Object)4));
        villagerStockList.put(Items.field_151121_aF, new Tuple((Object)3, (Object)4));
    }
}

