/*
 * Decompiled with CFR 0.152.
 */
package sekwah.mods.narutomod.settings;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import sekwah.mods.narutomod.client.gui.EnumNarutoOptions;

public class NarutoSettings {
    public static Configuration config = null;
    public static boolean experimentalFirstPerson = false;
    public static int experimentalFirstPersonMode = 0;
    public static int settingsPage = 1;
    public static int chakraBarOffsetX = 2;
    public static int chakraBarOffsetY = 2;
    public static int chakraGUICorner = 1;
    public static int jutsuDelay = 10;

    public static void changeSetting() {
    }

    public static void changeSettingInt(EnumNarutoOptions setting, int value) {
        if (setting == EnumNarutoOptions.CHAKRA_BAR_CORNER) {
            chakraGUICorner = value;
            config.get("general", "chakraGUICorner", 1).set(value);
        }
        if (setting == EnumNarutoOptions.FIRSTPERSON) {
            experimentalFirstPersonMode = value;
            if (value == 0) {
                experimentalFirstPerson = true;
            } else if (value == 1) {
                experimentalFirstPerson = false;
            } else if (value == 2) {
                experimentalFirstPerson = false;
            }
            config.get("general", "experimentalFirstPersonMode", 0).set(value);
        }
        NarutoSettings.saveConfig();
    }

    public static void changeSettingFromSlider(EnumNarutoOptions setting, float sliderValue) {
        if (setting == EnumNarutoOptions.CHAKRA_BAR_OFFSETX) {
            chakraBarOffsetX = (int)(sliderValue * 300.0f);
            config.get("general", "chakraBarOffsetX", 2).set(chakraBarOffsetX);
        } else if (setting == EnumNarutoOptions.CHAKRA_BAR_OFFSETY) {
            chakraBarOffsetY = (int)(sliderValue * 300.0f);
            config.get("general", "chakraBarOffsetY", 2).set(chakraBarOffsetX);
        } else if (setting == EnumNarutoOptions.JUTSU_DELAY) {
            jutsuDelay = (int)(sliderValue * 20.0f) + 5;
            config.get("general", "jutsuDelay", 10).set(jutsuDelay);
        }
        NarutoSettings.saveConfig();
    }

    public static String getSettingValueString(EnumNarutoOptions setting) {
        if (setting == EnumNarutoOptions.CHAKRA_BAR_OFFSETX) {
            return Integer.toString(chakraBarOffsetX);
        }
        if (setting == EnumNarutoOptions.CHAKRA_BAR_OFFSETY) {
            return Integer.toString(chakraBarOffsetY);
        }
        if (setting == EnumNarutoOptions.JUTSU_DELAY) {
            return Integer.toString(jutsuDelay);
        }
        return null;
    }

    public static float returnSliderValue(EnumNarutoOptions setting) {
        if (setting == EnumNarutoOptions.CHAKRA_BAR_OFFSETX) {
            return (float)chakraBarOffsetX / 300.0f;
        }
        if (setting == EnumNarutoOptions.CHAKRA_BAR_OFFSETY) {
            return (float)chakraBarOffsetY / 300.0f;
        }
        if (setting == EnumNarutoOptions.JUTSU_DELAY) {
            return (float)(jutsuDelay - 5) / 20.0f;
        }
        return 1.0f;
    }

    public static void saveConfig() {
        config.save();
    }

    public static void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Property configExperimentalFirstPersonMode = config.get("general", "experimentalFirstPersonMode", 0);
        experimentalFirstPersonMode = configExperimentalFirstPersonMode.getInt(0);
        configExperimentalFirstPersonMode.comment = "This sets the first person mode. 0 = Enabled, 1 = Disabled, 2 = Jutsu Toggle(on when casting justsus)";
        if (experimentalFirstPersonMode == 0) {
            experimentalFirstPerson = true;
        } else if (experimentalFirstPersonMode == 1) {
            experimentalFirstPerson = false;
        } else if (experimentalFirstPersonMode == 1) {
            experimentalFirstPerson = false;
        }
        chakraBarOffsetX = config.get("general", "chakraBarOffsetX", 2).getInt(2);
        chakraBarOffsetY = config.get("general", "chakraBarOffsetY", 2).getInt(2);
        chakraGUICorner = config.get("general", "chakraGUICorner", 1).getInt(2);
        Property configJutsuDelay = config.get("general", "jutsuDelay", 10);
        jutsuDelay = configJutsuDelay.getInt(10);
        configJutsuDelay.comment = "Sets the time in ticks for the jutsu delay, minimum is 5(lightining refrexes(ninja)) and max is 25(slowpoke) default 10";
        if (jutsuDelay > 25) {
            jutsuDelay = 25;
        } else if (jutsuDelay < 0) {
            jutsuDelay = 0;
        }
        config.save();
    }
}

