/*
 * Decompiled with CFR 0.152.
 */
package com.nextgencrafters.narutomoddownloader;

import com.nextgencrafters.narutomodinstaller.Loader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class Downloader
implements Runnable {
    private String url;
    private String outFile;
    private JLabel label;
    private JProgressBar ProgressBar;
    private boolean overwrite;

    public Downloader(String var1, String var2, JLabel var3, JProgressBar var4, boolean var5) {
        this.url = var1;
        this.outFile = var2;
        this.label = var3;
        this.ProgressBar = var4;
        this.overwrite = var5;
    }

    @Override
    public void run() {
        try {
            File file = new File(this.outFile);
            if (!file.exists() || this.overwrite) {
                URL url1 = new URL(this.url);
                HttpURLConnection connection = (HttpURLConnection)url1.openConnection();
                int filesize = connection.getContentLength();
                float totalDataRead = 0.0f;
                BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                FileOutputStream out = new FileOutputStream(this.outFile);
                BufferedOutputStream buf = new BufferedOutputStream(out, 1024);
                System.out.println("[Installer]: Connected to file \"" + file.getName() + '\"');
                byte[] data = new byte[1024];
                int i = 0;
                while ((i = in.read(data, 0, 1024)) >= 0) {
                    buf.write(data, 0, i);
                    float percent = (totalDataRead += (float)i) * 100.0f / (float)filesize;
                    this.ProgressBar.setValue((int)percent);
                    this.label.setText("Installing Naruto Mod: " + file.getName() + " " + (int)percent + "%");
                }
                buf.close();
                out.close();
                in.close();
                this.ProgressBar.setValue(100);
            } else {
                System.out.println("File: '" + this.outFile + "' already exists");
            }
        }
        catch (Exception event) {
            event.printStackTrace();
            this.label.setText("Install Failed!");
            Loader.InstallError("Install Failed!", "An error occurred while downloading one or more files, if this error continues to\n occour please report this to SEKWAH41!");
        }
    }
}

