/*
 * Decompiled with CFR 0.152.
 */
package com.nextgencrafters.narutomoddownloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class Unpacker
implements Runnable {
    String jarFile;
    String destDir;
    JLabel lb;
    private JProgressBar ProgressBar;

    public Unpacker(String var1, String var2, JLabel var3, JProgressBar var4) {
        this.jarFile = var1;
        this.destDir = var2;
        this.lb = var3;
        this.ProgressBar = var4;
    }

    @Override
    public void run() {
        try {
            File fs = new File(this.jarFile);
            JarFile jar = new JarFile(this.jarFile);
            Enumeration<JarEntry> enum1 = jar.entries();
            float totalDataRead = 0.0f;
            while (enum1.hasMoreElements()) {
                try {
                    int r;
                    float percent = (totalDataRead += 1.0f) / (float)jar.size() * 100.0f;
                    JarEntry file = enum1.nextElement();
                    if (file.isDirectory()) continue;
                    this.ProgressBar.setValue((int)percent);
                    File f = new File(String.valueOf(File.separator) + this.destDir + File.separator + file.getName());
                    System.out.println("Unpacking: " + f.getAbsolutePath() + "(" + file.getName() + ")");
                    this.lb.setText("Unpacking: " + fs.getName() + " (" + f.getName() + ")");
                    f.getParentFile().mkdirs();
                    InputStream is = jar.getInputStream(file);
                    FileOutputStream fos = new FileOutputStream(f);
                    int startAvailable = is.available();
                    byte[] buf = new byte[4096];
                    while ((r = is.read(buf)) != -1) {
                        fos.write(buf, 0, r);
                    }
                    fos.close();
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.lb.setText("Complete!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

