/*
 * Decompiled with CFR 0.152.
 */
package com.nextgencrafters.narutomodinstaller.windows;

import com.nextgencrafters.narutomodinstaller.windows.Window;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class SplashScreen
extends Window {
    private static final long serialVersionUID = -4641214802691288176L;
    protected BufferedImage splashImage = null;
    protected BufferedImage favicon = null;
    private SplashScreen splashScreenFrame = this;

    public SplashScreen() {
        this.favicon = this.loadTexture("Images/favicon.png");
        this.setUndecorated(true);
        this.splashScreenFrame.setOpacity(0.0f);
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setContentPane(new SplashLogo());
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setIconImage(this.favicon);
        this.setAlwaysOnTop(true);
    }

    public void fadeIn() {
        Thread fadeIn = new Thread(new Runnable(){
            private float fade = 0.0f;
            private int delta = 0;
            private long lastTime;

            @Override
            public void run() {
                this.lastTime = System.nanoTime();
                boolean fading = true;
                while (fading) {
                    double nsPerTick = 8333333.333333333;
                    this.delta = 0;
                    long now = System.nanoTime();
                    this.delta = (int)((double)this.delta + (double)(now - this.lastTime) / nsPerTick);
                    if (this.delta >= 1) {
                        this.lastTime = now;
                    } else if (this.delta < 0) {
                        this.lastTime = now;
                        System.out.println("[Naruto Mod] Your computer seems to have traveled back in time :O");
                    }
                    if (this.fade <= 1.0f && this.fade >= 0.0f) {
                        SplashScreen.this.splashScreenFrame.setOpacity(this.fade);
                    }
                    this.fade += (float)this.delta / 70.0f;
                    if (!(this.fade >= 1.0f)) continue;
                    SplashScreen.this.splashScreenFrame.setOpacity(1.0f);
                    fading = false;
                }
            }
        });
        fadeIn.run();
    }

    public void fadeOut() {
        Thread fadeOut = new Thread(new Runnable(){
            private float fade = 1.0f;
            private int delta = 0;
            private long lastTime;

            @Override
            public void run() {
                this.lastTime = System.nanoTime();
                boolean fading = true;
                while (fading) {
                    double nsPerTick = 8333333.333333333;
                    this.delta = 0;
                    long now = System.nanoTime();
                    this.delta = (int)((double)this.delta + (double)(now - this.lastTime) / nsPerTick);
                    if (this.delta >= 1) {
                        this.lastTime = now;
                    } else if (this.delta < 0) {
                        this.lastTime = now;
                        System.out.println("[Naruto Mod] Your computer seems to have traveled back in time :O");
                    }
                    if (this.fade <= 1.0f && this.fade >= 0.0f) {
                        SplashScreen.this.splashScreenFrame.setOpacity(this.fade);
                    }
                    this.fade -= (float)this.delta / 20.0f;
                    if (!(this.fade <= 0.0f)) continue;
                    SplashScreen.this.splashScreenFrame.setOpacity(0.0f);
                    fading = false;
                    SplashScreen.this.splashScreenFrame.setVisible(false);
                }
            }
        });
        fadeOut.run();
    }

    public class SplashLogo
    extends JPanel {
        private static final long serialVersionUID = 1845398991637298683L;

        public SplashLogo() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            SplashScreen.this.splashImage = SplashScreen.this.loadTexture("Images/splashScreen.png");
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(800, 277);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHints(hints);
            g2d.setColor(this.getBackground());
            g2d.drawImage(SplashScreen.this.splashImage, 0, 0, this.getWidth(), this.getHeight(), this);
            g2d.dispose();
        }
    }
}

