/*
 * Decompiled with CFR 0.152.
 */
package sekwah.mods.narutomod;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.InputStream;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sekwah.mods.narutomod.animation.NarutoAnimator;
import sekwah.mods.narutomod.animation.Pose;
import sekwah.mods.narutomod.blocks.NarutoBlocks;
import sekwah.mods.narutomod.entitys.NarutoEntitys;
import sekwah.mods.narutomod.generic.CommonProxy;
import sekwah.mods.narutomod.generic.EventServerHook;
import sekwah.mods.narutomod.generic.NarutoEffects;
import sekwah.mods.narutomod.generic.PlayerCommonTickEvent;
import sekwah.mods.narutomod.items.NarutoItems;
import sekwah.mods.narutomod.network.UpdateChecker;
import sekwah.mods.narutomod.packets.clientbound.ClientAnimationPacket;
import sekwah.mods.narutomod.packets.clientbound.ClientJutsuPacket;
import sekwah.mods.narutomod.packets.clientbound.ClientParticleEffectPacket;
import sekwah.mods.narutomod.packets.clientbound.ClientSoundPacket;
import sekwah.mods.narutomod.packets.serverbound.ServerAnimationPacket;
import sekwah.mods.narutomod.packets.serverbound.ServerJutsuPacket;
import sekwah.mods.narutomod.packets.serverbound.ServerParticleEffectPacket;
import sekwah.mods.narutomod.packets.serverbound.ServerSoundPacket;
import sekwah.mods.narutomod.settings.NarutoSettings;
import sekwah.mods.narutomod.worldgeneration.NarutoWorldGeneration;

@Mod(modid="narutomod", name="Naruto Mod", version="0.3.3")
public class NarutoMod {
    public static final String modid = "narutomod";
    public static final Logger LOGGER = LogManager.getLogger((String)"Sekwah41's Naruto Mod");
    @SidedProxy(clientSide="sekwah.mods.narutomod.client.ClientProxy", serverSide="sekwah.mods.narutomod.generic.CommonProxy")
    public static CommonProxy proxy;
    public static final String version = "0.3.3";
    public static int mcversion;
    public static int modversion;
    public static SimpleNetworkWrapper packetNetwork;
    public static NarutoAnimator entityAnimator;
    public static boolean isPreRelease;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        entityAnimator = new NarutoAnimator();
        NarutoAnimator.playerPoses = new Pose[1];
        NarutoAnimator.playerPoses[0] = new Pose("default");
        InputStream fileStreamJson = NarutoMod.class.getResourceAsStream("/assets/narutomod/mod/poseData.json");
        NarutoAnimator.playerPoses = entityAnimator.addPoses(fileStreamJson, NarutoAnimator.playerPoses);
        NarutoEntitys.addEntitys(this);
        NarutoWorldGeneration.registerWorldGenerators();
        proxy.addEventListener();
        proxy.addModderCapes();
        proxy.addKeyBindings();
        proxy.addTickHandelers();
        proxy.registerCustomItems();
        proxy.registerCustomBlocks();
        new UpdateChecker();
        MinecraftForge.EVENT_BUS.register((Object)new EventServerHook());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerCommonTickEvent());
        NarutoEntitys.addSpawns();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.addInGameGUIs();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.packetNetwork();
        NarutoEffects.editBasePotion();
        NarutoSettings.preInit(event);
        NarutoEffects.addEffects();
        NarutoBlocks.addBlocks(NarutoSettings.config);
        NarutoItems.addItems(NarutoSettings.config);
        NarutoItems.addDispenserBehavior();
        NarutoItems.addCrafting();
    }

    private void packetNetwork() {
        packetNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("SNM");
        packetNetwork.registerMessage(ClientParticleEffectPacket.class, ClientParticleEffectPacket.class, 0, Side.CLIENT);
        packetNetwork.registerMessage(ClientJutsuPacket.class, ClientJutsuPacket.class, 1, Side.CLIENT);
        packetNetwork.registerMessage(ClientSoundPacket.class, ClientSoundPacket.class, 2, Side.CLIENT);
        packetNetwork.registerMessage(ClientAnimationPacket.class, ClientAnimationPacket.class, 3, Side.CLIENT);
        packetNetwork.registerMessage(ServerParticleEffectPacket.class, ServerParticleEffectPacket.class, 4, Side.SERVER);
        packetNetwork.registerMessage(ServerJutsuPacket.class, ServerJutsuPacket.class, 5, Side.SERVER);
        packetNetwork.registerMessage(ServerAnimationPacket.class, ServerAnimationPacket.class, 6, Side.SERVER);
        packetNetwork.registerMessage(ServerSoundPacket.class, ServerSoundPacket.class, 7, Side.SERVER);
    }

    static {
        mcversion = 164;
        modversion = 33;
        isPreRelease = false;
    }
}

