/*
 * Decompiled with CFR 0.152.
 */
package sekwah.mods.narutomod.animation;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import sekwah.mods.narutomod.NarutoMod;
import sekwah.mods.narutomod.animation.AnimModelRenderer;
import sekwah.mods.narutomod.animation.PartData;
import sekwah.mods.narutomod.animation.Pose;
import sekwah.mods.narutomod.client.PlayerRenderTickEvent;
import sekwah.mods.narutomod.json.JSONObject;
import sekwah.mods.narutomod.packets.PacketAnimationUpdate;
import sekwah.mods.narutomod.packets.PacketDispatcher;
import sekwah.mods.narutomod.packets.serverbound.ServerJutsuPacket;
import sekwah.mods.narutomod.settings.NarutoSettings;

public class NarutoAnimator {
    public static Pose[] playerPoses;

    public NarutoAnimator() {
        playerPoses = new Pose[1];
        NarutoAnimator.playerPoses[0] = new Pose("default");
    }

    public static Pose[] sortAnimations(Pose[] poses) {
        for (int i = poses.length - 1; i >= 1; --i) {
            block1: for (int z = 0; z < i; ++z) {
                for (int j = 0; j < poses[z].poseName.length(); ++j) {
                    if (j <= poses[z].poseName.length() - 1 && j <= poses[z + 1].poseName.length() - 1) {
                        char poseChar;
                        char animChar = poses[z].poseName.charAt(j);
                        if (animChar > (poseChar = poses[z + 1].poseName.charAt(j))) {
                            Pose tempPose = poses[z];
                            poses[z] = poses[z + 1];
                            poses[z + 1] = tempPose;
                            continue block1;
                        }
                        if (animChar >= poseChar) continue;
                        continue block1;
                    }
                    if (j < poses[z].poseName.length() - 1) continue;
                    Pose tempPose = poses[z];
                    poses[z] = poses[z + 1];
                    poses[z + 1] = tempPose;
                    continue block1;
                }
            }
        }
        return poses;
    }

    public static PartData[] sortParts(PartData[] parts) {
        for (int i = parts.length - 1; i >= 1; --i) {
            block1: for (int z = 0; z < i; ++z) {
                for (int j = 0; j < parts[z].partName.length(); ++j) {
                    if (j <= parts[z].partName.length() - 1 && j <= parts[z + 1].partName.length() - 1) {
                        char poseChar;
                        char animChar = parts[z].partName.charAt(j);
                        if (animChar > (poseChar = parts[z + 1].partName.charAt(j))) {
                            PartData tempPart = parts[z];
                            parts[z] = parts[z + 1];
                            parts[z + 1] = tempPart;
                            continue block1;
                        }
                        if (animChar >= poseChar) continue;
                        continue block1;
                    }
                    if (j < parts[z].partName.length() - 1) continue;
                    PartData tempPart = parts[z];
                    parts[z] = parts[z + 1];
                    parts[z + 1] = tempPart;
                    continue block1;
                }
            }
        }
        return parts;
    }

    public static boolean animationExists(String animationID, Pose[] poseArray) {
        return NarutoAnimator.getPose(animationID, poseArray) != null;
    }

    public static Pose getPose(String animationID, Pose[] poseArray) {
        int first = 0;
        int last = poseArray.length - 1;
        boolean currentCharacter = false;
        int center = -1;
        while (last - first >= 0) {
            center = (int)Math.ceil((float)first + (float)(last - first) / 2.0f);
            if (poseArray[center].poseName.equals(animationID)) {
                return poseArray[center];
            }
            int difference = last - first;
            for (int i = 0; i < animationID.length(); ++i) {
                if (i <= poseArray[center].poseName.length() - 1 && i <= animationID.length() - 1) {
                    char poseChar;
                    char animChar = animationID.charAt(i);
                    if (animChar < (poseChar = poseArray[center].poseName.charAt(i))) {
                        last = center - 1;
                        break;
                    }
                    if (animChar <= poseChar) continue;
                    first = center;
                    break;
                }
                if (i > poseArray[center].poseName.length() - 1) {
                    first = center;
                    break;
                }
                if (i <= animationID.length() - 1) continue;
                last = center;
                break;
            }
            if (last - first != difference) continue;
            --last;
        }
        return null;
    }

    public static PartData getPart(String animationID, PartData[] partArray) {
        int first = 0;
        int last = partArray.length - 1;
        boolean currentCharacter = false;
        int center = -1;
        while (last - first >= 0) {
            center = (int)Math.ceil((float)first + (float)(last - first) / 2.0f);
            if (partArray[center].partName.equals(animationID)) {
                return partArray[center];
            }
            int difference = last - first;
            for (int i = 0; i < animationID.length(); ++i) {
                if (i <= partArray[center].partName.length() - 1 && i <= animationID.length() - 1) {
                    char poseChar;
                    char animChar = animationID.charAt(i);
                    if (animChar < (poseChar = partArray[center].partName.charAt(i))) {
                        last = center - 1;
                        break;
                    }
                    if (animChar <= poseChar) continue;
                    first = center;
                    break;
                }
                if (i > partArray[center].partName.length() - 1) {
                    first = center;
                    break;
                }
                if (i <= animationID.length() - 1) continue;
                last = center;
                break;
            }
            if (last - first != difference) continue;
            --last;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void animate(String animationID, String animationlastID, int animationTick, ArrayList<AnimModelRenderer> animatedParts, Pose[] poseArray) {
        PartData partData;
        int animLength;
        block12: {
            Pose lastPose;
            block11: {
                if (!animationID.equals("default") || animationlastID.equals("default")) break block11;
                lastPose = NarutoAnimator.getPose(animationlastID, poseArray);
                lastPose.updatePose();
                if (lastPose == null) {
                    NarutoMod.LOGGER.error("PoseData not found for: " + animationID);
                    throw new NullPointerException("PoseData not found for: " + animationID + ". Either the data is missing or an there is something wrong.");
                }
                animLength = lastPose.animLength;
                if (animLength > animationTick) {
                    for (AnimModelRenderer part : animatedParts) {
                        partData = NarutoAnimator.getPart(part.field_78802_n, lastPose.partData);
                        NarutoAnimator.animPosePart(part, partData, animLength - animationTick, animLength);
                    }
                }
                break block12;
            }
            if (!animationlastID.equals("default")) {
                lastPose = NarutoAnimator.getPose(animationlastID, poseArray);
                lastPose.updatePose();
                if (lastPose == null) {
                    NarutoMod.LOGGER.error("PoseData not found for: " + animationID);
                    throw new NullPointerException("PoseData not found for: " + animationID + ". Either the data is missing or an there is something wrong.");
                }
                for (AnimModelRenderer part : animatedParts) {
                    PartData partData2 = NarutoAnimator.getPart(part.field_78802_n, lastPose.partData);
                    NarutoAnimator.setPosePart(part, partData2);
                }
            }
        }
        if (animationID.equals("default")) return;
        Pose currentPose = NarutoAnimator.getPose(animationID, poseArray);
        currentPose.updatePose();
        if (currentPose == null) {
            NarutoMod.LOGGER.error("PoseData not found for: " + animationID);
            throw new NullPointerException("PoseData not found for: " + animationID + ". Either the data is missing or an there is something wrong.");
        }
        animLength = currentPose.animLength;
        if (animLength > animationTick) {
            for (AnimModelRenderer part : animatedParts) {
                partData = NarutoAnimator.getPart(part.field_78802_n, currentPose.partData);
                NarutoAnimator.animPosePart(part, partData, animationTick, animLength);
            }
            return;
        } else {
            for (AnimModelRenderer part : animatedParts) {
                partData = NarutoAnimator.getPart(part.field_78802_n, currentPose.partData);
                NarutoAnimator.setPosePart(part, partData);
            }
        }
    }

    private static void animPosePart(AnimModelRenderer bodyPart, PartData partData, int animationTick, int animLength) {
        if (partData != null) {
            if (partData.shouldRot[0]) {
                bodyPart.field_78795_f -= (bodyPart.field_78795_f - partData.rotateAngleX) / (float)animLength * (float)animationTick;
            }
            if (partData.shouldRot[1]) {
                bodyPart.field_78796_g -= (bodyPart.field_78796_g - partData.rotateAngleY) / (float)animLength * (float)animationTick;
            }
            if (partData.shouldRot[2]) {
                bodyPart.field_78808_h -= (bodyPart.field_78808_h - partData.rotateAngleZ) / (float)animLength * (float)animationTick;
            }
            if (partData.hasPos[0]) {
                bodyPart.field_78800_c -= (bodyPart.field_78800_c - partData.rotationPointX) / (float)animLength * (float)animationTick;
            }
            if (partData.hasPos[1]) {
                bodyPart.field_78797_d -= (bodyPart.field_78797_d - partData.rotationPointY) / (float)animLength * (float)animationTick;
            }
            if (partData.hasPos[2]) {
                bodyPart.field_78798_e -= (bodyPart.field_78798_e - partData.rotationPointZ) / (float)animLength * (float)animationTick;
            }
        }
    }

    private static void setPosePart(AnimModelRenderer bodyPart, PartData partData) {
        if (partData != null) {
            if (partData.shouldRot[0]) {
                bodyPart.field_78795_f = partData.rotateAngleX;
            }
            if (partData.shouldRot[1]) {
                bodyPart.field_78796_g = partData.rotateAngleY;
            }
            if (partData.shouldRot[2]) {
                bodyPart.field_78808_h = partData.rotateAngleZ;
            }
            if (partData.hasPos[0]) {
                bodyPart.field_78800_c = partData.rotationPointX;
            }
            if (partData.hasPos[1]) {
                bodyPart.field_78797_d = partData.rotationPointY;
            }
            if (partData.hasPos[2]) {
                bodyPart.field_78798_e = partData.rotationPointZ;
            }
        }
    }

    public static void updateEntity(DataWatcher dw, Entity entity, Pose[] poseArray) {
        NBTTagCompound data = entity.getEntityData();
        if (!dw.func_75681_e(20).equals(dw.func_75681_e(27))) {
            dw.func_75692_b(25, (Object)0);
            dw.func_75692_b(27, (Object)dw.func_75681_e(20));
        }
        if (dw.func_75681_e(20).equals(dw.func_75681_e(27)) && NarutoAnimator.getPose(dw.func_75681_e(20), poseArray) != null && NarutoAnimator.getPose((String)dw.func_75681_e((int)20), (Pose[])poseArray).animLength > dw.func_75679_c(25)) {
            int delta = PlayerRenderTickEvent.delta;
            while (delta-- >= 1) {
                if (NarutoAnimator.getPose((String)dw.func_75681_e((int)20), (Pose[])poseArray).animLength <= dw.func_75679_c(25)) continue;
                dw.func_75692_b(25, (Object)(dw.func_75679_c(25) + 1));
            }
        } else {
            dw.func_75692_b(26, (Object)dw.func_75681_e(20));
        }
    }

    public static void updateClient(EntityClientPlayerMP playerMP, Pose[] poseArray) {
        NBTTagCompound data = playerMP.getEntityData();
        DataWatcher dw = playerMP.func_70096_w();
        if (!dw.func_75681_e(20).equals(dw.func_75681_e(27))) {
            dw.func_75692_b(25, (Object)0);
            dw.func_75692_b(27, (Object)dw.func_75681_e(20));
            PlayerRenderTickEvent.hasFiredAnimationUpdate = false;
        }
        if (dw.func_75681_e(20).equals(dw.func_75681_e(27)) && NarutoAnimator.getPose(dw.func_75681_e(20), poseArray) != null && NarutoAnimator.getPose((String)dw.func_75681_e((int)20), (Pose[])poseArray).animLength > dw.func_75679_c(25)) {
            int delta = PlayerRenderTickEvent.delta;
            while (delta-- >= 1) {
                if (NarutoAnimator.getPose((String)dw.func_75681_e((int)20), (Pose[])poseArray).animLength > dw.func_75679_c(25)) {
                    dw.func_75692_b(25, (Object)(dw.func_75679_c(25) + 1));
                    continue;
                }
                if (!PlayerRenderTickEvent.hasFiredAnimationUpdate) {
                    NarutoAnimator.animationComplete(playerMP, poseArray);
                }
                PlayerRenderTickEvent.hasFiredAnimationUpdate = true;
            }
            if (NarutoSettings.experimentalFirstPersonMode == 2) {
                NarutoSettings.experimentalFirstPerson = true;
            }
        } else {
            if (!PlayerRenderTickEvent.hasFiredAnimationUpdate) {
                NarutoAnimator.animationComplete(playerMP, poseArray);
                PlayerRenderTickEvent.hasFiredAnimationUpdate = true;
            }
            if (dw.func_75681_e(20).equals("default") && NarutoSettings.experimentalFirstPersonMode == 2) {
                NarutoSettings.experimentalFirstPerson = false;
            }
        }
    }

    private static void animationComplete(EntityClientPlayerMP playerMP, Pose[] poseArray) {
        DataWatcher dw = playerMP.func_70096_w();
        dw.func_75692_b(26, (Object)dw.func_75681_e(20));
        String animationID = dw.func_75681_e(20);
        Pose pose = NarutoAnimator.getPose(animationID, poseArray);
        if (pose != null) {
            if (pose.nextPose != null) {
                PacketAnimationUpdate.animationUpdate(pose.nextPose, playerMP);
            }
            if (pose.completeAction != 0) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
                DataOutputStream outputStream = new DataOutputStream(bos);
                try {
                    outputStream.writeInt(pose.completeAction);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                PacketDispatcher.sendPacketToServer(new ServerJutsuPacket(bos.toByteArray()));
            }
        }
    }

    public Pose[] addPoses(InputStream filestreamJson, Pose[] poseArray) {
        try {
            int i;
            String json = this.readJSONFileStream(filestreamJson);
            JSONObject poseFile = new JSONObject(json);
            JSONObject poseData = poseFile.getJSONObject("poses");
            NarutoMod.LOGGER.info((Object)JSONObject.getNames("poses"));
            String[] poseNames = JSONObject.getNames(poseData);
            Pose[] oldPoses = poseArray;
            poseArray = new Pose[poseArray.length + poseNames.length];
            for (i = 0; i < oldPoses.length; ++i) {
                poseArray[i] = oldPoses[i];
            }
            for (i = oldPoses.length; i < poseArray.length; ++i) {
                String currentPoseName = poseNames[i - oldPoses.length];
                NarutoMod.LOGGER.info("Adding pose: " + currentPoseName);
                JSONObject poseInfo = poseData.getJSONObject(currentPoseName);
                JSONObject locData = poseInfo.getJSONObject("locData");
                String[] positionNames = JSONObject.getNames(locData);
                PartData[] partArray = new PartData[positionNames.length];
                for (int n = 0; n < positionNames.length; ++n) {
                    JSONObject partData = locData.getJSONObject(positionNames[n]);
                    PartData currentPart = new PartData(positionNames[n]);
                    if (partData.has("posX")) {
                        currentPart.hasPos[0] = true;
                        currentPart.rotationPointX = partData.getFloat("posX");
                    }
                    if (partData.has("posY")) {
                        currentPart.hasPos[1] = true;
                        currentPart.rotationPointY = partData.getFloat("posY");
                    }
                    if (partData.has("posZ")) {
                        currentPart.hasPos[2] = true;
                        currentPart.rotationPointZ = partData.getFloat("posZ");
                    }
                    if (partData.has("rotX")) {
                        currentPart.shouldRot[0] = true;
                        currentPart.rotateAngleX = partData.getFloat("rotX");
                    }
                    if (partData.has("rotY")) {
                        currentPart.shouldRot[1] = true;
                        currentPart.rotateAngleY = partData.getFloat("rotY");
                    }
                    if (partData.has("rotZ")) {
                        currentPart.shouldRot[2] = true;
                        currentPart.rotateAngleZ = partData.getFloat("rotZ");
                    }
                    partArray[n] = currentPart;
                }
                Pose currentPose = new Pose(currentPoseName, NarutoAnimator.sortParts(partArray));
                currentPose.poseName = currentPoseName;
                if (poseInfo.has("animLength")) {
                    currentPose.animLength = poseInfo.getInt("animLength");
                }
                if (poseInfo.has("nextPose")) {
                    currentPose.nextPose = poseInfo.getString("nextPose");
                }
                if (poseInfo.has("completeAction")) {
                    currentPose.completeAction = poseInfo.getInt("completeAction");
                }
                poseArray[i] = currentPose;
            }
        }
        catch (IOException e) {
            NarutoMod.LOGGER.error("Error loading poseData");
            e.printStackTrace();
        }
        poseArray = NarutoAnimator.sortAnimations(poseArray);
        return poseArray;
    }

    private String readJSONFileStream(InputStream filestreamJson) throws IOException {
        String line;
        InputStreamReader inr = new InputStreamReader(filestreamJson, "ASCII");
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        inr.close();
        return sb.toString();
    }

    public String readJSONFile(File file) throws IOException {
        String line;
        FileInputStream fin = new FileInputStream(file);
        InputStreamReader inr = new InputStreamReader((InputStream)fin, "ASCII");
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        inr.close();
        fin.close();
        return sb.toString();
    }
}

