/*
 * Decompiled with CFR 0.152.
 */
package sekwah.mods.narutomod.client.customanimations;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.DataWatcher;
import net.minecraft.nbt.NBTTagCompound;
import sekwah.mods.narutomod.client.PlayerRenderTickEvent;
import sekwah.mods.narutomod.json.JSONObject;
import sekwah.mods.narutomod.packets.PacketAnimationUpdate;
import sekwah.mods.narutomod.packets.PacketDispatcher;
import sekwah.mods.narutomod.packets.serverbound.ServerAnimationPacket;
import sekwah.mods.narutomod.player.ModelNinjaBiped;

public class PlayerPoseAnimatorNewProto {
    public static JSONObject poses;
    private static JSONObject poseData;
    private boolean jsonLoaded = false;

    public PlayerPoseAnimatorNewProto() {
        InputStream filestreamJson = PlayerPoseAnimatorNewProto.class.getResourceAsStream("/assets/narutomod/mod/poseData.json");
        try {
            String json = this.readJSONFileStream(filestreamJson);
            poseData = new JSONObject(json);
            poses = poseData.getJSONObject("poses");
            this.jsonLoaded = true;
        }
        catch (IOException e) {
            this.jsonLoaded = false;
            System.out.println("Error loading poseData");
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void animate(ModelNinjaBiped modelBiped, String animationID, String animationlastID, int animationTick) {
        int animLength;
        JSONObject locData;
        JSONObject poseInfo;
        block57: {
            block56: {
                if (!animationID.equals("default") || animationlastID.equals("default")) break block56;
                if (!poses.has(animationlastID)) {
                    System.out.println("[NarutoMod] PoseData not found for: " + animationID);
                    throw new NullPointerException("PoseData not found for: " + animationID + ". Either the data is missing or an there is something wrong.");
                }
                poseInfo = poses.getJSONObject(animationlastID);
                locData = poseInfo.getJSONObject("locData");
                animLength = poseInfo.getInt("animLength");
                if (animLength > animationTick) {
                    if (locData.has("rightArmUpper")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedRightArmUpper, locData.getJSONObject("rightArmUpper"), animLength - animationTick, animLength);
                    }
                    if (locData.has("leftArmUpper")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedLeftArmUpper, locData.getJSONObject("leftArmUpper"), animLength - animationTick, animLength);
                    }
                    if (locData.has("rightArmLower")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedRightArmLower, locData.getJSONObject("rightArmLower"), animLength - animationTick, animLength);
                    }
                    if (locData.has("leftArmLower")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedLeftArmLower, locData.getJSONObject("leftArmLower"), animLength - animationTick, animLength);
                    }
                    if (locData.has("rightLeg")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78123_h, locData.getJSONObject("rightLeg"), animLength - animationTick, animLength);
                    }
                    if (locData.has("leftLeg")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78124_i, locData.getJSONObject("leftLeg"), animLength - animationTick, animLength);
                    }
                    if (locData.has("upperBody")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78115_e, locData.getJSONObject("upperBody"), animLength - animationTick, animLength);
                    }
                    if (locData.has("lowerBody")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedLowerBody, locData.getJSONObject("lowerBody"), animLength - animationTick, animLength);
                    }
                    if (locData.has("head")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78116_c, locData.getJSONObject("head"), animLength - animationTick, animLength);
                    }
                    if (locData.has("head")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78114_d, locData.getJSONObject("head"), animLength - animationTick, animLength);
                    }
                    if (locData.has("head")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedMask, locData.getJSONObject("head"), animLength - animationTick, animLength);
                    }
                    if (locData.has("head")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedMaskmed, locData.getJSONObject("head"), animLength - animationTick, animLength);
                    }
                    if (locData.has("head")) {
                        PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedMasksmall, locData.getJSONObject("head"), animLength - animationTick, animLength);
                    }
                }
                break block57;
            }
            if (!animationlastID.equals("default")) {
                if (!poses.has(animationlastID)) {
                    System.out.println("[NarutoMod] PoseData not found for: " + animationID);
                    throw new NullPointerException("PoseData not found for: " + animationID + ". Either the data is missing or an there is something wrong.");
                }
                JSONObject lastPoseInfo = poses.getJSONObject(animationlastID);
                locData = lastPoseInfo.getJSONObject("locData");
                if (locData.has("rightArmUpper")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedRightArmUpper, locData.getJSONObject("rightArmUpper"));
                }
                if (locData.has("leftArmUpper")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedLeftArmUpper, locData.getJSONObject("leftArmUpper"));
                }
                if (locData.has("rightArmLower")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedRightArmLower, locData.getJSONObject("rightArmLower"));
                }
                if (locData.has("leftArmLower")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedLeftArmLower, locData.getJSONObject("leftArmLower"));
                }
                if (locData.has("rightLeg")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78123_h, locData.getJSONObject("rightLeg"));
                }
                if (locData.has("leftLeg")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78124_i, locData.getJSONObject("leftLeg"));
                }
                if (locData.has("upperBody")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78115_e, locData.getJSONObject("upperBody"));
                }
                if (locData.has("lowerBody")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedLowerBody, locData.getJSONObject("lowerBody"));
                }
                if (locData.has("head")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78116_c, locData.getJSONObject("head"));
                }
                if (locData.has("head")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78114_d, locData.getJSONObject("head"));
                }
                if (locData.has("head")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedMask, locData.getJSONObject("head"));
                }
                if (locData.has("head")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedMaskmed, locData.getJSONObject("head"));
                }
                if (locData.has("head")) {
                    PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedMasksmall, locData.getJSONObject("head"));
                }
            }
        }
        if (animationID.equals("default")) return;
        if (!poses.has(animationID)) {
            System.out.println("[NarutoMod] PoseData not found for: " + animationID);
            throw new NullPointerException("PoseData not found for: " + animationID + ". Either the data is missing or an there is something wrong.");
        }
        poseInfo = poses.getJSONObject(animationID);
        locData = poseInfo.getJSONObject("locData");
        animLength = poseInfo.getInt("animLength");
        if (animLength > animationTick) {
            if (locData.has("rightArmUpper")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedRightArmUpper, locData.getJSONObject("rightArmUpper"), animationTick, animLength);
            }
            if (locData.has("leftArmUpper")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedLeftArmUpper, locData.getJSONObject("leftArmUpper"), animationTick, animLength);
            }
            if (locData.has("rightArmLower")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedRightArmLower, locData.getJSONObject("rightArmLower"), animationTick, animLength);
            }
            if (locData.has("leftArmLower")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedLeftArmLower, locData.getJSONObject("leftArmLower"), animationTick, animLength);
            }
            if (locData.has("rightLeg")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78123_h, locData.getJSONObject("rightLeg"), animationTick, animLength);
            }
            if (locData.has("leftLeg")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78124_i, locData.getJSONObject("leftLeg"), animationTick, animLength);
            }
            if (locData.has("upperBody")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78115_e, locData.getJSONObject("upperBody"), animationTick, animLength);
            }
            if (locData.has("lowerBody")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedLowerBody, locData.getJSONObject("lowerBody"), animationTick, animLength);
            }
            if (locData.has("head")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78116_c, locData.getJSONObject("head"), animationTick, animLength);
            }
            if (locData.has("head")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.field_78114_d, locData.getJSONObject("head"), animationTick, animLength);
            }
            if (locData.has("head")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedMask, locData.getJSONObject("head"), animationTick, animLength);
            }
            if (locData.has("head")) {
                PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedMasksmall, locData.getJSONObject("head"), animationTick, animLength);
            }
            if (!locData.has("head")) return;
            PlayerPoseAnimatorNewProto.animPosePart(modelBiped.bipedMaskmed, locData.getJSONObject("head"), animationTick, animLength);
            return;
        }
        if (locData.has("rightArmUpper")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedRightArmUpper, locData.getJSONObject("rightArmUpper"));
        }
        if (locData.has("leftArmUpper")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedLeftArmUpper, locData.getJSONObject("leftArmUpper"));
        }
        if (locData.has("rightArmLower")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedRightArmLower, locData.getJSONObject("rightArmLower"));
        }
        if (locData.has("leftArmLower")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedLeftArmLower, locData.getJSONObject("leftArmLower"));
        }
        if (locData.has("rightLeg")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78123_h, locData.getJSONObject("rightLeg"));
        }
        if (locData.has("leftLeg")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78124_i, locData.getJSONObject("leftLeg"));
        }
        if (locData.has("upperBody")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78115_e, locData.getJSONObject("upperBody"));
        }
        if (locData.has("lowerBody")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedLowerBody, locData.getJSONObject("lowerBody"));
        }
        if (locData.has("head")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78116_c, locData.getJSONObject("head"));
        }
        if (locData.has("head")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.field_78114_d, locData.getJSONObject("head"));
        }
        if (locData.has("head")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedMask, locData.getJSONObject("head"));
        }
        if (locData.has("head")) {
            PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedMaskmed, locData.getJSONObject("head"));
        }
        if (!locData.has("head")) return;
        PlayerPoseAnimatorNewProto.setPosePart(modelBiped.bipedMasksmall, locData.getJSONObject("head"));
    }

    private static void animPosePart(ModelRenderer bodyPart, JSONObject poseInfo, int animationTick, int animLength) {
        if (poseInfo.has("rotX")) {
            bodyPart.field_78795_f -= (bodyPart.field_78795_f - poseInfo.getFloat("rotX")) / (float)animLength * (float)animationTick;
        }
        if (poseInfo.has("rotY")) {
            bodyPart.field_78796_g -= (bodyPart.field_78796_g - poseInfo.getFloat("rotY")) / (float)animLength * (float)animationTick;
        }
        if (poseInfo.has("rotZ")) {
            bodyPart.field_78808_h -= (bodyPart.field_78808_h - poseInfo.getFloat("rotZ")) / (float)animLength * (float)animationTick;
        }
        if (poseInfo.has("posX")) {
            bodyPart.field_78800_c -= (bodyPart.field_78800_c - poseInfo.getFloat("posX")) / (float)animLength * (float)animationTick;
        }
        if (poseInfo.has("posY")) {
            bodyPart.field_78797_d -= (bodyPart.field_78797_d - poseInfo.getFloat("posY")) / (float)animLength * (float)animationTick;
        }
        if (poseInfo.has("posZ")) {
            bodyPart.field_78798_e -= (bodyPart.field_78798_e - poseInfo.getFloat("posZ")) / (float)animLength * (float)animationTick;
        }
    }

    private static void setPosePart(ModelRenderer bodyPart, JSONObject poseInfo) {
        if (poseInfo.has("rotX")) {
            bodyPart.field_78795_f = poseInfo.getFloat("rotX");
        }
        if (poseInfo.has("rotY")) {
            bodyPart.field_78796_g = poseInfo.getFloat("rotY");
        }
        if (poseInfo.has("rotZ")) {
            bodyPart.field_78808_h = poseInfo.getFloat("rotZ");
        }
        if (poseInfo.has("posX")) {
            bodyPart.field_78800_c = poseInfo.getFloat("posX");
        }
        if (poseInfo.has("posY")) {
            bodyPart.field_78797_d = poseInfo.getFloat("posY");
        }
        if (poseInfo.has("posZ")) {
            bodyPart.field_78798_e = poseInfo.getFloat("posZ");
        }
    }

    public static int getAnimTicks(String animationID) {
        if (!animationID.equals("default") && poses.has(animationID)) {
            JSONObject poseInfo = poses.getJSONObject(animationID);
            return poseInfo.getInt("animLength");
        }
        return 60;
    }

    public static void updatePlayer(DataWatcher dw, EntityClientPlayerMP playerMP) {
        NBTTagCompound data = playerMP.getEntityData();
        if (!dw.func_75681_e(20).equals(data.func_74779_i("lastposeClient"))) {
            dw.func_75692_b(25, (Object)0);
            data.func_74778_a("lastposeClient", dw.func_75681_e(20));
        }
        if (dw.func_75681_e(20).equals(data.func_74779_i("lastposeClient")) & PlayerPoseAnimatorNewProto.getAnimTicks(dw.func_75681_e(20)) > dw.func_75679_c(25)) {
            int delta = PlayerRenderTickEvent.delta;
            while (delta-- >= 1) {
                if (PlayerPoseAnimatorNewProto.getAnimTicks(dw.func_75681_e(20)) <= dw.func_75679_c(25)) continue;
                dw.func_75692_b(25, (Object)(dw.func_75679_c(25) + 1));
            }
        } else {
            dw.func_75692_b(26, (Object)dw.func_75681_e(20));
        }
    }

    public static void updateClient(EntityClientPlayerMP playerMP) {
        NBTTagCompound data = playerMP.getEntityData();
        DataWatcher dw = playerMP.func_70096_w();
        if (!dw.func_75681_e(20).equals(data.func_74779_i("lastposeClient"))) {
            dw.func_75692_b(25, (Object)0);
            data.func_74778_a("lastposeClient", dw.func_75681_e(20));
            PlayerRenderTickEvent.hasFiredAnimationUpdate = false;
        }
        if (dw.func_75681_e(20).equals(data.func_74779_i("lastposeClient")) & PlayerPoseAnimatorNewProto.getAnimTicks(dw.func_75681_e(20)) > dw.func_75679_c(25)) {
            int delta = PlayerRenderTickEvent.delta;
            while (delta-- >= 1) {
                if (PlayerPoseAnimatorNewProto.getAnimTicks(dw.func_75681_e(20)) <= dw.func_75679_c(25)) continue;
                dw.func_75692_b(25, (Object)(dw.func_75679_c(25) + 1));
            }
        } else if (!PlayerRenderTickEvent.hasFiredAnimationUpdate) {
            dw.func_75692_b(26, (Object)dw.func_75681_e(20));
            PlayerPoseAnimatorNewProto.animationComplete(playerMP);
            PlayerRenderTickEvent.hasFiredAnimationUpdate = true;
        }
    }

    private static void animationComplete(EntityClientPlayerMP playerMP) {
        DataWatcher dw = playerMP.func_70096_w();
        String animationID = dw.func_75681_e(20);
        if (poses.has(animationID)) {
            JSONObject poseInfo = poses.getJSONObject(animationID);
            if (poseInfo.has("nextPose")) {
                String nextPose = poseInfo.getString("nextPose");
                PacketAnimationUpdate.animationUpdate(nextPose, playerMP);
            }
            if (poseInfo.has("completeAction")) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
                DataOutputStream outputStream = new DataOutputStream(bos);
                try {
                    outputStream.writeInt(Integer.parseInt(poseInfo.getString("completeAction")));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                PacketDispatcher.sendPacketToServer(new ServerAnimationPacket(bos.toByteArray()));
            }
        }
    }

    private String readJSONFileStream(InputStream filestreamJson) throws IOException {
        String line;
        InputStreamReader inr = new InputStreamReader(filestreamJson, "ASCII");
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        inr.close();
        return sb.toString();
    }

    public String readJSONFile(File file) throws IOException {
        String line;
        FileInputStream fin = new FileInputStream(file);
        InputStreamReader inr = new InputStreamReader((InputStream)fin, "ASCII");
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        inr.close();
        fin.close();
        return sb.toString();
    }
}

