/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.mod;

import airbreather.mods.airbreathercore.CustomConfiguration;
import airbreather.mods.airbreathercore.event.EventConfiguration;
import airbreather.mods.airbreathercore.event.EventSubscriber;
import airbreather.mods.airbreathercore.event.EventType;
import airbreather.mods.airbreathercore.item.ItemConfiguration;
import airbreather.mods.airbreathercore.item.ItemRegistrar;
import airbreather.mods.airbreathercore.item.ItemRegistry;
import airbreather.mods.airbreathercore.mod.IModLifecycleManager;
import airbreather.mods.airbreathercore.mod.IModule;
import airbreather.mods.airbreathercore.recipe.RecipeConfiguration;
import airbreather.mods.airbreathercore.recipe.RecipeRegistrar;
import com.google.common.base.Preconditions;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.IEventListener;

public final class ModLifecycleManager
implements IModLifecycleManager {
    private final ItemRegistry itemRegistry;
    private final ItemRegistrar itemRegistrar;
    private final RecipeRegistrar recipeRegistrar;
    private final EventSubscriber eventSubscriber;
    private final CustomConfiguration configuration;

    public ModLifecycleManager(IModule module) {
        Preconditions.checkNotNull((Object)module, (Object)"module");
        this.itemRegistry = module.GetItemRegistry();
        this.itemRegistrar = module.GetItemRegistrar();
        this.recipeRegistrar = module.GetRecipeRegistrar();
        this.eventSubscriber = module.GetEventSubscriber();
        this.configuration = module.GetCustomConfiguration();
    }

    @Override
    public void OnPreInit(FMLPreInitializationEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        this.configuration.Initialize(event.getSuggestedConfigurationFile());
        ItemConfiguration itemConfiguration = this.configuration.GetItemConfiguration();
        this.itemRegistrar.RegisterNewItems(itemConfiguration, this.itemRegistry);
        RecipeConfiguration recipeConfiguration = this.configuration.GetRecipeConfiguration();
        this.recipeRegistrar.RegisterRecipes(recipeConfiguration, this.itemRegistry);
        this.eventSubscriber.Initialize();
        EventConfiguration eventConfiguration = this.configuration.GetEventConfiguration();
        for (EventType eventType : eventConfiguration.GetRecognizedEventTypes()) {
            for (IEventListener handler : eventConfiguration.GetEventHandlers(eventType)) {
                this.eventSubscriber.SubscribeToEvent(eventType, handler);
            }
        }
    }

    @Override
    public void OnInit(FMLInitializationEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
    }

    @Override
    public void OnPostInit(FMLPostInitializationEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
    }
}

