/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.yafm;

import airbreather.mods.airbreathercore.CustomConfigurationBase;
import airbreather.mods.airbreathercore.event.EventConfiguration;
import airbreather.mods.airbreathercore.item.ItemConfiguration;
import airbreather.mods.airbreathercore.recipe.RecipeConfiguration;
import airbreather.mods.yafm.YafmEventConfiguration;
import airbreather.mods.yafm.YafmItemConfiguration;
import airbreather.mods.yafm.YafmRecipeConfiguration;
import com.google.common.base.Preconditions;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

final class YafmConfigurationAdapter
extends CustomConfigurationBase {
    private final YafmItemConfiguration itemConfiguration;
    private final YafmRecipeConfiguration recipeConfiguration;
    private final YafmEventConfiguration eventConfiguration;

    public YafmConfigurationAdapter(YafmItemConfiguration itemConfiguration, YafmRecipeConfiguration recipeConfiguration, YafmEventConfiguration eventConfiguration) {
        this.itemConfiguration = (YafmItemConfiguration)Preconditions.checkNotNull((Object)itemConfiguration, (Object)"itemConfiguration");
        this.recipeConfiguration = (YafmRecipeConfiguration)Preconditions.checkNotNull((Object)recipeConfiguration, (Object)"recipeConfiguration");
        this.eventConfiguration = (YafmEventConfiguration)Preconditions.checkNotNull((Object)eventConfiguration, (Object)"eventConfiguration");
    }

    @Override
    public void Initialize(File configurationFile) {
        Preconditions.checkNotNull((Object)configurationFile, (Object)"configurationFile");
        Configuration forgeConfiguration = new Configuration(configurationFile);
        forgeConfiguration.load();
        if (YafmConfigurationAdapter.ShouldEnableFriedEggRecipe(forgeConfiguration)) {
            this.recipeConfiguration.EnableFriedEggRecipe();
        }
        if (YafmConfigurationAdapter.ShouldEnableCarrotSoupRecipe(forgeConfiguration)) {
            this.recipeConfiguration.EnableCarrotSoupRecipe();
        }
        if (YafmConfigurationAdapter.ShouldEnableRawMuttonDrops(forgeConfiguration)) {
            this.eventConfiguration.EnableRawMuttonDrops();
        }
        if (YafmConfigurationAdapter.ShouldEnableRawSquidDrops(forgeConfiguration)) {
            this.eventConfiguration.EnableRawSquidDrops();
        }
        this.recipeConfiguration.EnableCookedMuttonRecipe();
        this.recipeConfiguration.EnableCookedSquidRecipe();
        forgeConfiguration.save();
    }

    @Override
    public RecipeConfiguration GetRecipeConfiguration() {
        return this.recipeConfiguration;
    }

    @Override
    public ItemConfiguration GetItemConfiguration() {
        return this.itemConfiguration;
    }

    @Override
    public EventConfiguration GetEventConfiguration() {
        return this.eventConfiguration;
    }

    private static boolean ShouldEnableFriedEggRecipe(Configuration forgeConfiguration) {
        String enableFriedEggRecipePropertyName = "enableFriedEggRecipe";
        boolean enableFriedEggRecipeDefault = true;
        String enableFriedEggRecipeComment = "Enable the Egg --> Fried Egg smelting recipe?  true/false (true is the default)";
        Property enableFriedEggRecipeProperty = forgeConfiguration.get("general", enableFriedEggRecipePropertyName, enableFriedEggRecipeDefault, enableFriedEggRecipeComment);
        return enableFriedEggRecipeProperty.getBoolean(enableFriedEggRecipeDefault);
    }

    private static boolean ShouldEnableCarrotSoupRecipe(Configuration forgeConfiguration) {
        String enableCarrotSoupRecipePropertyName = "enableCarrotSoupRecipe";
        boolean enableCarrotSoupRecipeDefault = true;
        String enableCarrotSoupRecipeComment = "Enable the Carrot Soup crafting recipe?  true/false (true is the default)";
        Property enableCarrotSoupRecipeProperty = forgeConfiguration.get("general", enableCarrotSoupRecipePropertyName, enableCarrotSoupRecipeDefault, enableCarrotSoupRecipeComment);
        return enableCarrotSoupRecipeProperty.getBoolean(enableCarrotSoupRecipeDefault);
    }

    private static boolean ShouldEnableRawMuttonDrops(Configuration forgeConfiguration) {
        String enableRawMuttonDropsPropertyName = "enableRawMuttonDrops";
        boolean enableRawMuttonDropsDefault = true;
        String enableRawMuttonDropsComment = "Allow sheep to drop raw mutton?  true/false (true is the default)";
        Property enableRawMuttonDropsProperty = forgeConfiguration.get("general", enableRawMuttonDropsPropertyName, enableRawMuttonDropsDefault, enableRawMuttonDropsComment);
        return enableRawMuttonDropsProperty.getBoolean(enableRawMuttonDropsDefault);
    }

    private static boolean ShouldEnableRawSquidDrops(Configuration forgeConfiguration) {
        String enableRawSquidDropsPropertyName = "enableRawSquidDrops";
        boolean enableRawSquidDropsDefault = true;
        String enableRawSquidDropsComment = "Allow squid to drop raw squid?  true/false (true is the default)";
        Property enableRawSquidDropsProperty = forgeConfiguration.get("general", enableRawSquidDropsPropertyName, enableRawSquidDropsDefault, enableRawSquidDropsComment);
        return enableRawSquidDropsProperty.getBoolean(enableRawSquidDropsDefault);
    }
}

