/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.airbreathercore.event;

import airbreather.mods.airbreathercore.event.EventSubscriber;
import airbreather.mods.airbreathercore.event.EventType;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public final class ForgeEventSubscriber
implements EventSubscriber {
    private final ListMultimap<EventType, IEventListener> eventListenerMap;

    public ForgeEventSubscriber() {
        LinkedListMultimap map = LinkedListMultimap.create();
        this.eventListenerMap = Multimaps.synchronizedListMultimap((ListMultimap)map);
    }

    @Override
    public void SubscribeToEvent(EventType eventType, IEventListener handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"handler");
        this.eventListenerMap.put((Object)eventType, (Object)handler);
    }

    @Override
    public void Initialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnLivingDropsEvent(LivingDropsEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"event");
        for (IEventListener handler : this.eventListenerMap.get((Object)EventType.LivingDrops)) {
            handler.invoke((Event)event);
        }
    }
}

