/*
 * Decompiled with CFR 0.152.
 */
package airbreather.mods.yafm;

import airbreather.mods.airbreathercore.item.ItemDefinition;
import airbreather.mods.airbreathercore.item.ItemRegistrarBase;
import airbreather.mods.yafm.ItemFoodInContainer;
import airbreather.mods.yafm.YafmConstants;
import com.google.common.base.Preconditions;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;

final class YafmItemRegistrar
extends ItemRegistrarBase {
    YafmItemRegistrar() {
    }

    @Override
    public Item CreateItemCore(ItemDefinition definition) {
        Preconditions.checkNotNull((Object)definition, (Object)"definition");
        if (definition.equals(YafmConstants.FriedEggItemDefinition)) {
            return YafmItemRegistrar.CreateFoodItem(16, 5, 0.6f, true);
        }
        if (definition.equals(YafmConstants.RawMuttonItemDefinition)) {
            return YafmItemRegistrar.CreateFoodItem(64, 3, 0.3f, true);
        }
        if (definition.equals(YafmConstants.CookedMuttonItemDefinition)) {
            return YafmItemRegistrar.CreateFoodItem(64, 8, 0.8f, true);
        }
        if (definition.equals(YafmConstants.RawSquidItemDefinition)) {
            return YafmItemRegistrar.CreateFoodItem(64, 2, 0.3f, true);
        }
        if (definition.equals(YafmConstants.CookedSquidItemDefinition)) {
            return YafmItemRegistrar.CreateFoodItem(64, 6, 0.6f, true);
        }
        if (definition.equals(YafmConstants.CarrotSoupItemDefinition)) {
            return YafmItemRegistrar.CreateFoodItemInContainer(3, 4, 0.6f, false, Items.field_151054_z);
        }
        return super.CreateItemCore(definition);
    }

    private static Item CreateFoodItem(int maxStackSize, int hungerRestored, float saturationModifier, boolean shouldWolvesEat) {
        ItemFood newFoodItem = new ItemFood(hungerRestored, saturationModifier, shouldWolvesEat);
        newFoodItem.func_77625_d(maxStackSize).func_77637_a(CreativeTabs.field_78039_h);
        return newFoodItem;
    }

    private static Item CreateFoodItemInContainer(int maxServings, int hungerRestored, float saturationModifier, boolean shouldWolvesEat, Item emptyContainer) {
        ItemFoodInContainer newFoodItem = new ItemFoodInContainer(hungerRestored, saturationModifier, shouldWolvesEat, maxServings, emptyContainer);
        newFoodItem.func_77637_a(CreativeTabs.field_78039_h);
        return newFoodItem;
    }
}

