/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.paintbrush.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.ilexiconn.paintbrush.Paintbrush;
import net.ilexiconn.paintbrush.server.item.PaintScraperItem;
import net.ilexiconn.paintbrush.server.item.PaintbrushItem;
import net.ilexiconn.paintbrush.server.message.UpdateSizeMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EventHandlerClient {
    private Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        ItemStack stack;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (event.dwheel != 0 && player != null && player.func_70093_af() && (stack = player.func_71045_bC()) != null) {
            Item item = stack.func_77973_b();
            if (item instanceof PaintbrushItem) {
                int size = PaintbrushItem.getSizeFromDamage(stack);
                if (event.dwheel > 0 && size < 7) {
                    size += event.dwheel / 120;
                } else if (event.dwheel < 0 && size > 1) {
                    size += event.dwheel / 120;
                }
                if (size > 8) {
                    size = 8;
                } else if (size < 1) {
                    size = 1;
                }
                stack.func_77964_b(PaintbrushItem.getDamage(PaintbrushItem.getColorFromDamage(stack), size));
                Paintbrush.networkWrapper.sendToServer((IMessage)new UpdateSizeMessage(stack.func_77960_j()));
                event.setCanceled(true);
            } else if (item instanceof PaintScraperItem) {
                int size = stack.func_77960_j();
                if (event.dwheel > 0 && size < 7) {
                    size += event.dwheel / 120;
                } else if (event.dwheel < 0 && size > 1) {
                    size += event.dwheel / 120;
                }
                if (size > 8) {
                    size = 8;
                } else if (size < 1) {
                    size = 1;
                }
                stack.func_77964_b(size);
                Paintbrush.networkWrapper.sendToServer((IMessage)new UpdateSizeMessage(size));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        ItemStack stack;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (player != null && event.type == RenderGameOverlayEvent.ElementType.HOTBAR && (stack = player.func_71045_bC()) != null) {
            Item item = stack.func_77973_b();
            if (item instanceof PaintbrushItem) {
                PaintbrushItem paintbrush = (PaintbrushItem)item;
                int size = PaintbrushItem.getSizeFromDamage(stack);
                int color = paintbrush.getColorCode(EnumChatFormatting.values()[PaintbrushItem.getColorFromDamage(stack)].func_96298_a(), this.mc.field_71466_p);
                int b = color & 0xFF;
                int g = color >>> 8 & 0xFF;
                int r = color >>> 16 & 0xFF;
                GL11.glPushMatrix();
                GL11.glTranslated((double)16.0, (double)16.0, (double)0.0);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
                GL11.glDisable((int)3553);
                for (int ring = 0; ring < size; ++ring) {
                    for (int i = 0; i < 360; ++i) {
                        double rad = Math.toRadians(i);
                        int pX = (int)(-Math.sin(rad) * (double)ring);
                        int pY = (int)(Math.cos(rad) * (double)ring);
                        this.drawRect(pX, pY, 1, 1);
                    }
                }
                GL11.glEnable((int)3553);
                GL11.glPopMatrix();
            } else if (item instanceof PaintScraperItem) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)16.0, (double)16.0, (double)0.0);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                for (int ring = 0; ring < stack.func_77960_j(); ++ring) {
                    for (int i = 0; i < 360; ++i) {
                        double rad = Math.toRadians(i);
                        int pX = (int)(-Math.sin(rad) * (double)ring);
                        int pY = (int)(Math.cos(rad) * (double)ring);
                        this.drawRect(pX, pY, 1, 1);
                    }
                }
                GL11.glEnable((int)3553);
                GL11.glPopMatrix();
            }
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        float widthScale = 1.0f / (float)width;
        float heightScale = 1.0f / (float)height;
        double zLevel = 1.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), zLevel, (double)(0.0f * widthScale), (double)((float)height * heightScale));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), zLevel, (double)((float)width * widthScale), (double)((float)height * heightScale));
        tessellator.func_78374_a((double)(x + width), (double)y, zLevel, (double)((float)width * widthScale), (double)(0.0f * heightScale));
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)(0.0f * widthScale), (double)(0.0f * heightScale));
        tessellator.func_78381_a();
    }
}

