/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.paintbrush.server.api;

import com.google.common.collect.Lists;
import java.util.List;
import net.ilexiconn.paintbrush.server.entity.PaintedBlockEntity;
import net.ilexiconn.paintbrush.server.util.Paint;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PaintbrushAPI {
    private static List<Block> ignoredBlockList = Lists.newArrayList();
    private static List<Class<?>> ignoredBlockTypeList = Lists.newArrayList();

    public static void registerIgnoredBlock(Block block) {
        ignoredBlockList.add(block);
    }

    public static void registerIgnoredBlockType(Class<?> type) {
        ignoredBlockTypeList.add(type);
    }

    public static boolean isBlockIgnored(Block block) {
        if (!ignoredBlockList.contains(block)) {
            for (Class<?> type : ignoredBlockTypeList) {
                if (!type.isAssignableFrom(block.getClass())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static int addPaint(World world, int x, int y, int z, float hitX, float hitY, float hitZ, EnumFacing facing, EnumChatFormatting color, int radius) {
        int j = 0;
        if (!world.field_72995_K) {
            for (int ring = 0; ring < radius; ++ring) {
                for (int i = 0; i < 360; ++i) {
                    int pY;
                    double rad = Math.toRadians(i);
                    int pX = (int)(-Math.sin(rad) * (double)ring);
                    if (!PaintbrushAPI.addPaint(world, facing, hitX, hitY, hitZ, x, y, z, pX, pY = (int)(Math.cos(rad) * (double)ring), color)) continue;
                    ++j;
                }
            }
        }
        return j;
    }

    public static int removePaint(World world, int x, int y, int z, float hitX, float hitY, float hitZ, EnumFacing facing, int radius) {
        int j = 0;
        if (!world.field_72995_K) {
            for (int ring = 0; ring < radius; ++ring) {
                for (int i = 0; i < 360; ++i) {
                    int pY;
                    double rad = Math.toRadians(i);
                    int pX = (int)(-Math.sin(rad) * (double)ring);
                    if (!PaintbrushAPI.removePaint(world, facing, hitX, hitY, hitZ, x, y, z, pX, pY = (int)(Math.cos(rad) * (double)ring))) continue;
                    ++j;
                }
            }
        }
        return j;
    }

    private static boolean addPaint(World world, EnumFacing facing, float hitX, float hitY, float hitZ, int blockX, int blockY, int blockZ, int paintX, int paintY, EnumChatFormatting color) {
        int blockPaintPosX = (int)(hitX * 16.0f);
        int blockPaintPosY = (int)(hitY * 16.0f);
        int blockPaintPosZ = (int)(hitZ * 16.0f);
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            blockPaintPosX += paintX;
            blockPaintPosZ += paintY;
        } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            blockPaintPosX += paintX;
            blockPaintPosY += paintY;
        } else if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            blockPaintPosZ += paintX;
            blockPaintPosY += paintY;
        }
        int[] offsetsX = PaintbrushAPI.offsetPos(blockPaintPosX, blockX);
        int[] offsetsY = PaintbrushAPI.offsetPos(blockPaintPosY, blockY);
        int[] offsetsZ = PaintbrushAPI.offsetPos(blockPaintPosZ, blockZ);
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            blockX = offsetsX[0];
            blockZ = offsetsZ[0];
            blockPaintPosX = offsetsX[1];
            blockPaintPosZ = offsetsZ[1];
        } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            blockX = offsetsX[0];
            blockY = offsetsY[0];
            blockPaintPosX = offsetsX[1];
            blockPaintPosY = offsetsY[1];
        } else if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            blockZ = offsetsZ[0];
            blockY = offsetsY[0];
            blockPaintPosY = offsetsY[1];
            blockPaintPosZ = offsetsZ[1];
        }
        PaintedBlockEntity paintedBlock = PaintbrushAPI.getPaintEntity(world, blockX, blockY, blockZ, true);
        if (paintedBlock.canStay()) {
            int offsetX = 0;
            int offsetY = 0;
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                offsetX = blockPaintPosX;
                offsetY = blockPaintPosZ;
            } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                offsetX = blockPaintPosX;
                offsetY = blockPaintPosY;
            } else if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
                offsetX = blockPaintPosZ;
                offsetY = blockPaintPosY;
            }
            Paint paint = new Paint(facing, offsetX, offsetY, color);
            return paintedBlock.addPaint(paint);
        }
        return false;
    }

    private static boolean removePaint(World world, EnumFacing facing, float hitX, float hitY, float hitZ, int blockX, int blockY, int blockZ, int paintX, int paintY) {
        int blockPaintPosX = (int)(hitX * 16.0f);
        int blockPaintPosY = (int)(hitY * 16.0f);
        int blockPaintPosZ = (int)(hitZ * 16.0f);
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            blockPaintPosX += paintX;
            blockPaintPosZ += paintY;
        } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            blockPaintPosX += paintX;
            blockPaintPosY += paintY;
        } else if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            blockPaintPosZ += paintX;
            blockPaintPosY += paintY;
        }
        int[] offsetsX = PaintbrushAPI.offsetPos(blockPaintPosX, blockX);
        int[] offsetsY = PaintbrushAPI.offsetPos(blockPaintPosY, blockY);
        int[] offsetsZ = PaintbrushAPI.offsetPos(blockPaintPosZ, blockZ);
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            blockX = offsetsX[0];
            blockZ = offsetsZ[0];
            blockPaintPosX = offsetsX[1];
            blockPaintPosZ = offsetsZ[1];
        } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            blockX = offsetsX[0];
            blockY = offsetsY[0];
            blockPaintPosX = offsetsX[1];
            blockPaintPosY = offsetsY[1];
        } else if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            blockZ = offsetsZ[0];
            blockY = offsetsY[0];
            blockPaintPosY = offsetsY[1];
            blockPaintPosZ = offsetsZ[1];
        }
        PaintedBlockEntity paintedBlock = PaintbrushAPI.getPaintEntity(world, blockX, blockY, blockZ, false);
        if (paintedBlock != null) {
            int offsetX = 0;
            int offsetY = 0;
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                offsetX = blockPaintPosX;
                offsetY = blockPaintPosZ;
            } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                offsetX = blockPaintPosX;
                offsetY = blockPaintPosY;
            } else if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
                offsetX = blockPaintPosZ;
                offsetY = blockPaintPosY;
            }
            return paintedBlock.removePaint(offsetX, offsetY, facing);
        }
        return false;
    }

    private static PaintedBlockEntity getPaintEntity(World world, int x, int y, int z, boolean createNew) {
        PaintedBlockEntity paintedBlock = null;
        for (Object entity : world.field_72996_f) {
            if (!(entity instanceof PaintedBlockEntity)) continue;
            PaintedBlockEntity paintedBlockEntity = (PaintedBlockEntity)((Object)entity);
            if (paintedBlockEntity.blockX != x || paintedBlockEntity.blockY != y || paintedBlockEntity.blockZ != z) continue;
            paintedBlock = paintedBlockEntity;
            break;
        }
        if (paintedBlock == null && createNew) {
            paintedBlock = new PaintedBlockEntity(world);
            paintedBlock.blockX = x;
            paintedBlock.blockY = y;
            paintedBlock.blockZ = z;
            paintedBlock.func_70080_a((float)x + 0.5f, y, (float)z + 0.5f, 0.0f, 0.0f);
            world.func_72838_d((Entity)paintedBlock);
        }
        return paintedBlock;
    }

    private static int[] offsetPos(int paintPos, int blockPos) {
        if (paintPos > 15) {
            paintPos %= 16;
        } else if (paintPos < 0) {
            paintPos %= 16;
            paintPos += 16;
            --blockPos;
        }
        return new int[]{++blockPos, paintPos};
    }
}

