/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.paintbrush.server.entity;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.paintbrush.Paintbrush;
import net.ilexiconn.paintbrush.server.api.PaintbrushAPI;
import net.ilexiconn.paintbrush.server.message.AddPaintMessage;
import net.ilexiconn.paintbrush.server.message.RemovePaintMessage;
import net.ilexiconn.paintbrush.server.util.Paint;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PaintedBlockEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public List<Paint> paintList = Lists.newArrayList();
    public int blockX;
    public int blockY;
    public int blockZ;

    public PaintedBlockEntity(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
    }

    public boolean addPaint(Paint paint) {
        for (Paint p : this.paintList) {
            if (p.posX != paint.posX || p.posY != paint.posY || p.facing != paint.facing) continue;
            return false;
        }
        AxisAlignedBB bounds = this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ).func_149633_g(this.field_70170_p, this.blockX, this.blockY, this.blockZ);
        if (paint.facing != EnumFacing.UP && paint.facing != EnumFacing.DOWN && (double)paint.posY > (bounds.field_72337_e - this.field_70163_u) * 16.0 - 1.0) {
            return false;
        }
        this.paintList.add(paint);
        Paintbrush.networkWrapper.sendToAll((IMessage)new AddPaintMessage(this, paint));
        return true;
    }

    public boolean removePaint(int x, int y, EnumFacing facing) {
        Paint toRemove = null;
        for (Paint paint : this.paintList) {
            if (paint.posX != x || paint.posY != y || paint.facing != facing) continue;
            toRemove = paint;
            break;
        }
        if (toRemove != null) {
            this.paintList.remove(toRemove);
            Paintbrush.networkWrapper.sendToAll((IMessage)new RemovePaintMessage(this, toRemove));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForFace(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return this.field_70170_p.func_72802_i(this.blockX, this.blockY, this.blockZ - 1, 0);
            }
            case SOUTH: {
                return this.field_70170_p.func_72802_i(this.blockX, this.blockY, this.blockZ + 1, 0);
            }
            case EAST: {
                return this.field_70170_p.func_72802_i(this.blockX - 1, this.blockY, this.blockZ, 0);
            }
            case WEST: {
                return this.field_70170_p.func_72802_i(this.blockX + 1, this.blockY, this.blockZ, 0);
            }
            case UP: {
                return this.field_70170_p.func_72802_i(this.blockX, this.blockY + 1, this.blockZ, 0);
            }
            case DOWN: {
                return this.field_70170_p.func_72802_i(this.blockX, this.blockY - 1, this.blockZ, 0);
            }
        }
        return 0;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (!this.canStay()) {
            this.func_70106_y();
        } else if (this.paintList.isEmpty()) {
            this.func_70106_y();
        }
        ArrayList toRemove = Lists.newArrayList();
        for (Paint paint : this.paintList) {
            if (!this.field_70170_p.func_147437_c(this.blockX, this.blockY + 1, this.blockZ) && !PaintbrushAPI.isBlockIgnored(this.field_70170_p.func_147439_a(this.blockX, this.blockY + 1, this.blockZ)) && paint.facing == EnumFacing.UP) {
                toRemove.add(paint);
                continue;
            }
            if (!this.field_70170_p.func_147437_c(this.blockX, this.blockY - 1, this.blockZ) && !PaintbrushAPI.isBlockIgnored(this.field_70170_p.func_147439_a(this.blockX, this.blockY - 1, this.blockZ)) && paint.facing == EnumFacing.DOWN) {
                toRemove.add(paint);
                continue;
            }
            if (!this.field_70170_p.func_147437_c(this.blockX + 1, this.blockY, this.blockZ) && !PaintbrushAPI.isBlockIgnored(this.field_70170_p.func_147439_a(this.blockX + 1, this.blockY, this.blockZ)) && paint.facing == EnumFacing.WEST) {
                toRemove.add(paint);
                continue;
            }
            if (!this.field_70170_p.func_147437_c(this.blockX - 1, this.blockY, this.blockZ) && !PaintbrushAPI.isBlockIgnored(this.field_70170_p.func_147439_a(this.blockX - 1, this.blockY, this.blockZ)) && paint.facing == EnumFacing.EAST) {
                toRemove.add(paint);
                continue;
            }
            if (!this.field_70170_p.func_147437_c(this.blockX, this.blockY, this.blockZ - 1) && !PaintbrushAPI.isBlockIgnored(this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ - 1)) && paint.facing == EnumFacing.NORTH) {
                toRemove.add(paint);
                continue;
            }
            if (this.field_70170_p.func_147437_c(this.blockX, this.blockY, this.blockZ + 1) || PaintbrushAPI.isBlockIgnored(this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ + 1)) || paint.facing != EnumFacing.SOUTH) continue;
            toRemove.add(paint);
        }
        this.paintList.removeAll(toRemove);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.blockX = compound.func_74762_e("BlockX");
        this.blockY = compound.func_74762_e("BlockY");
        this.blockZ = compound.func_74762_e("BlockZ");
        this.paintList = Lists.newArrayList();
        int size = compound.func_74762_e("Size");
        NBTTagList list = compound.func_150295_c("Paint", 10);
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            Paint paint = Paint.readFromNBT(tag);
            this.paintList.add(paint);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("BlockX", this.blockX);
        compound.func_74768_a("BlockY", this.blockY);
        compound.func_74768_a("BlockZ", this.blockZ);
        compound.func_74768_a("Size", this.paintList.size());
        NBTTagList list = new NBTTagList();
        for (Paint paint : this.paintList) {
            NBTTagCompound tag = new NBTTagCompound();
            paint.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Paint", (NBTBase)list);
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.blockX);
        buf.writeInt(this.blockY);
        buf.writeInt(this.blockZ);
        buf.writeInt(this.paintList.size());
        for (Paint paint : this.paintList) {
            paint.encode(buf);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        this.blockX = buf.readInt();
        this.blockY = buf.readInt();
        this.blockZ = buf.readInt();
        this.paintList = Lists.newArrayList();
        int paintListSize = buf.readInt();
        for (int i = 0; i < paintListSize; ++i) {
            Paint paint = Paint.decode(buf);
            this.paintList.add(paint);
        }
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
    }

    public boolean canStay() {
        return !this.field_70170_p.func_147437_c(this.blockX, this.blockY, this.blockZ) && !PaintbrushAPI.isBlockIgnored(this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ)) && !this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ).func_149688_o().func_76224_d();
    }
}

