/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.paintbrush.server.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.ilexiconn.paintbrush.Paintbrush;
import net.ilexiconn.paintbrush.server.api.PaintbrushAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class PaintbrushItem
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon colorOverlay;

    public PaintbrushItem() {
        this.func_77655_b("paintbrush");
        this.func_77637_a(Paintbrush.creativeTab);
        this.func_111206_d("paintbrush:paintbrush");
        this.func_77625_d(1);
    }

    public static int getColorFromDamage(ItemStack stack) {
        return stack.func_77960_j() & 0xF;
    }

    public static int getSizeFromDamage(ItemStack stack) {
        return stack.func_77960_j() >>> 4 & 7;
    }

    public static int getDamage(int color, int size) {
        return color & 0xF | size << 4;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.colorOverlay = iconRegister.func_94245_a("paintbrush:paintbrush_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        return pass == 0 ? this.field_77791_bV : this.colorOverlay;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass != 0) {
            EnumChatFormatting color = EnumChatFormatting.values()[PaintbrushItem.getColorFromDamage(stack)];
            return this.getColorCode(color.func_96298_a(), Minecraft.func_71410_x().field_71466_p);
        }
        return 0xFFFFFF;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int face, float hitX, float hitY, float hitZ) {
        EnumChatFormatting color = EnumChatFormatting.values()[PaintbrushItem.getColorFromDamage(stack)];
        EnumFacing facing = EnumFacing.values()[face];
        int size = PaintbrushItem.getSizeFromDamage(stack);
        PaintbrushAPI.addPaint(world, x, y, z, hitX, hitY, hitZ, facing, color, size);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean advancedTooltips) {
        EnumChatFormatting color = EnumChatFormatting.values()[PaintbrushItem.getColorFromDamage(stack)];
        info.add(StatCollector.func_74838_a((String)"tooltip.paintbrush.color") + ": " + color + StatCollector.func_74838_a((String)("color." + color.func_96297_d() + ".name")));
        info.add(StatCollector.func_74838_a((String)"tooltip.paintbrush.size") + ": " + PaintbrushItem.getSizeFromDamage(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List items) {
        for (int i = 0; i < 16; ++i) {
            items.add(new ItemStack(item, 1, PaintbrushItem.getDamage(i, 1)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorCode(char character, FontRenderer fontRenderer) {
        return fontRenderer.field_78285_g["0123456789abcdef".indexOf(character)];
    }
}

