/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.paintbrush.server.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;

public class Paint {
    public EnumFacing facing;
    public int posX;
    public int posY;
    public EnumChatFormatting color;

    public Paint(EnumFacing facing, int posX, int posY, EnumChatFormatting color) {
        this.facing = facing;
        this.posX = posX;
        this.posY = posY;
        this.color = color;
    }

    public static Paint readFromNBT(NBTTagCompound compound) {
        EnumFacing facing = EnumFacing.values()[compound.func_74762_e("Facing")];
        int posX = compound.func_74762_e("PosX");
        int posY = compound.func_74762_e("PosY");
        EnumChatFormatting color = EnumChatFormatting.values()[compound.func_74762_e("Color")];
        return new Paint(facing, posX, posY, color);
    }

    public static Paint decode(ByteBuf buf) {
        int data = buf.readInt();
        EnumFacing facing = EnumFacing.values()[data & 7];
        int posX = data >>> 3 & 0xF;
        int posY = data >>> 7 & 0xF;
        EnumChatFormatting color = EnumChatFormatting.values()[data >>> 11 & 0xF];
        return new Paint(facing, posX, posY, color);
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("Facing", this.facing.ordinal());
        compound.func_74768_a("PosX", this.posX);
        compound.func_74768_a("PosY", this.posY);
        compound.func_74768_a("Color", this.color.ordinal());
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.facing.ordinal() & 7 | (this.posX & 0xF) << 3 | (this.posY & 0xF) << 7 | (this.color.ordinal() & 0xF) << 11);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Paint) {
            Paint paint = (Paint)obj;
            return paint.facing == this.facing && paint.posX == this.posX && paint.posY == this.posY && paint.color == this.color;
        }
        return false;
    }
}

