/*
 * Decompiled with CFR 0.152.
 */
package com.subway;

import com.subway.SubRenderingHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SubRenderingRegistry {
    static Map<String, SubRenderingHandler> renderers = new HashMap<String, SubRenderingHandler>();

    public static SubRenderingHandler getRenderingHandlerFor(String itemName) {
        if (renderers.containsKey(itemName)) {
            return renderers.get(itemName);
        }
        return new SubRenderingHandler(){

            @Override
            public ModelBase getModel(List<ItemStack> itemStackList, int indexInList, NBTTagCompound compound) {
                return null;
            }

            @Override
            public double getModelHeight(List<ItemStack> itemStackList, int indexInList, NBTTagCompound compound) {
                return 0.0455;
            }
        };
    }

    public static SubRenderingHandler getRenderingHandlerFor(ItemStack item) {
        String key = GameRegistry.findUniqueIdentifierFor((Item)item.func_77973_b()).toString();
        return SubRenderingRegistry.getRenderingHandlerFor(key);
    }

    public static void registerRenderingHandler(String itemName, SubRenderingHandler renderingHandler) {
        if (!renderers.containsKey(itemName)) {
            renderers.put(itemName, renderingHandler);
        }
    }

    public static void registerRenderingHandler(Item item, SubRenderingHandler renderingHandler) {
        SubRenderingRegistry.registerRenderingHandler(GameRegistry.findUniqueIdentifierFor((Item)item).toString(), renderingHandler);
    }

    public static void registerRenderingHandler(Block block, SubRenderingHandler renderingHandler) {
        SubRenderingRegistry.registerRenderingHandler(GameRegistry.findUniqueIdentifierFor((Block)block).toString(), renderingHandler);
    }
}

