/*
 * Decompiled with CFR 0.152.
 */
package com.subway.init;

import com.subway.init.TileInventorySmelter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerInventorySmelter
extends Container {
    private TileInventorySmelter tileInventoryFurnace;
    private int[] cachedFields;
    private final int HOTBAR_SLOT_COUNT = 9;
    private final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private final int VANILLA_SLOT_COUNT = 36;
    public final int FUEL_SLOTS_COUNT = 4;
    public final int INPUT_SLOTS_COUNT = 5;
    public final int OUTPUT_SLOTS_COUNT = 5;
    public final int FURNACE_SLOTS_COUNT = 14;
    private final int VANILLA_FIRST_SLOT_INDEX = 0;
    private final int FIRST_FUEL_SLOT_INDEX = 36;
    private final int FIRST_INPUT_SLOT_INDEX = 40;
    private final int FIRST_OUTPUT_SLOT_INDEX = 45;
    private final int FIRST_FUEL_SLOT_NUMBER = 0;
    private final int FIRST_INPUT_SLOT_NUMBER = 4;
    private final int FIRST_OUTPUT_SLOT_NUMBER = 9;

    public ContainerInventorySmelter(InventoryPlayer invPlayer, TileInventorySmelter tileInventoryFurnace) {
        this.tileInventoryFurnace = tileInventoryFurnace;
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 183;
        for (int x = 0; x < 9; ++x) {
            int slotNumber = x;
            this.func_75146_a(new Slot((IInventory)invPlayer, slotNumber, 8 + 18 * x, 183));
        }
        int PLAYER_INVENTORY_XPOS = 8;
        int PLAYER_INVENTORY_YPOS = 125;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 125 + y * 18;
                this.func_75146_a(new Slot((IInventory)invPlayer, slotNumber, xpos, ypos));
            }
        }
        int FUEL_SLOTS_XPOS = 53;
        int FUEL_SLOTS_YPOS = 96;
        for (int x = 0; x < 4; ++x) {
            int slotNumber = x + 0;
            this.func_75146_a(new SlotFuel(tileInventoryFurnace, slotNumber, 53 + 18 * x, 96));
        }
        int INPUT_SLOTS_XPOS = 26;
        int INPUT_SLOTS_YPOS = 24;
        for (int y = 0; y < 5; ++y) {
            int slotNumber = y + 4;
            this.func_75146_a(new SlotSmeltableInput(tileInventoryFurnace, slotNumber, 26, 24 + 18 * y));
        }
        int OUTPUT_SLOTS_XPOS = 134;
        int OUTPUT_SLOTS_YPOS = 24;
        for (int y = 0; y < 5; ++y) {
            int slotNumber = y + 9;
            this.func_75146_a(new SlotOutput(tileInventoryFurnace, slotNumber, 134, 24 + 18 * y));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileInventoryFurnace.func_70300_a(player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(EntityPlayer player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return null;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (sourceSlotIndex >= 0 && sourceSlotIndex < 36) {
            if (TileInventorySmelter.getSmeltingResultForItem(sourceStack) != null) {
                if (!this.func_75135_a(sourceStack, 40, 45, false)) {
                    return null;
                }
            } else {
                if (TileInventorySmelter.getItemBurnTime(sourceStack) <= 0) return null;
                if (!this.func_75135_a(sourceStack, 36, 40, true)) {
                    return null;
                }
            }
        } else if (sourceSlotIndex >= 36 && sourceSlotIndex < 50) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return null;
            }
        } else {
            System.err.print("Invalid slotIndex:" + sourceSlotIndex);
            return null;
        }
        if (sourceStack.field_77994_a == 0) {
            sourceSlot.func_75215_d(null);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_82870_a(player, sourceStack);
        return copyOfSourceStack;
    }

    public void func_75142_b() {
        int i;
        super.func_75142_b();
        boolean allFieldsHaveChanged = false;
        boolean[] fieldHasChanged = new boolean[this.tileInventoryFurnace.func_174890_g()];
        if (this.cachedFields == null) {
            this.cachedFields = new int[this.tileInventoryFurnace.func_174890_g()];
            allFieldsHaveChanged = true;
        }
        for (i = 0; i < this.cachedFields.length; ++i) {
            if (!allFieldsHaveChanged && this.cachedFields[i] == this.tileInventoryFurnace.func_174887_a_(i)) continue;
            this.cachedFields[i] = this.tileInventoryFurnace.func_174887_a_(i);
            fieldHasChanged[i] = true;
        }
        for (i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            for (int fieldID = 0; fieldID < this.tileInventoryFurnace.func_174890_g(); ++fieldID) {
                if (!fieldHasChanged[fieldID]) continue;
                icrafting.func_71112_a((Container)this, fieldID, this.cachedFields[fieldID]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.tileInventoryFurnace.func_174885_b(id, data);
    }

    public class SlotOutput
    extends Slot {
        public SlotOutput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return TileInventorySmelter.isItemValidForOutputSlot(stack);
        }
    }

    public class SlotSmeltableInput
    extends Slot {
        public SlotSmeltableInput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return TileInventorySmelter.isItemValidForInputSlot(stack);
        }
    }

    public class SlotFuel
    extends Slot {
        public SlotFuel(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return TileInventorySmelter.isItemValidForFuelSlot(stack);
        }
    }
}

