/*
 * Decompiled with CFR 0.152.
 */
package com.subway.init;

import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;

public class TileInventorySmelter
extends TileEntity
implements IInventory,
IUpdatePlayerListBox {
    public static final int FUEL_SLOTS_COUNT = 4;
    public static final int INPUT_SLOTS_COUNT = 5;
    public static final int OUTPUT_SLOTS_COUNT = 5;
    public static final int TOTAL_SLOTS_COUNT = 14;
    public static final int FIRST_FUEL_SLOT = 0;
    public static final int FIRST_INPUT_SLOT = 4;
    public static final int FIRST_OUTPUT_SLOT = 9;
    private ItemStack[] itemStacks = new ItemStack[14];
    private int[] burnTimeRemaining = new int[4];
    private int[] burnTimeInitialValue = new int[4];
    private short cookTime;
    private static final short COOK_TIME_FOR_COMPLETION = 200;
    private int cachedNumberOfBurningSlots = -1;
    private static final byte COOK_FIELD_ID = 0;
    private static final byte FIRST_BURN_TIME_REMAINING_FIELD_ID = 1;
    private static final byte FIRST_BURN_TIME_INITIAL_FIELD_ID = 5;
    private static final byte NUMBER_OF_FIELDS = 9;

    public double fractionOfFuelRemaining(int fuelSlot) {
        if (this.burnTimeInitialValue[fuelSlot] <= 0) {
            return 0.0;
        }
        double fraction = (double)this.burnTimeRemaining[fuelSlot] / (double)this.burnTimeInitialValue[fuelSlot];
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    public int secondsOfFuelRemaining(int fuelSlot) {
        if (this.burnTimeRemaining[fuelSlot] <= 0) {
            return 0;
        }
        return this.burnTimeRemaining[fuelSlot] / 20;
    }

    public int numberOfBurningFuelSlots() {
        int burningCount = 0;
        for (int burnTime : this.burnTimeRemaining) {
            if (burnTime <= 0) continue;
            ++burningCount;
        }
        return burningCount;
    }

    public double fractionOfCookTimeComplete() {
        double fraction = (double)this.cookTime / 200.0;
        return MathHelper.func_151237_a((double)fraction, (double)0.0, (double)1.0);
    }

    public void func_73660_a() {
        if (this.canSmelt()) {
            int numberOfFuelBurning = this.burnFuel();
            this.cookTime = numberOfFuelBurning > 0 ? (short)(this.cookTime + numberOfFuelBurning) : (short)(this.cookTime - 2);
            if (this.cookTime < 0) {
                this.cookTime = 0;
            }
            if (this.cookTime >= 200) {
                this.smeltItem();
                this.cookTime = 0;
            }
        } else {
            this.cookTime = 0;
        }
        int numberBurning = this.numberOfBurningFuelSlots();
        if (this.cachedNumberOfBurningSlots != numberBurning) {
            this.cachedNumberOfBurningSlots = numberBurning;
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175689_h(this.field_174879_c);
            }
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    private int burnFuel() {
        int burningCount = 0;
        boolean inventoryChanged = false;
        for (int i = 0; i < 4; ++i) {
            int fuelSlotNumber = i + 0;
            if (this.burnTimeRemaining[i] > 0) {
                int n = i;
                this.burnTimeRemaining[n] = this.burnTimeRemaining[n] - 1;
                ++burningCount;
            }
            if (this.burnTimeRemaining[i] != 0 || this.itemStacks[fuelSlotNumber] == null || TileInventorySmelter.getItemBurnTime(this.itemStacks[fuelSlotNumber]) <= 0) continue;
            short s = TileInventorySmelter.getItemBurnTime(this.itemStacks[fuelSlotNumber]);
            this.burnTimeInitialValue[i] = s;
            this.burnTimeRemaining[i] = s;
            --this.itemStacks[fuelSlotNumber].field_77994_a;
            ++burningCount;
            inventoryChanged = true;
            if (this.itemStacks[fuelSlotNumber].field_77994_a != 0) continue;
            this.itemStacks[fuelSlotNumber] = this.itemStacks[fuelSlotNumber].func_77973_b().getContainerItem(this.itemStacks[fuelSlotNumber]);
        }
        if (inventoryChanged) {
            this.func_70296_d();
        }
        return burningCount;
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        Integer firstSuitableInputSlot = null;
        Integer firstSuitableOutputSlot = null;
        ItemStack result = null;
        for (int inputSlot = 4; inputSlot < 9; ++inputSlot) {
            if (this.itemStacks[inputSlot] == null || (result = TileInventorySmelter.getSmeltingResultForItem(this.itemStacks[inputSlot])) == null) continue;
            for (int outputSlot = 9; outputSlot < 14; ++outputSlot) {
                int combinedSize;
                ItemStack outputStack = this.itemStacks[outputSlot];
                if (outputStack == null) {
                    firstSuitableInputSlot = inputSlot;
                    firstSuitableOutputSlot = outputSlot;
                    break;
                }
                if (outputStack.func_77973_b() != result.func_77973_b() || outputStack.func_77981_g() && outputStack.func_77960_j() != outputStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)result) || (combinedSize = this.itemStacks[outputSlot].field_77994_a + result.field_77994_a) > this.func_70297_j_() || combinedSize > this.itemStacks[outputSlot].func_77976_d()) continue;
                firstSuitableInputSlot = inputSlot;
                firstSuitableOutputSlot = outputSlot;
                break;
            }
            if (firstSuitableInputSlot != null) break;
        }
        if (firstSuitableInputSlot == null) {
            return false;
        }
        if (!performSmelt) {
            return true;
        }
        --this.itemStacks[firstSuitableInputSlot.intValue()].field_77994_a;
        if (this.itemStacks[firstSuitableInputSlot.intValue()].field_77994_a <= 0) {
            this.itemStacks[firstSuitableInputSlot.intValue()] = null;
        }
        if (this.itemStacks[firstSuitableOutputSlot] == null) {
            this.itemStacks[firstSuitableOutputSlot.intValue()] = result.func_77946_l();
        } else {
            this.itemStacks[firstSuitableOutputSlot.intValue()].field_77994_a += result.field_77994_a;
        }
        this.func_70296_d();
        return true;
    }

    public static ItemStack getSmeltingResultForItem(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    public static short getItemBurnTime(ItemStack stack) {
        int burntime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return (short)MathHelper.func_76125_a((int)burntime, (int)0, (int)Short.MAX_VALUE);
    }

    public int func_70302_i_() {
        return this.itemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.itemStacks[i];
    }

    public ItemStack func_70298_a(int slotIndex, int count) {
        ItemStack itemStackRemoved;
        ItemStack itemStackInSlot = this.func_70301_a(slotIndex);
        if (itemStackInSlot == null) {
            return null;
        }
        if (itemStackInSlot.field_77994_a <= count) {
            itemStackRemoved = itemStackInSlot;
            this.func_70299_a(slotIndex, null);
        } else {
            itemStackRemoved = itemStackInSlot.func_77979_a(count);
            if (itemStackInSlot.field_77994_a == 0) {
                this.func_70299_a(slotIndex, null);
            }
        }
        this.func_70296_d();
        return itemStackRemoved;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.itemStacks[slotIndex] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double X_CENTRE_OFFSET = 0.5;
        double Y_CENTRE_OFFSET = 0.5;
        double Z_CENTRE_OFFSET = 0.5;
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public static boolean isItemValidForFuelSlot(ItemStack itemStack) {
        return true;
    }

    public static boolean isItemValidForInputSlot(ItemStack itemStack) {
        return true;
    }

    public static boolean isItemValidForOutputSlot(ItemStack itemStack) {
        return false;
    }

    public void func_145841_b(NBTTagCompound parentNBTTagCompound) {
        super.func_145841_b(parentNBTTagCompound);
        NBTTagList dataForAllSlots = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound dataForThisSlot = new NBTTagCompound();
            dataForThisSlot.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(dataForThisSlot);
            dataForAllSlots.func_74742_a((NBTBase)dataForThisSlot);
        }
        parentNBTTagCompound.func_74782_a("Items", (NBTBase)dataForAllSlots);
        parentNBTTagCompound.func_74777_a("CookTime", this.cookTime);
        parentNBTTagCompound.func_74782_a("burnTimeRemaining", (NBTBase)new NBTTagIntArray(this.burnTimeRemaining));
        parentNBTTagCompound.func_74782_a("burnTimeInitial", (NBTBase)new NBTTagIntArray(this.burnTimeInitialValue));
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        int NBT_TYPE_COMPOUND = 10;
        NBTTagList dataForAllSlots = nbtTagCompound.func_150295_c("Items", 10);
        Arrays.fill(this.itemStacks, null);
        for (int i = 0; i < dataForAllSlots.func_74745_c(); ++i) {
            NBTTagCompound dataForOneSlot = dataForAllSlots.func_150305_b(i);
            byte slotNumber = dataForOneSlot.func_74771_c("Slot");
            if (slotNumber < 0 || slotNumber >= this.itemStacks.length) continue;
            this.itemStacks[slotNumber] = ItemStack.func_77949_a((NBTTagCompound)dataForOneSlot);
        }
        this.cookTime = nbtTagCompound.func_74765_d("CookTime");
        this.burnTimeRemaining = Arrays.copyOf(nbtTagCompound.func_74759_k("burnTimeRemaining"), 4);
        this.burnTimeInitialValue = Arrays.copyOf(nbtTagCompound.func_74759_k("burnTimeInitial"), 4);
        this.cachedNumberOfBurningSlots = -1;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        boolean METADATA = false;
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_174888_l() {
        Arrays.fill(this.itemStacks, null);
    }

    public String func_70005_c_() {
        return "Trinia Smelter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return this.func_145818_k_() ? new ChatComponentText(this.func_70005_c_()) : new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.cookTime;
        }
        if (id >= 1 && id < 5) {
            return this.burnTimeRemaining[id - 1];
        }
        if (id >= 5 && id < 9) {
            return this.burnTimeInitialValue[id - 5];
        }
        System.err.println("Invalid field ID in TileInventorySmelting.getField:" + id);
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.cookTime = (short)value;
        } else if (id >= 1 && id < 5) {
            this.burnTimeRemaining[id - 1] = value;
        } else if (id >= 5 && id < 9) {
            this.burnTimeInitialValue[id - 5] = value;
        } else {
            System.err.println("Invalid field ID in TileInventorySmelting.setField:" + id);
        }
    }

    public int func_174890_g() {
        return 9;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return false;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            this.func_70299_a(slotIndex, null);
        }
        return itemStack;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }
}

