/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.config;

import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.minetunes.config.CacheHelper;
import vazkii.minetunes.gui.GuiDevTools;

public final class MTConfig {
    private static final String CONFIG_FILE = "config.dat";
    private static final String TAG_PLAY_MODE = "playMode";
    private static final String TAG_HUD_ENABLED = "hudEnabled";
    private static final String TAG_HUD_RELATIVE_TO = "hudRelativeTo";
    private static final String TAG_HUD_POS_X = "hudPosX";
    private static final String TAG_HUD_POS_Y = "hudPosY";
    public static int playMode = 0;
    public static boolean hudEnabled = true;
    public static int hudRelativeTo = 0;
    public static int hudPosX = 0;
    public static int hudPosY = 0;

    public static void findCompoundAndLoad() {
        try {
            File file = CacheHelper.getCacheFile(CONFIG_FILE);
            NBTTagCompound cmp = CacheHelper.getCacheCompound(file);
            if (cmp.func_82582_d()) {
                MTConfig.findCompoundAndWrite(file);
            } else {
                playMode = cmp.func_74762_e(TAG_PLAY_MODE);
                hudEnabled = cmp.func_74767_n(TAG_HUD_ENABLED);
                hudRelativeTo = cmp.func_74762_e(TAG_HUD_RELATIVE_TO);
                hudPosX = cmp.func_74762_e(TAG_HUD_POS_X);
                hudPosY = cmp.func_74762_e(TAG_HUD_POS_Y);
            }
        }
        catch (IOException e) {
            GuiDevTools.logThrowable(e);
        }
    }

    public static void findCompoundAndWrite() {
        try {
            MTConfig.findCompoundAndWrite(CacheHelper.getCacheFile(CONFIG_FILE));
        }
        catch (IOException e) {
            GuiDevTools.logThrowable(e);
        }
    }

    public static void findCompoundAndWrite(File f) {
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74768_a(TAG_PLAY_MODE, playMode);
        cmp.func_74757_a(TAG_HUD_ENABLED, hudEnabled);
        cmp.func_74768_a(TAG_HUD_RELATIVE_TO, hudRelativeTo);
        cmp.func_74768_a(TAG_HUD_POS_X, hudPosX);
        cmp.func_74768_a(TAG_HUD_POS_Y, hudPosY);
        CacheHelper.injectNBTToFile(f, cmp);
    }
}

