/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.player;

import java.awt.Color;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import vazkii.minetunes.MineTunes;
import vazkii.minetunes.config.MTConfig;
import vazkii.minetunes.gui.GuiMoveHUD;
import vazkii.minetunes.player.SpectrumTools;
import vazkii.minetunes.playlist.MP3Metadata;

public final class HUDHandler {
    public static boolean showVolume = false;
    private float[] oldFFT = new float[16];

    @SubscribeEvent
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL && MTConfig.hudEnabled) {
            Minecraft mc = Minecraft.func_71410_x();
            int width = event.resolution.func_78326_a();
            int height = event.resolution.func_78328_b();
            Point coords = HUDHandler.getCoords(width, height, MTConfig.hudRelativeTo, MTConfig.hudPosX, MTConfig.hudPosY);
            if (MineTunes.musicPlayerThread != null && MineTunes.musicPlayerThread.player != null && MineTunes.musicPlayerThread.playingMP3 != null) {
                int textLeft;
                MP3Metadata meta = MineTunes.musicPlayerThread.playingMP3;
                boolean rightSide = MTConfig.hudRelativeTo == 0 || MTConfig.hudRelativeTo == 3;
                String note = MineTunes.musicPlayerThread.paused ? "\u258e\u258e" : "\u266c";
                int noteWidth = mc.field_71466_p.func_78256_a(note) * 2;
                int noteSpace = 4;
                String time = MP3Metadata.getLengthStr((int)((double)meta.lengthMs - (double)meta.lengthMs * (double)MineTunes.musicPlayerThread.getFractionPlayed()));
                String title = meta.title + " (" + time + ")";
                String artist = meta.artist;
                String volume = showVolume ? String.format(StatCollector.func_74838_a((String)"minetunes.gui.volume"), "+" + (int)(MineTunes.musicPlayerThread.getRelativeVolume() * 100.0f) + "%") : "";
                int padding = 4;
                int titleWidth = mc.field_71466_p.func_78256_a(title);
                int artistWidth = mc.field_71466_p.func_78256_a(artist);
                int volumeWidth = mc.field_71466_p.func_78256_a(volume);
                int textWidth = Math.max(titleWidth, Math.max(artistWidth, volumeWidth));
                int hudWidth = textWidth + noteWidth + noteSpace + padding * 2;
                int hudHeight = (showVolume ? 30 : 20) + padding * 2;
                int x = coords.x;
                int y = coords.y;
                if (rightSide) {
                    x -= hudWidth;
                }
                if (x < 0) {
                    x = padding;
                }
                if (y < 0) {
                    y = 0;
                }
                int xf = x + hudWidth;
                int yf = y + hudHeight;
                if (xf > width) {
                    x -= xf - width;
                }
                if (yf > height) {
                    y -= yf - height;
                }
                Color color = Color.getHSBColor((float)(System.currentTimeMillis() % 5000L) / 5000.0f, 1.0f, 1.0f);
                int noteX = x + padding + (rightSide ? textWidth + noteSpace : 0);
                int noteY = y + padding;
                int noteColor = color.getRGB();
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                GL11.glTranslatef((float)((float)noteX / 2.0f), (float)((float)noteY / 2.0f), (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
                mc.field_71466_p.func_78276_b(note, 0, 0, color.darker().darker().getRGB());
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
                mc.field_71466_p.func_78276_b(note, 0, 0, noteColor);
                GL11.glPopMatrix();
                int diffTitle = 0;
                int diffArtist = 0;
                int diffVolume = 0;
                int spectrumLeft = textLeft = x + padding + (rightSide ? 0 : noteWidth + noteSpace);
                if (rightSide) {
                    diffTitle = textWidth - titleWidth;
                    diffArtist = textWidth - artistWidth;
                    diffVolume = textWidth - volumeWidth;
                }
                int spaceWidth = 15;
                int minWidth = 32 + spaceWidth;
                int analyzerWidth = Math.max(minWidth, textWidth * 2 - spaceWidth);
                this.renderSpectrumAnalyzer(mc, textLeft, y + padding + 20, analyzerWidth, 150, noteColor);
                mc.field_71466_p.func_175063_a(title, (float)(textLeft + diffTitle), (float)(y + padding), 0xFFFFFF);
                mc.field_71466_p.func_175063_a(artist, (float)(textLeft + diffArtist), (float)(y + 10 + padding), 0xDDDDDD);
                if (showVolume) {
                    mc.field_71466_p.func_175063_a(volume, (float)(textLeft + diffVolume), (float)(y + 20 + padding), 0xDDDDDD);
                }
            }
        }
    }

    private void renderSpectrumAnalyzer(Minecraft mc, int x, int y, int width, int height, int color) {
        float[] wFFT = SpectrumTools.getFFTCalculation();
        if (wFFT == null) {
            return;
        }
        int bandWidth = (int)((float)width / 32.0f);
        float multiplier = 1.0f;
        int lightColor = 0xFF000000 | color;
        int darkColor = new Color(lightColor).darker().getRGB();
        for (int i = 0; i < 16; ++i) {
            float wFs = 0.0f;
            int j = 0;
            while ((float)j < multiplier) {
                wFs += wFFT[i + j];
                ++j;
            }
            if ((wFs *= (float)Math.log(i + 2)) > 1.0f) {
                wFs = 1.0f;
            }
            if (wFs >= this.oldFFT[i] - 0.03f) {
                this.oldFFT[i] = wFs;
            } else {
                int n = i;
                this.oldFFT[n] = this.oldFFT[n] - 0.03f;
                if (this.oldFFT[i] < 0.0f) {
                    this.oldFFT[i] = 0.0f;
                }
                wFs = this.oldFFT[i];
            }
            int bHeight = (int)((float)height * wFs) + 1;
            Gui.func_73734_a((int)(x + i), (int)(y - bHeight), (int)(x + bandWidth + i), (int)y, (int)(i % 2 == 0 ? lightColor : darkColor));
            x += bandWidth;
        }
    }

    private static boolean shouldRenderHUD() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && mc.field_71462_r instanceof GuiMoveHUD) {
            return true;
        }
        return MTConfig.hudEnabled;
    }

    public static Point getCoords(int screenX, int screenY, int relativePos, int posX, int posY) {
        switch (relativePos) {
            case 0: {
                return new Point(screenX - posX, posY);
            }
            case 1: {
                return new Point(posX, posY);
            }
            case 2: {
                return new Point(posX, screenY - posY);
            }
        }
        return new Point(screenX - posX, screenY - posY);
    }
}

