/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.playlist;

import com.mpatric.mp3agic.ID3Wrapper;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.Mp3File;
import com.mpatric.mp3agic.UnsupportedTagException;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class MP3Metadata
implements Comparable<MP3Metadata> {
    private static final String TAG_ARTIST = "artist";
    private static final String TAG_TITLE = "title";
    private static final String TAG_ALBUM = "album";
    private static final String TAG_GENRE = "genre";
    private static final String TAG_FILENAME = "filename";
    private static final String TAG_LENGTH = "length";
    private static final String TAG_LENGTHMS = "lengthMs";
    private static final String TAG_FRAME_COUNT = "frameCount";
    private static final String TAG_FILE_PATH = "filepath";
    public final File file;
    public final String artist;
    public final String title;
    public final String album;
    public final String genre;
    public final String filename;
    public final String length;
    public final long lengthMs;
    public final int frameCount;

    public MP3Metadata(File file, Mp3File mp3) {
        this.file = file;
        this.filename = file.getName();
        ID3Wrapper id3 = new ID3Wrapper(mp3.getId3v1Tag(), mp3.getId3v2Tag());
        String artist = id3.getArtist();
        String title = id3.getTitle();
        String album = id3.getAlbum();
        String genre = id3.getGenreDescription();
        if (artist == null || title == null || artist.isEmpty() || title.isEmpty()) {
            this.artist = "";
            this.title = this.filename.replace(".mp3", "");
        } else {
            this.artist = artist;
            this.title = title;
        }
        this.album = album == null || album.isEmpty() ? "(No Album)" : album;
        this.genre = genre == null || genre.isEmpty() ? "(Genre not Defined)" : genre;
        this.lengthMs = mp3.getLengthInMilliseconds();
        this.length = MP3Metadata.getLengthStr(this.lengthMs);
        this.frameCount = mp3.getFrameCount();
    }

    public MP3Metadata(File file) throws UnsupportedTagException, InvalidDataException, IOException {
        this(file, new Mp3File(file));
    }

    public MP3Metadata(NBTTagCompound cmp) {
        this.artist = cmp.func_74779_i(TAG_ARTIST);
        this.title = cmp.func_74779_i(TAG_TITLE);
        this.album = cmp.func_74779_i(TAG_ALBUM);
        this.genre = cmp.func_74779_i(TAG_GENRE);
        this.filename = cmp.func_74779_i(TAG_FILENAME);
        this.length = cmp.func_74779_i(TAG_LENGTH);
        this.lengthMs = cmp.func_74763_f(TAG_LENGTHMS);
        this.frameCount = cmp.func_74762_e(TAG_FRAME_COUNT);
        this.file = new File(cmp.func_74779_i(TAG_FILE_PATH));
    }

    public void writeToNBT(NBTTagCompound cmp) {
        cmp.func_74778_a(TAG_ARTIST, this.artist);
        cmp.func_74778_a(TAG_TITLE, this.title);
        cmp.func_74778_a(TAG_ALBUM, this.album);
        cmp.func_74778_a(TAG_GENRE, this.genre);
        cmp.func_74778_a(TAG_FILENAME, this.filename);
        cmp.func_74778_a(TAG_LENGTH, this.length);
        cmp.func_74772_a(TAG_LENGTHMS, this.lengthMs);
        cmp.func_74768_a(TAG_FRAME_COUNT, this.frameCount);
        cmp.func_74778_a(TAG_FILE_PATH, this.file.getAbsolutePath());
    }

    public static String getLengthStr(long ms) {
        int m = (int)(ms / 60000L);
        int s = (int)(ms / 1000L % 60L);
        return String.format("%d:%02d", m, s);
    }

    public boolean isEqualFile(MP3Metadata data) {
        return this == data || data.file == this.file || data.file.getAbsolutePath().equals(this.file.getAbsolutePath());
    }

    public String getFullName() {
        return this.artist + " - " + this.title;
    }

    public String getSortingKey() {
        return (this.title + this.artist + this.album).toLowerCase();
    }

    @Override
    public int compareTo(MP3Metadata o) {
        return this.getSortingKey().compareTo(o.getSortingKey());
    }
}

