/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.EncodedText;
import com.mpatric.mp3agic.InvalidDataException;
import java.io.UnsupportedEncodingException;

public class ID3v2CommentFrameData
extends AbstractID3v2FrameData {
    private static final String DEFAULT_LANGUAGE = "eng";
    private String language;
    private EncodedText description;
    private EncodedText comment;

    public ID3v2CommentFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2CommentFrameData(boolean unsynchronisation, String language, EncodedText description, EncodedText comment) {
        super(unsynchronisation);
        this.language = language;
        this.description = description;
        this.comment = comment;
    }

    public ID3v2CommentFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        try {
            this.language = BufferTools.byteBufferToString(bytes, 1, 3);
        }
        catch (UnsupportedEncodingException e) {
            this.language = "";
        }
        int marker = BufferTools.indexOfTerminatorForEncoding(bytes, 4, bytes[0]);
        if (marker >= 4) {
            this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 4, marker - 4));
            marker += this.description.getTerminator().length;
        } else {
            this.description = new EncodedText(bytes[0], "");
            marker = 4;
        }
        this.comment = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, marker, bytes.length - marker));
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        bytes[0] = this.comment != null ? this.comment.getTextEncoding() : (byte)0;
        String langPadded = this.language == null ? DEFAULT_LANGUAGE : (this.language.length() > 3 ? this.language.substring(0, 3) : BufferTools.padStringRight(this.language, 3, '\u0000'));
        try {
            BufferTools.stringIntoByteBuffer(langPadded, 0, 3, bytes, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int marker = 4;
        if (this.description != null) {
            byte[] descriptionBytes = this.description.toBytes(true, true);
            BufferTools.copyIntoByteBuffer(descriptionBytes, 0, descriptionBytes.length, bytes, marker);
            marker += descriptionBytes.length;
        } else {
            bytes[marker++] = 0;
        }
        if (this.comment != null) {
            byte[] commentBytes = this.comment.toBytes(true, false);
            BufferTools.copyIntoByteBuffer(commentBytes, 0, commentBytes.length, bytes, marker);
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 4;
        length = this.description != null ? (length += this.description.toBytes(true, true).length) : ++length;
        if (this.comment != null) {
            length += this.comment.toBytes(true, false).length;
        }
        return length;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public EncodedText getComment() {
        return this.comment;
    }

    public void setComment(EncodedText comment) {
        this.comment = comment;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText description) {
        this.description = description;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2CommentFrameData other = (ID3v2CommentFrameData)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.language == null ? other.language != null : !this.language.equals(other.language));
    }
}

