/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.FileWrapper;
import com.mpatric.mp3agic.ID3v1;
import com.mpatric.mp3agic.ID3v1Tag;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.ID3v2TagFactory;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.MpegFrame;
import com.mpatric.mp3agic.MutableInteger;
import com.mpatric.mp3agic.NoSuchTagException;
import com.mpatric.mp3agic.NotSupportedException;
import com.mpatric.mp3agic.UnsupportedTagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class Mp3File
extends FileWrapper {
    private static final int DEFAULT_BUFFER_LENGTH = 65536;
    private static final int MINIMUM_BUFFER_LENGTH = 40;
    private static final int XING_MARKER_OFFSET_1 = 13;
    private static final int XING_MARKER_OFFSET_2 = 21;
    private static final int XING_MARKER_OFFSET_3 = 36;
    protected int bufferLength;
    private int xingOffset = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private int frameCount = 0;
    private Map<Integer, MutableInteger> bitrates = new HashMap<Integer, MutableInteger>();
    private int xingBitrate;
    private double bitrate = 0.0;
    private String channelMode;
    private String emphasis;
    private String layer;
    private String modeExtension;
    private int sampleRate;
    private boolean copyright;
    private boolean original;
    private String version;
    private ID3v1 id3v1Tag;
    private ID3v2 id3v2Tag;
    private byte[] customTag;
    private boolean scanFile;

    protected Mp3File() {
    }

    public Mp3File(String filename) throws IOException, UnsupportedTagException, InvalidDataException {
        this(filename, 65536, true);
    }

    public Mp3File(String filename, int bufferLength) throws IOException, UnsupportedTagException, InvalidDataException {
        this(filename, bufferLength, true);
    }

    public Mp3File(String filename, boolean scanFile) throws IOException, UnsupportedTagException, InvalidDataException {
        this(filename, 65536, scanFile);
    }

    public Mp3File(String filename, int bufferLength, boolean scanFile) throws IOException, UnsupportedTagException, InvalidDataException {
        super(filename);
        this.init(bufferLength, scanFile);
    }

    public Mp3File(File file) throws IOException, UnsupportedTagException, InvalidDataException {
        this(file, 65536, true);
    }

    public Mp3File(File file, int bufferLength) throws IOException, UnsupportedTagException, InvalidDataException {
        this(file, bufferLength, true);
    }

    public Mp3File(File file, int bufferLength, boolean scanFile) throws IOException, UnsupportedTagException, InvalidDataException {
        super(file);
        this.init(bufferLength, scanFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int bufferLength, boolean scanFile) throws IOException, UnsupportedTagException, InvalidDataException {
        if (bufferLength < 41) {
            throw new IllegalArgumentException("Buffer too small");
        }
        this.bufferLength = bufferLength;
        this.scanFile = scanFile;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file.getPath(), "r");
        try {
            this.initId3v1Tag(randomAccessFile);
            this.scanFile(randomAccessFile);
            if (this.startOffset < 0) {
                throw new InvalidDataException("No mpegs frames found");
            }
            this.initId3v2Tag(randomAccessFile);
            if (scanFile) {
                this.initCustomTag(randomAccessFile);
            }
        }
        finally {
            randomAccessFile.close();
        }
    }

    protected int preScanFile(RandomAccessFile file) {
        block5: {
            byte[] bytes = new byte[10];
            try {
                file.seek(0L);
                int bytesRead = file.read(bytes, 0, 10);
                if (bytesRead != 10) break block5;
                try {
                    ID3v2TagFactory.sanityCheckTag(bytes);
                    return 10 + BufferTools.unpackSynchsafeInteger(bytes[6], bytes[7], bytes[8], bytes[9]);
                }
                catch (NoSuchTagException noSuchTagException) {
                }
                catch (UnsupportedTagException unsupportedTagException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void scanFile(RandomAccessFile file) throws IOException, InvalidDataException {
        byte[] bytes = new byte[this.bufferLength];
        int fileOffset = this.preScanFile(file);
        file.seek(fileOffset);
        boolean lastBlock = false;
        int lastOffset = fileOffset;
        while (!lastBlock) {
            int bytesRead = file.read(bytes, 0, this.bufferLength);
            if (bytesRead < this.bufferLength) {
                lastBlock = true;
            }
            if (bytesRead < 40) continue;
            try {
                int offset = 0;
                if (this.startOffset < 0) {
                    offset = this.scanBlockForStart(bytes, bytesRead, fileOffset, offset);
                    if (this.startOffset >= 0 && !this.scanFile) {
                        return;
                    }
                    lastOffset = this.startOffset;
                }
                offset = this.scanBlock(bytes, bytesRead, fileOffset, offset);
                file.seek(fileOffset += offset);
            }
            catch (InvalidDataException e) {
                if (this.frameCount < 2) {
                    this.startOffset = -1;
                    this.xingOffset = -1;
                    this.frameCount = 0;
                    this.bitrates.clear();
                    lastBlock = false;
                    fileOffset = lastOffset + 1;
                    if (fileOffset == 0) {
                        throw new InvalidDataException("Valid start of mpeg frames not found", e);
                    }
                    file.seek(fileOffset);
                    continue;
                }
                return;
            }
        }
    }

    private int scanBlockForStart(byte[] bytes, int bytesRead, int absoluteOffset, int offset) {
        while (offset < bytesRead - 40) {
            if (bytes[offset] == -1 && (bytes[offset + 1] & 0xFFFFFFE0) == -32) {
                try {
                    MpegFrame frame = new MpegFrame(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
                    if (this.xingOffset < 0 && this.isXingFrame(bytes, offset)) {
                        this.xingOffset = absoluteOffset + offset;
                        this.xingBitrate = frame.getBitrate();
                        offset += frame.getLengthInBytes();
                        continue;
                    }
                    this.startOffset = absoluteOffset + offset;
                    this.channelMode = frame.getChannelMode();
                    this.emphasis = frame.getEmphasis();
                    this.layer = frame.getLayer();
                    this.modeExtension = frame.getModeExtension();
                    this.sampleRate = frame.getSampleRate();
                    this.version = frame.getVersion();
                    this.copyright = frame.isCopyright();
                    this.original = frame.isOriginal();
                    ++this.frameCount;
                    this.addBitrate(frame.getBitrate());
                    return offset += frame.getLengthInBytes();
                }
                catch (InvalidDataException e) {
                    ++offset;
                    continue;
                }
            }
            ++offset;
        }
        return offset;
    }

    private int scanBlock(byte[] bytes, int bytesRead, int absoluteOffset, int offset) throws InvalidDataException {
        while (offset < bytesRead - 40) {
            MpegFrame frame = new MpegFrame(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
            this.sanityCheckFrame(frame, absoluteOffset + offset);
            int newEndOffset = absoluteOffset + offset + frame.getLengthInBytes() - 1;
            if (newEndOffset >= this.maxEndOffset()) break;
            this.endOffset = absoluteOffset + offset + frame.getLengthInBytes() - 1;
            ++this.frameCount;
            this.addBitrate(frame.getBitrate());
            offset += frame.getLengthInBytes();
        }
        return offset;
    }

    private int maxEndOffset() {
        int maxEndOffset = (int)this.getLength();
        if (this.hasId3v1Tag()) {
            maxEndOffset -= 128;
        }
        return maxEndOffset;
    }

    private boolean isXingFrame(byte[] bytes, int offset) {
        if (bytes.length >= offset + 13 + 3) {
            if ("Xing".equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, offset + 13, 4))) {
                return true;
            }
            if ("Info".equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, offset + 13, 4))) {
                return true;
            }
            if (bytes.length >= offset + 21 + 3) {
                if ("Xing".equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, offset + 21, 4))) {
                    return true;
                }
                if ("Info".equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, offset + 21, 4))) {
                    return true;
                }
                if (bytes.length >= offset + 36 + 3) {
                    if ("Xing".equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, offset + 36, 4))) {
                        return true;
                    }
                    if ("Info".equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, offset + 36, 4))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void sanityCheckFrame(MpegFrame frame, int offset) throws InvalidDataException {
        if (this.sampleRate != frame.getSampleRate()) {
            throw new InvalidDataException("Inconsistent frame header");
        }
        if (!this.layer.equals(frame.getLayer())) {
            throw new InvalidDataException("Inconsistent frame header");
        }
        if (!this.version.equals(frame.getVersion())) {
            throw new InvalidDataException("Inconsistent frame header");
        }
        if ((long)(offset + frame.getLengthInBytes()) > this.getLength()) {
            throw new InvalidDataException("Frame would extend beyond end of file");
        }
    }

    private void addBitrate(int bitrate) {
        Integer key = new Integer(bitrate);
        MutableInteger count = this.bitrates.get(key);
        if (count != null) {
            count.increment();
        } else {
            this.bitrates.put(key, new MutableInteger(1));
        }
        this.bitrate = (this.bitrate * (double)(this.frameCount - 1) + (double)bitrate) / (double)this.frameCount;
    }

    private void initId3v1Tag(RandomAccessFile file) throws IOException {
        byte[] bytes = new byte[128];
        file.seek(this.getLength() - 128L);
        int bytesRead = file.read(bytes, 0, 128);
        if (bytesRead < 128) {
            throw new IOException("Not enough bytes read");
        }
        try {
            this.id3v1Tag = new ID3v1Tag(bytes);
        }
        catch (NoSuchTagException e) {
            this.id3v1Tag = null;
        }
    }

    private void initId3v2Tag(RandomAccessFile file) throws IOException, UnsupportedTagException, InvalidDataException {
        if (this.xingOffset == 0 || this.startOffset == 0) {
            this.id3v2Tag = null;
        } else {
            int bufferLength = this.hasXingFrame() ? this.xingOffset : this.startOffset;
            byte[] bytes = new byte[bufferLength];
            file.seek(0L);
            int bytesRead = file.read(bytes, 0, bufferLength);
            if (bytesRead < bufferLength) {
                throw new IOException("Not enough bytes read");
            }
            try {
                this.id3v2Tag = ID3v2TagFactory.createTag(bytes);
            }
            catch (NoSuchTagException e) {
                this.id3v2Tag = null;
            }
        }
    }

    private void initCustomTag(RandomAccessFile file) throws IOException {
        int bufferLength = (int)(this.getLength() - (long)(this.endOffset + 1));
        if (this.hasId3v1Tag()) {
            bufferLength -= 128;
        }
        if (bufferLength <= 0) {
            this.customTag = null;
        } else {
            this.customTag = new byte[bufferLength];
            file.seek(this.endOffset + 1);
            int bytesRead = file.read(this.customTag, 0, bufferLength);
            if (bytesRead < bufferLength) {
                throw new IOException("Not enough bytes read");
            }
        }
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public long getLengthInMilliseconds() {
        double d = 8 * (this.endOffset - this.startOffset);
        return (long)(d / this.bitrate + 0.5);
    }

    public long getLengthInSeconds() {
        return (this.getLengthInMilliseconds() + 500L) / 1000L;
    }

    public boolean isVbr() {
        return this.bitrates.size() > 1;
    }

    public int getBitrate() {
        return (int)(this.bitrate + 0.5);
    }

    public Map<Integer, MutableInteger> getBitrates() {
        return this.bitrates;
    }

    public String getChannelMode() {
        return this.channelMode;
    }

    public boolean isCopyright() {
        return this.copyright;
    }

    public String getEmphasis() {
        return this.emphasis;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getModeExtension() {
        return this.modeExtension;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasXingFrame() {
        return this.xingOffset >= 0;
    }

    public int getXingOffset() {
        return this.xingOffset;
    }

    public int getXingBitrate() {
        return this.xingBitrate;
    }

    public boolean hasId3v1Tag() {
        return this.id3v1Tag != null;
    }

    public ID3v1 getId3v1Tag() {
        return this.id3v1Tag;
    }

    public void setId3v1Tag(ID3v1 id3v1Tag) {
        this.id3v1Tag = id3v1Tag;
    }

    public void removeId3v1Tag() {
        this.id3v1Tag = null;
    }

    public boolean hasId3v2Tag() {
        return this.id3v2Tag != null;
    }

    public ID3v2 getId3v2Tag() {
        return this.id3v2Tag;
    }

    public void setId3v2Tag(ID3v2 id3v2Tag) {
        this.id3v2Tag = id3v2Tag;
    }

    public void removeId3v2Tag() {
        this.id3v2Tag = null;
    }

    public boolean hasCustomTag() {
        return this.customTag != null;
    }

    public byte[] getCustomTag() {
        return this.customTag;
    }

    public void setCustomTag(byte[] customTag) {
        this.customTag = customTag;
    }

    public void removeCustomTag() {
        this.customTag = null;
    }

    public void save(String newFilename) throws IOException, NotSupportedException {
        if (this.file.compareTo(new File(newFilename)) == 0) {
            throw new IllegalArgumentException("Save filename same as source filename");
        }
        RandomAccessFile saveFile = new RandomAccessFile(newFilename, "rw");
        try {
            if (this.hasId3v2Tag()) {
                saveFile.write(this.id3v2Tag.toBytes());
            }
            this.saveMpegFrames(saveFile);
            if (this.hasCustomTag()) {
                saveFile.write(this.customTag);
            }
            if (this.hasId3v1Tag()) {
                saveFile.write(this.id3v1Tag.toBytes());
            }
        }
        finally {
            saveFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMpegFrames(RandomAccessFile saveFile) throws IOException {
        int filePos = this.xingOffset;
        if (filePos < 0) {
            filePos = this.startOffset;
        }
        if (filePos < 0) {
            return;
        }
        if (this.endOffset < filePos) {
            return;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file.getPath(), "r");
        byte[] bytes = new byte[this.bufferLength];
        try {
            int bytesRead;
            randomAccessFile.seek(filePos);
            while (filePos + (bytesRead = randomAccessFile.read(bytes, 0, this.bufferLength)) <= this.endOffset) {
                saveFile.write(bytes, 0, bytesRead);
                filePos += bytesRead;
            }
            saveFile.write(bytes, 0, this.endOffset - filePos + 1);
        }
        finally {
            randomAccessFile.close();
        }
    }
}

