/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;
import vazkii.minetunes.MineTunes;
import vazkii.minetunes.gui.GuiPlaylistManager;
import vazkii.minetunes.gui.GuiScrollingListMT;
import vazkii.minetunes.player.chooser.action.ActionPlayMp3;
import vazkii.minetunes.playlist.MP3Metadata;
import vazkii.minetunes.playlist.Playlist;

public class GuiMusicSlot
extends GuiScrollingListMT {
    GuiPlaylistManager parent;

    public GuiMusicSlot(GuiPlaylistManager parent) {
        super(parent.field_146294_l - 200, parent.field_146295_m - parent.getTopSize(), parent.getTopSize(), 200, 40);
        this.parent = parent;
    }

    protected int getSize() {
        Playlist playlist = this.parent.getSelectedPlaylist();
        return playlist == null ? 0 : playlist.metadataList.size();
    }

    protected void elementClicked(int i, boolean doubleclick) {
        if (doubleclick) {
            int index = this.parent.getSelectedPlaylistIndex();
            Playlist playlist = this.parent.getSelectedPlaylist();
            if (playlist != null) {
                MP3Metadata metadata = playlist.metadataList.get(i);
                ActionPlayMp3.instance.play(metadata);
                GuiPlaylistManager.selectCurrentPlaylist(index, i);
            }
        }
        this.parent.selectSong(i);
    }

    protected boolean isSelected(int i) {
        return this.parent.getSelectedSong() == i;
    }

    protected void drawSlot(int i, int j, int k, int l, Tessellator tessellator) {
        MP3Metadata metadata;
        Playlist playlist = this.parent.getSelectedPlaylist();
        if (playlist != null && (metadata = playlist.metadataList.get(i)) != null) {
            int colorSub;
            MP3Metadata playingMeta;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            boolean selected = this.isSelected(i);
            int s = j + 20 - this.listWidth;
            boolean playing = false;
            float playedFraction = 0.0f;
            boolean paused = false;
            if (MineTunes.musicPlayerThread != null && (playingMeta = MineTunes.musicPlayerThread.getPlayingMetadata()) != null && playingMeta.isEqualFile(metadata)) {
                playing = true;
                playedFraction = MineTunes.musicPlayerThread.getFractionPlayed();
                paused = MineTunes.musicPlayerThread.isPaused();
            }
            int colorMain = playing ? 0xAAFFFF : 0xFFFFFF;
            int n = colorSub = playing ? 43690 : 0xAAAAAA;
            int colorLength = playing ? (paused ? 0xFF5555 : 0x55FF55) : 0x555555;
            int colorBg = 0x44000000;
            if (!selected) {
                this.parent.drawBox(s - 6, k + 2, this.listWidth + 6, 32);
            }
            font.func_175063_a(metadata.title, (float)s, (float)(k + 3), colorMain);
            font.func_175063_a(metadata.artist, (float)(s + 4), (float)(k + 13), colorSub);
            font.func_175063_a(metadata.album, (float)(s + 4), (float)(k + 23), colorSub);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            String length = metadata.length;
            if (playing) {
                length = MP3Metadata.getLengthStr((int)((float)metadata.lengthMs * playedFraction)) + "/" + length;
            }
            font.func_78276_b(length, (j - 2) / 2 - font.func_78256_a(length), (k + 6) / 2, colorLength);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }
}

