/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.player;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.JavaSoundAudioDevice;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;
import vazkii.minetunes.gui.GuiDevTools;
import vazkii.minetunes.gui.GuiPlaylistManager;
import vazkii.minetunes.playlist.MP3Metadata;
import vazkii.minetunes.playlist.Playlist;

public class ThreadMusicPlayer
extends Thread {
    public static final float MIN_GAIN = -20.0f;
    public static final float MAX_GAIN = 0.0f;
    public static final float MED_GAIN;
    public static volatile float gain;
    EventListener listener = new EventListener();
    AdvancedPlayer player;
    volatile MP3Metadata playingMP3;
    volatile boolean queued = false;
    volatile boolean kill = false;
    volatile boolean playing = false;
    volatile boolean paused = false;
    volatile int pauseFrames = 0;
    volatile List<MP3Metadata> lastSongs = new ArrayList<MP3Metadata>();

    public ThreadMusicPlayer() {
        this.setDaemon(true);
        this.setName("mineTunes Player Thread");
        this.start();
    }

    @Override
    public void run() {
        try {
            GuiDevTools.debugLog("Starting " + this);
            while (!this.kill) {
                if (this.queued && this.playingMP3 != null) {
                    GuiDevTools.debugLog("Queued: " + this.playingMP3.file.getAbsolutePath());
                    if (this.player != null) {
                        this.resetPlayer();
                    }
                    this.player = new AdvancedPlayer(new FileInputStream(this.playingMP3.file));
                    this.player.setPlayBackListener(this.listener);
                    this.queued = false;
                    GuiDevTools.debugLog("Player (Re)loaded");
                }
                boolean played = false;
                if (this.player != null && this.player.getAudioDevice() != null) {
                    if (this.pauseFrames == 0) {
                        GuiDevTools.debugLog("Playing File");
                        this.player.play();
                        this.playing = true;
                    } else if (!this.paused) {
                        GuiDevTools.debugLog("Was paused, restarting at " + this.pauseFrames);
                        int startFrame = this.pauseFrames;
                        this.pauseFrames = 0;
                        this.player.play(startFrame, Integer.MAX_VALUE);
                        this.playing = true;
                    }
                    played = true;
                }
                if (!played || this.paused || this.queued) continue;
                GuiDevTools.debugLog("Song done, next...");
                this.next();
            }
        }
        catch (Exception e) {
            GuiDevTools.logThrowable(e);
        }
    }

    public void next() {
        this.next(true);
    }

    public void next(boolean add) {
        MP3Metadata mp3;
        Playlist playlist = GuiPlaylistManager.getCurrentPlaylist();
        MP3Metadata mP3Metadata = mp3 = playlist == null ? null : playlist.nextSong();
        if (mp3 != null) {
            this.play(mp3, add);
        } else {
            this.playingMP3 = null;
            this.resetPlayer();
        }
    }

    public void prev() {
        if (this.lastSongs.size() < 2) {
            return;
        }
        this.removeFromLastPlayed(this.lastSongs.get(this.lastSongs.size() - 1));
        MP3Metadata meta = this.lastSongs.get(this.lastSongs.size() - 1);
        this.play(meta, false);
    }

    public void resetPlayer() {
        GuiDevTools.debugLog("Resetting Player.");
        this.playing = false;
        if (this.player != null) {
            this.player.close();
        }
        this.player = null;
    }

    public void play(MP3Metadata metadata) {
        this.play(metadata, true);
    }

    public void play(MP3Metadata metadata, boolean add) {
        this.resetPlayer();
        if (add) {
            this.addToLastPlayed(metadata);
        }
        this.playingMP3 = metadata;
        this.paused = false;
        this.queued = true;
    }

    private void addToLastPlayed(MP3Metadata meta) {
        this.lastSongs.add(meta);
        while (this.lastSongs.size() > 10) {
            this.lastSongs.remove(0);
        }
    }

    private void removeFromLastPlayed(MP3Metadata meta) {
        this.lastSongs.remove(meta);
    }

    public void pauseOrPlay() {
        if (this.player != null) {
            if (!this.paused) {
                GuiDevTools.debugLog("Pausing...");
                this.paused = true;
                if (this.player.getAudioDevice() != null) {
                    this.player.stop();
                }
            } else {
                GuiDevTools.debugLog("Unpaused...");
                this.queued = true;
                this.paused = false;
            }
        }
    }

    public void onPlaylistChange() {
        this.lastSongs.clear();
    }

    public float getGain() {
        if (this.player == null) {
            return gain;
        }
        AudioDevice device = this.player.getAudioDevice();
        if (device != null && device instanceof JavaSoundAudioDevice) {
            return ((JavaSoundAudioDevice)device).getGain();
        }
        return gain;
    }

    public void addGain(float gain) {
        this.setGain(this.getGain() + gain);
    }

    public void setGain(float gain) {
        if (this.player == null) {
            return;
        }
        ThreadMusicPlayer.gain = Math.min(0.0f, Math.max(-20.0f, gain));
        AudioDevice device = this.player.getAudioDevice();
        if (device != null && device instanceof JavaSoundAudioDevice) {
            ((JavaSoundAudioDevice)device).setGain(ThreadMusicPlayer.gain);
        }
    }

    public float getRelativeVolume() {
        return this.getRelativeVolume(this.getGain());
    }

    public float getRelativeVolume(float gain) {
        float width = 20.0f;
        float rel = Math.abs(gain - -20.0f);
        return rel / Math.abs(width);
    }

    public MP3Metadata getPlayingMetadata() {
        return this.playingMP3;
    }

    public int getFramesPlayed() {
        return this.player == null ? 0 : this.player.getFrames();
    }

    public float getFractionPlayed() {
        int tFrames;
        int pFrames = this.getFramesPlayed();
        int n = tFrames = this.playingMP3 == null ? 0 : this.playingMP3.frameCount;
        if (pFrames == 0 || tFrames == 0) {
            return 0.0f;
        }
        return (float)pFrames / (float)tFrames;
    }

    public boolean isPaused() {
        return this.paused && this.playingMP3 != null;
    }

    public void forceKill() {
        try {
            this.resetPlayer();
            this.interrupt();
            this.finalize();
            this.kill = true;
        }
        catch (Throwable e) {
            GuiDevTools.logThrowable(e);
        }
    }

    static {
        gain = MED_GAIN = 10.0f * (Math.abs(-20.0f) / -20.0f);
    }

    class EventListener
    extends PlaybackListener {
        EventListener() {
        }

        @Override
        public void playbackFinished(PlaybackEvent evt) {
            if (ThreadMusicPlayer.this.paused) {
                ThreadMusicPlayer.this.pauseFrames = evt.getSource().getFrames();
                GuiDevTools.debugLog("Paused at " + ThreadMusicPlayer.this.pauseFrames);
            }
        }
    }
}

